/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui;

import io.github.maki99999.biomebeats.BiomeBeatsCommon;
import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.BiomeCondition;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.NoOtherMusicCondition;
import io.github.maki99999.biomebeats.config.ConfigChangeListener;
import io.github.maki99999.biomebeats.config.MainConfig;
import io.github.maki99999.biomebeats.gui.BaseTextureUv;
import io.github.maki99999.biomebeats.gui.CombinedConditionConfigScreen;
import io.github.maki99999.biomebeats.gui.GeneralConfigScreen;
import io.github.maki99999.biomebeats.gui.common.Button;
import io.github.maki99999.biomebeats.gui.common.EditBoxWrapper;
import io.github.maki99999.biomebeats.gui.common.ForwardingScreen;
import io.github.maki99999.biomebeats.gui.common.ImageButton;
import io.github.maki99999.biomebeats.gui.common.LayeredImageButton;
import io.github.maki99999.biomebeats.gui.common.TwoStateImageButton;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.conditionlist.ConditionList;
import io.github.maki99999.biomebeats.gui.musiclist.MusicList;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import io.github.maki99999.biomebeats.music.MusicGroup;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.service.Services;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends UiElement
implements ConfigChangeListener {
    private static final int MAX_WIDTH = 400;
    private static final int MAX_HEIGHT = 400;
    private static final int SIDES_PADDING = 60;
    private static final int BORDER_PADDING = 4;
    private static final int ELEMENT_HEIGHT = 17;
    private static final int ELEMENT_SPACING = 4;
    private static final Collection<MusicTrack> NO_MUSIC_TRACKS = Set.of();
    private final Map<TabType, Collection<? extends Condition>> sortedFilteredConditions = new HashMap<TabType, Collection<? extends Condition>>();
    private final Set<String> collapsedMusicGroups = new HashSet<String>();
    private MainConfig config;
    private Map<TwoStateImageButton, TabType> tabs;
    private ConditionList conditionList;
    private MusicList musicList;
    private EditBoxWrapper conditionSearchBox;
    private EditBoxWrapper musicSearchBox;
    private EditBoxWrapper priorityField;
    private Rect bounds;
    private Rect boundsL;
    private Rect boundsR;
    private Rect addonBounds;
    private LayeredImageButton addCombinedConditionBtn;
    private Collection<MusicGroup> musicGroups;
    private Map<Condition, Collection<MusicTrack>> musicTracksByCondition;
    private Map<TabType, Collection<? extends Condition>> conditions;
    private boolean initialInitCall = true;
    private TabType currentTab = TabType.BY_BIOME;
    private Condition currentCondition = null;

    public ConfigScreen() {
        super((Component)Component.m_237113_((String)"BiomeBeats config screen"));
        Constants.CONFIG_IO.addListener(this);
    }

    @Override
    protected void init() {
        if (this.initialInitCall) {
            this.initialInitCall = false;
            Constants.MUSIC_MANAGER.startPreviewMode();
            this.initData();
        }
        if (this.getMinecraft() == null) {
            return;
        }
        int w = Math.min(this.getWidth() - 120, 400);
        int h = Math.min(this.getHeight(), 400);
        this.bounds = new Rect(60 + (this.getWidth() - 120 - w) / 2, (this.getHeight() - h) / 2, w, h);
        this.boundsL = new Rect(this.bounds.x() + 4, this.bounds.y() + 4, Mth.m_14143_((float)((float)(this.bounds.w() - 8) * 0.4f)), this.bounds.h() - 8);
        this.boundsR = new Rect(this.boundsL.x2() + 4, this.bounds.y() + 4, this.bounds.w() - 8 - this.boundsL.w() - 4, this.bounds.h() - 8);
        this.addonBounds = Rect.fromCoordinates(this.bounds.x1() - 18, this.bounds.y2() - 78, this.bounds.x1() + 1, this.bounds.y2());
        this.conditionSearchBox = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.search.condition"), new Rect(this.boundsL.x(), this.boundsL.y(), this.boundsL.w(), 17)));
        this.conditionSearchBox.setHint((Component)Component.m_237115_((String)"menu.biomebeats.search.condition"));
        this.conditionSearchBox.setResponder(this::onConditionSearchUpdate);
        this.conditionList = this.addChild(new ConditionList(this.getMinecraft(), new Rect(this.boundsL.x(), this.boundsL.y() + 17, this.boundsL.w(), this.boundsL.h() - 17), (Component)Component.m_237115_((String)"menu.biomebeats.search.condition"), this::onConditionSelected, this::openCombinedConditionScreen));
        this.updateCurrentConditions("");
        this.priorityField = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.priority"), new Rect(this.boundsR.x2() - 60, this.boundsR.y(), 60, 17)));
        this.priorityField.setHint((Component)Component.m_237113_((String)"0"));
        this.priorityField.setResponder(this::onPriorityUpdate);
        this.priorityField.setFilter(s -> s.matches("^[+-]?\\d{1,9}$"));
        this.musicSearchBox = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.search.music"), new Rect(this.boundsR.x(), this.boundsR.y() + 17 + 4, this.boundsR.w(), 17)));
        this.musicSearchBox.setHint((Component)Component.m_237115_((String)"menu.biomebeats.search.music"));
        this.musicSearchBox.setResponder(this::onMusicSearchUpdate);
        this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.open_music_folder"), (Component)Component.m_237115_((String)"menu.biomebeats.open_music_folder"), this.addonBounds.x() + 4, this.addonBounds.y() + 4, BaseTextureUv.FOLDER_UV, this::onFolderPress));
        this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.reload"), (Component)Component.m_237115_((String)"menu.biomebeats.reload"), this.addonBounds.x() + 4, this.addonBounds.y() + 22, BaseTextureUv.RELOAD_UV, this::onReloadPress));
        this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.settings"), (Component)Component.m_237115_((String)"menu.biomebeats.settings"), this.addonBounds.x() + 4, this.addonBounds.y() + 40, BaseTextureUv.SETTINGS_UV, this::onSettingsPress));
        this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.help"), (Component)Component.m_237115_((String)"menu.biomebeats.help"), this.addonBounds.x() + 4, this.addonBounds.y() + 58, BaseTextureUv.HELP_UV, this::onHelpPress));
        this.musicList = this.addChild(new MusicList(new Rect(this.boundsR.x(), this.boundsR.y() + 34 + 4, this.boundsR.w(), this.boundsR.h() - 34 - 4), (Component)Component.m_237115_((String)"menu.biomebeats.search.music"), this.musicGroups, this::onMusicTrackToggle, this::onMusicGroupToggle));
        this.tabs = new HashMap<TwoStateImageButton, TabType>();
        this.addTab(TabType.BY_BIOME, (Component)Component.m_237115_((String)"menu.biomebeats.by_biome"), this.bounds.x() - 57, this.bounds.y() + 4);
        this.addTab(TabType.BY_TAG, (Component)Component.m_237115_((String)"menu.biomebeats.by_tag"), this.bounds.x() - 57, this.bounds.y() + 26);
        this.addTab(TabType.BY_OTHER, (Component)Component.m_237115_((String)"menu.biomebeats.by_other"), this.bounds.x() - 57, this.bounds.y() + 48);
        this.addTab(TabType.COMBINED, (Component)Component.m_237115_((String)"menu.biomebeats.combined"), this.bounds.x() - 57, this.bounds.y() + 70);
        this.addCombinedConditionBtn = this.addChild(new LayeredImageButton((Component)Component.m_237115_((String)"menu.biomebeats.add"), (Component)Component.m_237115_((String)"menu.biomebeats.add"), this.boundsL.x2() - BaseTextureUv.PLUS_UV.w() - 2, this.boundsL.y2() - BaseTextureUv.PLUS_UV.h() - 2, BaseTextureUv.PLUS_UV, btn -> this.openCombinedConditionScreen(null)));
        this.addCombinedConditionBtn.setVisible(false);
        if (this.currentCondition == null) {
            this.onTabChanged();
        } else {
            this.setRightColumnVisibility(true);
            this.updateCheckedMusicTracks();
            this.onMusicSearchUpdate("");
        }
    }

    private void openCombinedConditionScreen(CombinedCondition combinedCondition) {
        if (this.getMinecraft() != null) {
            this.getMinecraft().m_91152_(null);
            this.getMinecraft().m_91152_(new ForwardingScreen<CombinedConditionConfigScreen>(new CombinedConditionConfigScreen(this, combinedCondition, this.conditions.values().stream().flatMap(Collection::stream).collect(Collectors.toList()))));
        }
    }

    private void updateCurrentConditions(String filter) {
        String cleanFilter = filter.trim().toLowerCase();
        if (this.currentTab == TabType.BY_BIOME) {
            List<ResourceLocation> recentBiomesRLs = Constants.BIOME_MANAGER.getMostRecentBiomes().stream().map(holder -> holder.m_203543_().map(ResourceKey::m_135782_).orElse(null)).filter(Objects::nonNull).toList();
            this.sortedFilteredConditions.put(TabType.BY_BIOME, this.conditions.get((Object)TabType.BY_BIOME).stream().filter(condition -> condition.getName().toLowerCase().contains(cleanFilter)).sorted(Comparator.comparingInt(c -> {
                if (c instanceof BiomeCondition) {
                    BiomeCondition bc = (BiomeCondition)c;
                    int index = recentBiomesRLs.indexOf(bc.getBiomeRl());
                    return index >= 0 ? index : Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE;
            }).thenComparing(c -> ((Collection)this.musicTracksByCondition.getOrDefault(c, Collections.emptyList())).isEmpty()).thenComparing(Condition::getName)).toList());
        } else {
            this.sortedFilteredConditions.put(this.currentTab, this.conditions.get((Object)this.currentTab).stream().filter(condition -> condition.getName().toLowerCase().contains(cleanFilter)).sorted(Comparator.comparing(Condition::isConditionMet).reversed().thenComparing(c -> ((Collection)this.musicTracksByCondition.getOrDefault(c, Collections.emptyList())).isEmpty()).thenComparing(Comparator.comparing(Condition::getPriority).reversed()).thenComparing(Condition::getName)).toList());
        }
        this.conditionList.setConditions(this.sortedFilteredConditions.get((Object)this.currentTab), this.currentCondition);
    }

    private void onReloadPress(Button imageButton) {
        Constants.CONFIG_IO.removeListener(this);
        Constants.CONFIG_IO.saveConfig(this.config);
        BiomeBeatsCommon.reload();
        if (this.getMinecraft() != null) {
            this.getMinecraft().m_91152_(new ForwardingScreen<ConfigScreen>(new ConfigScreen()));
        }
    }

    private void onSettingsPress(Button button) {
        if (this.getMinecraft() != null) {
            this.getMinecraft().m_91152_(new ForwardingScreen<GeneralConfigScreen>(new GeneralConfigScreen(this)));
        }
    }

    private void onHelpPress(Button button) {
        Util.m_137581_().m_137646_("https://maki99999.github.io/biome-beats-wiki/");
    }

    private void onFolderPress(Button imageButton) {
        Util.m_137581_().m_137648_(Services.PLATFORM.getModConfigFolder().resolve("music").toUri());
    }

    private void initData() {
        this.musicGroups = Constants.MUSIC_MANAGER.getMusicGroups();
        this.conditions = Map.ofEntries(Map.entry(TabType.BY_BIOME, Constants.CONDITION_MANAGER.getBiomeConditions()), Map.entry(TabType.BY_TAG, Constants.CONDITION_MANAGER.getTagConditions()), Map.entry(TabType.BY_OTHER, Constants.CONDITION_MANAGER.getOtherConditions()), Map.entry(TabType.COMBINED, Constants.CONDITION_MANAGER.getCombinedConditions()));
        this.musicTracksByCondition = Constants.CONDITION_MUSIC_MANAGER.getMusicTracksByCondition();
    }

    private void addTab(TabType tabType, Component text, int x, int y) {
        if (this.getMinecraft() == null) {
            return;
        }
        TwoStateImageButton tab = this.addChild(new TwoStateImageButton(text, null, x, y, new ImageButton(null, null, x, y, BaseTextureUv.TAB_LEFT_ACTIVE_UV, null), new ImageButton(null, null, x, y, BaseTextureUv.TAB_LEFT_INACTIVE_UV, null), this::onTabSelected, true));
        this.tabs.put(tab, tabType);
        tab.setState(this.currentTab == tabType);
    }

    private void onTabSelected(TwoStateImageButton tab, boolean newValue) {
        if (!newValue) {
            tab.toggle();
            return;
        }
        for (TwoStateImageButton otherTab : this.tabs.keySet()) {
            otherTab.setState(tab == otherTab);
        }
        this.currentTab = this.tabs.get(tab);
        this.onTabChanged();
    }

    private void onTabChanged() {
        this.addCombinedConditionBtn.setVisible(this.currentTab == TabType.COMBINED);
        this.updateCurrentConditions("");
        this.currentCondition = null;
        this.conditionSearchBox.setValue("");
        this.conditionList.setHeight(this.currentTab == TabType.COMBINED ? this.boundsL.h() - 34 - 4 : this.boundsL.h() - 17);
        this.setRightColumnVisibility(false);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, Point mousePos, float partialTick) {
        DrawUtils.drawContainer(guiGraphics, this.bounds);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, Rect.fromCoordinates(this.boundsL.x2() + 1, this.bounds.y() + 3, this.boundsR.x() - 1, this.bounds.y2() - 3), Rect.fromCoordinates(36, 0, 39, 3));
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, new Rect(this.addonBounds.x(), this.addonBounds.y(), 4, 4), BaseTextureUv.CONTAINER_UV_TL);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, new Rect(this.addonBounds.x(), this.addonBounds.y2() - 4, 4, 4), BaseTextureUv.CONTAINER_UV_BL);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, Rect.fromCoordinates(this.addonBounds.x(), this.addonBounds.y() + 4, this.addonBounds.x() + 4, this.addonBounds.y2() - 4), BaseTextureUv.CONTAINER_UV_L);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, Rect.fromCoordinates(this.addonBounds.x() + 4, this.addonBounds.y(), this.addonBounds.x2(), this.addonBounds.y() + 4), BaseTextureUv.CONTAINER_UV_T);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, Rect.fromCoordinates(this.addonBounds.x() + 4, this.addonBounds.y2() - 4, this.addonBounds.x2() + 2, this.addonBounds.y2()), BaseTextureUv.CONTAINER_UV_B);
        DrawUtils.drawRect(BaseTextureUv.RL, guiGraphics, Rect.fromCoordinates(this.addonBounds.x() + 4, this.addonBounds.y() + 3, this.addonBounds.x2() + 2, this.addonBounds.y2() - 4), BaseTextureUv.CONTAINER_UV_C);
        if (this.getMinecraft() != null && this.priorityField.isVisible()) {
            DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.priority"), new Rect(this.boundsR.x() + 4, this.boundsR.y(), this.boundsR.w() / 2, 17), BiomeBeatsColor.WHITE.getHex());
        }
    }

    @Override
    public void onClose() {
        Constants.MUSIC_MANAGER.stopPreviewMode();
        Constants.CONFIG_IO.removeListener(this);
        Constants.CONFIG_IO.saveConfig(this.config);
    }

    private void setRightColumnVisibility(boolean visible) {
        this.musicList.setVisible(visible);
        this.priorityField.setVisible(visible && !(this.currentCondition instanceof NoOtherMusicCondition));
        this.musicSearchBox.setVisible(visible);
    }

    private void updateCheckedMusicTracks() {
        this.musicList.setCheckedMusicTracks(this.musicTracksByCondition.getOrDefault(this.currentCondition, NO_MUSIC_TRACKS));
    }

    private void onMusicTrackToggle(MusicTrack musicTrack, boolean newValue) {
        if (newValue) {
            Constants.CONDITION_MUSIC_MANAGER.addTrackToCondition(this.currentCondition.getId(), musicTrack);
            this.musicTracksByCondition.computeIfAbsent(this.currentCondition, c -> new HashSet()).add(musicTrack);
        } else if (this.musicTracksByCondition.containsKey(this.currentCondition)) {
            Constants.CONDITION_MUSIC_MANAGER.removeTrackToCondition(this.currentCondition.getId(), musicTrack);
            this.musicTracksByCondition.get(this.currentCondition).remove(musicTrack);
        }
        this.updateCheckedMusicTracks();
    }

    private void onMusicGroupToggle(String musicGroup, boolean newValue) {
        if (newValue) {
            this.collapsedMusicGroups.add(musicGroup);
        } else {
            this.collapsedMusicGroups.remove(musicGroup);
        }
        this.musicList.sortAndFilterMusicTracks(this.musicSearchBox.getValue().trim().toLowerCase(), this.musicTracksByCondition.getOrDefault(this.currentCondition, NO_MUSIC_TRACKS), this.collapsedMusicGroups);
    }

    private void onConditionSelected(Condition condition) {
        this.currentCondition = condition;
        this.priorityField.setVisible(!(condition instanceof NoOtherMusicCondition));
        this.priorityField.setValue("" + condition.getPriority());
        this.setRightColumnVisibility(true);
        this.updateCheckedMusicTracks();
        this.onMusicSearchUpdate("");
    }

    private void onConditionSearchUpdate(String text) {
        this.updateCurrentConditions(text);
    }

    private void onMusicSearchUpdate(String text) {
        this.musicList.sortAndFilterMusicTracks(text.trim().toLowerCase(), this.musicTracksByCondition.getOrDefault(this.currentCondition, NO_MUSIC_TRACKS), this.collapsedMusicGroups);
    }

    private void onPriorityUpdate(String priorityText) {
        int priority;
        if (this.currentCondition == null) {
            return;
        }
        try {
            priority = Integer.parseInt(priorityText);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.currentCondition.setPriority(priority);
    }

    @Override
    public void beforeConfigChange(MainConfig config) {
    }

    @Override
    public void afterConfigChange(MainConfig config) {
        this.config = config;
        this.init();
    }

    public void returnToThisScreen() {
        this.currentCondition = null;
        if (this.getMinecraft() != null) {
            this.getMinecraft().m_91152_(new ForwardingScreen<ConfigScreen>(this));
        }
    }

    private static enum TabType {
        BY_BIOME,
        BY_TAG,
        BY_OTHER,
        COMBINED;

    }
}

