/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.gui;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.gui.ConfigScreen;
import io.github.maki99999.biomebeats.gui.common.EditBoxWrapper;
import io.github.maki99999.biomebeats.gui.common.MultiLineEditBoxWrapper;
import io.github.maki99999.biomebeats.gui.common.TextButton;
import io.github.maki99999.biomebeats.gui.common.UiElement;
import io.github.maki99999.biomebeats.gui.condcheckboxlist.ConditionCheckboxList;
import io.github.maki99999.biomebeats.gui.util.BiomeBeatsColor;
import io.github.maki99999.biomebeats.gui.util.DrawUtils;
import io.github.maki99999.biomebeats.gui.util.Point;
import io.github.maki99999.biomebeats.gui.util.Rect;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class CombinedConditionConfigScreen
extends UiElement {
    private static final int MAX_WIDTH = 250;
    private static final int MAX_HEIGHT = 400;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_SPACING = 4;
    private final ConfigScreen configScreen;
    private final CombinedCondition oldCondition;
    private final Collection<Condition> allConditions;
    private final Collection<Condition> checkedConditions = new ArrayList<Condition>();
    private final Collection<Component> collapsedConditionTypes = new ArrayList<Component>();
    private Rect bounds;
    private Rect innerBounds;
    private EditBoxWrapper nameField;
    private MultiLineEditBoxWrapper descriptionField;
    private EditBoxWrapper conditionSearchBox;
    private ConditionCheckboxList conditionList;

    public CombinedConditionConfigScreen(ConfigScreen configScreen, CombinedCondition condition, Collection<Condition> allConditions) {
        super((Component)Component.m_237113_((String)"BiomeBeats combined condition config screen"));
        this.configScreen = configScreen;
        this.oldCondition = condition;
        this.allConditions = allConditions;
        this.checkedConditions.addAll(allConditions.stream().filter(x -> condition != null && condition.getConditionIds().contains(x.getId())).toList());
    }

    @Override
    public void onClose() {
        this.configScreen.returnToThisScreen();
    }

    public void saveAndClose() {
        if (this.oldCondition == null) {
            Constants.CONDITION_MANAGER.addCondition(new CombinedCondition(this.nameField.getValue().isBlank() ? "Combined Condition" : this.nameField.getValue(), this.descriptionField.getValue(), this.checkedConditions.stream().map(Condition::getId).toList()));
        } else {
            Constants.CONDITION_MANAGER.updateCombinedCondition(this.oldCondition, this.nameField.getValue().isBlank() ? "Combined Condition" : this.nameField.getValue(), this.descriptionField.getValue(), this.checkedConditions.stream().map(Condition::getId).toList());
        }
        this.configScreen.returnToThisScreen();
    }

    public void deleteAndClose() {
        Constants.CONDITION_MANAGER.removeCombinedCondition(this.oldCondition);
        this.configScreen.returnToThisScreen();
    }

    @Override
    protected void init() {
        int w = Math.min(this.getHeight(), 250);
        int h = Math.min(this.getHeight(), 400);
        this.bounds = new Rect((this.getWidth() - w) / 2, (this.getHeight() - h) / 2, w, h);
        this.bounds = new Rect(this.bounds.x() + 4, this.bounds.y() + 4, this.bounds.w() - 8, this.bounds.h() - 8);
        this.innerBounds = new Rect(this.bounds.x() + 4, this.bounds.y() + 4, this.bounds.w() - 8, this.bounds.h() - 8);
        this.nameField = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.name"), new Rect(this.innerBounds.x() + 80, this.innerBounds.y(), this.innerBounds.w() - 80, 16)));
        if (this.oldCondition != null) {
            this.nameField.setValue(this.oldCondition.getName());
        }
        this.nameField.setHint((Component)Component.m_237115_((String)"menu.biomebeats.name"));
        this.descriptionField = this.addChild(new MultiLineEditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.description"), new Rect(this.innerBounds.x() + 80, this.innerBounds.y() + 16 + 4, this.innerBounds.w() - 80, 35)));
        if (this.oldCondition != null) {
            this.descriptionField.setValue(this.oldCondition.getDescription());
        }
        this.descriptionField.setCharacterLimit(42);
        this.conditionSearchBox = this.addChild(new EditBoxWrapper((Component)Component.m_237115_((String)"menu.biomebeats.search.condition"), new Rect(this.innerBounds.x(), this.innerBounds.y() + 60 + 8, this.innerBounds.w(), 16)));
        this.conditionSearchBox.setHint((Component)Component.m_237115_((String)"menu.biomebeats.search.condition"));
        this.conditionSearchBox.setResponder(this::onConditionSearchUpdate);
        if (this.oldCondition != null) {
            this.addChild(new TextButton((Component)Component.m_237115_((String)"menu.biomebeats.delete"), null, new Rect(this.innerBounds.x1(), this.innerBounds.y2() - 16, 50, 16), btn -> this.deleteAndClose()));
        }
        this.addChild(new TextButton((Component)Component.m_237115_((String)"menu.biomebeats.confirm"), null, new Rect(this.innerBounds.x2() - 100, this.innerBounds.y2() - 16, 100, 16), btn -> this.saveAndClose()));
        this.conditionList = this.addChild(new ConditionCheckboxList(Rect.fromCoordinates(this.innerBounds.x1(), this.conditionSearchBox.getY() + this.conditionSearchBox.getHeight(), this.innerBounds.x2(), this.innerBounds.y2() - 16 - 4), (Component)Component.m_237115_((String)"menu.biomebeats.search.music"), this.allConditions, this::onConditionToggle, this::onGroupToggle));
        this.conditionList.setCheckedConditions(this.checkedConditions);
    }

    private void onConditionSearchUpdate(String text) {
        this.conditionList.sortAndFilterConditions(text.trim().toLowerCase(), this.checkedConditions, this.collapsedConditionTypes);
    }

    private void onGroupToggle(Component typeName, boolean newValue) {
        if (newValue) {
            this.collapsedConditionTypes.add(typeName);
        } else {
            this.collapsedConditionTypes.remove(typeName);
        }
        this.conditionList.sortAndFilterConditions(this.conditionSearchBox.getValue().trim().toLowerCase(), this.checkedConditions, this.collapsedConditionTypes);
    }

    private void onConditionToggle(Condition condition, boolean newValue) {
        if (newValue) {
            this.checkedConditions.add(condition);
        } else {
            this.checkedConditions.remove(condition);
        }
        this.conditionList.setCheckedConditions(this.checkedConditions);
    }

    @Override
    protected void render(GuiGraphics guiGraphics, Point mousePos, float deltaTime) {
        DrawUtils.drawContainer(guiGraphics, this.bounds);
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.name"), new Rect(this.innerBounds.x(), this.innerBounds.y(), 80, 16), BiomeBeatsColor.WHITE.getHex());
        DrawUtils.drawScrollingString(guiGraphics, this.getMinecraft().f_91062_, (Component)Component.m_237115_((String)"menu.biomebeats.description"), new Rect(this.innerBounds.x(), this.innerBounds.y() + 16 + 4, 80, 16), BiomeBeatsColor.WHITE.getHex());
    }
}

