/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.config;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.com.fasterxml.jackson.databind.ObjectMapper;
import io.github.maki99999.biomebeats.conditionmusic.ConditionMusicManager;
import io.github.maki99999.biomebeats.config.ConfigChangeListener;
import io.github.maki99999.biomebeats.config.ConfigMigrator;
import io.github.maki99999.biomebeats.config.GeneralConfig;
import io.github.maki99999.biomebeats.config.MainConfig;
import io.github.maki99999.biomebeats.service.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;

public class ConfigIO {
    private final Collection<ConfigChangeListener> listeners = new HashSet<ConfigChangeListener>();
    private ConfigChangeListener conditionMusicManagerConfigChangeListener;
    private MainConfig config;
    private final ObjectMapper objectMapper = new ObjectMapper();

    private Path getConfigFilePath() {
        return Services.PLATFORM.getModConfigFolder().resolve("biomebeats.json");
    }

    public void addListener(ConfigChangeListener listener) {
        this.listeners.add(listener);
        if (this.config != null) {
            listener.afterConfigChange(this.config);
        }
    }

    public void addListenerConditionMusicManager(ConditionMusicManager conditionMusicManager) {
        this.conditionMusicManagerConfigChangeListener = conditionMusicManager;
    }

    public void removeListener(ConfigChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void saveConfig(MainConfig config) {
        config.setNewConfig(false);
        this.notifyBeforeConfigChangeListeners(config);
        this.setConfig(config);
    }

    private void setConfig(MainConfig config) {
        Path configFilePath = this.getConfigFilePath();
        try {
            Files.createDirectories(configFilePath.getParent(), new FileAttribute[0]);
            this.objectMapper.writeValue(configFilePath.toFile(), (Object)config);
            this.config = config;
            this.notifyAfterConfigChangeListeners(config);
            Constants.LOG.info("Configuration saved to {}", (Object)configFilePath);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save configuration to {}", (Object)configFilePath, (Object)e);
        }
    }

    private void notifyBeforeConfigChangeListeners(MainConfig config) {
        for (ConfigChangeListener listener : this.listeners) {
            listener.beforeConfigChange(config);
        }
        this.conditionMusicManagerConfigChangeListener.beforeConfigChange(config);
    }

    private void notifyAfterConfigChangeListeners(MainConfig config) {
        for (ConfigChangeListener listener : this.listeners) {
            listener.afterConfigChange(config);
        }
        this.conditionMusicManagerConfigChangeListener.afterConfigChange(config);
    }

    public void loadConfig() {
        Path configFilePath = this.getConfigFilePath();
        if (Files.exists(configFilePath, new LinkOption[0])) {
            try {
                this.config = this.objectMapper.readValue(configFilePath.toFile(), MainConfig.class);
                Constants.LOG.info("Configuration loaded from {}", (Object)configFilePath);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load configuration from {}", (Object)configFilePath, (Object)e);
            }
            ConfigMigrator.migrate(this.config);
        } else {
            Constants.LOG.warn("Configuration file {} does not exist", (Object)configFilePath);
        }
        if (this.config == null) {
            this.config = MainConfig.fromScratch();
        }
        this.notifyAfterConfigChangeListeners(this.config);
    }

    public void updateConfigListeners() {
        this.notifyAfterConfigChangeListeners(this.config);
    }

    public void resetConfig() {
        MainConfig config = MainConfig.fromScratch();
        this.setConfig(config);
        this.saveConfig(config);
    }

    public void clearConfig() {
        this.setConfig(new MainConfig());
    }

    public GeneralConfig getGeneralConfig() {
        return this.config.getGeneralConfig();
    }
}

