/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.conditionmusic;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.ActiveConditionsListener;
import io.github.maki99999.biomebeats.condition.BiomeCondition;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionManager;
import io.github.maki99999.biomebeats.condition.InGameModeCondition;
import io.github.maki99999.biomebeats.condition.IsUnderWaterCondition;
import io.github.maki99999.biomebeats.condition.TagCondition;
import io.github.maki99999.biomebeats.config.ConfigChangeListener;
import io.github.maki99999.biomebeats.config.MainConfig;
import io.github.maki99999.biomebeats.mixin.MixinWeighedSoundEvents;
import io.github.maki99999.biomebeats.music.MusicTrack;
import io.github.maki99999.biomebeats.music.ResourceLocationMusicTrack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class ConditionMusicManager
implements ActiveConditionsListener,
ConfigChangeListener {
    private Map<String, Collection<MusicTrack>> musicTracksByConditionId = Map.of();
    private final RandomSource rdm = RandomSource.m_216327_();

    public void init() {
        Constants.CONFIG_IO.addListenerConditionMusicManager(this);
        Constants.CONDITION_MANAGER.addListener(this);
    }

    @Override
    public void onActiveConditionsChanged(Collection<? extends Condition> activeConditions) {
        Constants.MUSIC_MANAGER.setCurrentMusicTracks(this.getTracksFromActiveConditions(activeConditions));
    }

    public Collection<MusicTrack> getTracksFromActiveConditions(Collection<? extends Condition> activeConditions) {
        int highestPriority = this.getHighestPriorityOfConditionsWithMusicTracks(activeConditions);
        List<String> relevantConditionIds = activeConditions.stream().filter(x -> x.getPriority() == highestPriority).map(Condition::getId).toList();
        return this.musicTracksByConditionId.entrySet().stream().filter(e -> relevantConditionIds.contains(e.getKey())).flatMap(e -> ((Collection)e.getValue()).stream()).toList();
    }

    public int getHighestPriorityOfConditionsWithMusicTracks(Collection<? extends Condition> conditions) {
        return conditions.stream().filter(c -> this.musicTracksByConditionId.containsKey(c.getId())).mapToInt(Condition::getPriority).max().orElse(Integer.MIN_VALUE);
    }

    @Override
    public void beforeConfigChange(MainConfig config) {
        Map<String, Collection<String>> musicTrackIdsByConditionId = config.getMusicTrackIdsByConditionId();
        for (Map.Entry<String, Collection<MusicTrack>> entry : this.musicTracksByConditionId.entrySet()) {
            Collection musicTrackIds = musicTrackIdsByConditionId.computeIfAbsent(entry.getKey(), k -> new HashSet());
            musicTrackIds.clear();
            entry.getValue().forEach(musicTrack -> musicTrackIds.add(musicTrack.getId()));
        }
        config.setMusicTrackIdsByConditionId(musicTrackIdsByConditionId);
    }

    @Override
    public void afterConfigChange(MainConfig config) {
        Collection<? extends MusicTrack> musicTracks = Constants.MUSIC_MANAGER.getMusicTracks();
        this.musicTracksByConditionId = new HashMap<String, Collection<MusicTrack>>();
        ArrayList<String> invalidMusicTrackIds = new ArrayList<String>();
        for (Map.Entry<String, Collection<String>> entry : config.getMusicTrackIdsByConditionId().entrySet()) {
            HashSet<MusicTrack> conditionMusicTracks = new HashSet<MusicTrack>();
            for (String musicTrackId : entry.getValue()) {
                MusicTrack musicTrack = musicTracks.stream().filter(m -> musicTrackId.equals(m.getId())).findAny().orElse(null);
                if (musicTrack == null) {
                    invalidMusicTrackIds.add(musicTrackId);
                    continue;
                }
                conditionMusicTracks.add(musicTrack);
            }
            if (conditionMusicTracks.isEmpty()) continue;
            this.musicTracksByConditionId.put(entry.getKey(), conditionMusicTracks);
        }
        if (!invalidMusicTrackIds.isEmpty()) {
            Constants.LOG.info("Music Tracks have been changed. Unknown music track ids: {}.", (Object)String.join((CharSequence)", ", invalidMusicTrackIds));
        }
        if (config.isNewConfig()) {
            if (!this.musicTracksByConditionId.isEmpty()) {
                Constants.LOG.warn("New config, but 'musicTracksByCondition' is not empty?");
            }
            this.addDefaultConfig();
        }
    }

    private void addDefaultConfig() {
        Condition underwaterCondition2;
        Condition underwaterCondition1;
        Condition isEndCondition;
        List<ResourceLocationMusicTrack> musicTracks = Constants.MUSIC_MANAGER.getMusicTracks().stream().filter(m -> m instanceof ResourceLocationMusicTrack).map(m -> (ResourceLocationMusicTrack)m).toList();
        this.addMusicToCondition(musicTracks, Musics.f_11647_, "WinScreen");
        this.addMusicToCondition(musicTracks, Musics.f_11645_, "MainMenu");
        this.addMusicToCondition(musicTracks, Musics.f_11646_, InGameModeCondition.getId(GameType.CREATIVE));
        this.addMusicToCondition(musicTracks, Musics.f_11651_, "NoOtherMusic");
        Condition endBossCondition = Constants.CONDITION_MANAGER.findCondition(c -> {
            CombinedCondition combCond;
            return c instanceof CombinedCondition && (combCond = (CombinedCondition)c).getName().equals("End Boss");
        });
        if (endBossCondition != null) {
            this.addMusicToCondition(musicTracks, Musics.f_11648_, endBossCondition.getId());
        }
        if ((isEndCondition = Constants.CONDITION_MANAGER.findCondition(c -> {
            TagCondition tagCondition;
            return c instanceof TagCondition && (tagCondition = (TagCondition)c).getName().equals("Is End");
        })) != null) {
            this.addMusicToCondition(musicTracks, Musics.f_11649_, isEndCondition.getId());
        }
        if ((underwaterCondition1 = Constants.CONDITION_MANAGER.findCondition(c -> {
            TagCondition tagCondition;
            return c instanceof TagCondition && (tagCondition = (TagCondition)c).getName().equals("Plays Underwater Music");
        })) != null) {
            this.addMusicToCondition(musicTracks, Musics.f_11650_, underwaterCondition1.getId());
        }
        if ((underwaterCondition2 = Constants.CONDITION_MANAGER.findCondition(c -> c instanceof IsUnderWaterCondition)) != null) {
            this.addMusicToCondition(musicTracks, Musics.f_11650_, underwaterCondition2.getId());
        }
        Collection<? extends Condition> biomeConditions = Constants.CONDITION_MANAGER.getBiomeConditions();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        try (Level level = player.m_9236_();){
            Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
            for (Condition condition : biomeConditions) {
                Optional biomeBgm;
                ResourceLocation biomeRl = ((BiomeCondition)condition).getBiomeRl();
                Biome biome = (Biome)biomeRegistry.m_7745_(biomeRl);
                if (biome == null || (biomeBgm = biome.m_47566_()).isEmpty()) continue;
                this.addMusicToCondition(musicTracks, (Music)biomeBgm.get(), condition.getId());
            }
        }
        catch (IOException e) {
            Constants.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addMusicToCondition(Collection<ResourceLocationMusicTrack> musicTracks, Music music, String conditionId) {
        if (music == null) {
            return;
        }
        MixinWeighedSoundEvents musicSoundEvents = (MixinWeighedSoundEvents)Minecraft.m_91087_().m_91106_().m_120384_(((SoundEvent)music.m_263193_().m_203334_()).m_11660_());
        if (musicSoundEvents == null) {
            return;
        }
        List<ResourceLocation> musicRLs = musicSoundEvents.list().stream().map(weightedSound -> (Sound)weightedSound.m_213718_(this.rdm)).map(Sound::m_119787_).distinct().toList();
        musicTracks.stream().filter(m -> musicRLs.stream().anyMatch(rl -> rl.equals((Object)m.getResourceLocation()))).forEach(musicTrack -> this.musicTracksByConditionId.computeIfAbsent(conditionId, k -> new HashSet()).add(musicTrack));
    }

    public void addTrackToCondition(String conditionId, MusicTrack track) {
        this.musicTracksByConditionId.computeIfAbsent(conditionId, k -> new HashSet()).add(track);
    }

    public void removeTrackToCondition(String conditionId, MusicTrack track) {
        if (this.musicTracksByConditionId.containsKey(conditionId)) {
            this.musicTracksByConditionId.get(conditionId).remove(track);
            if (this.musicTracksByConditionId.get(conditionId).isEmpty()) {
                this.musicTracksByConditionId.remove(conditionId);
            }
        }
    }

    public Map<Condition, Collection<MusicTrack>> getMusicTracksByCondition() {
        return this.musicTracksByConditionId.entrySet().stream().map(entry -> {
            Condition condition = ConditionManager.getCondition((String)entry.getKey());
            return condition == null ? null : Map.entry(condition, (Collection)entry.getValue());
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Collection<MusicTrack> getMusicTracksForCondition(String id) {
        return this.musicTracksByConditionId.getOrDefault(id, Collections.emptyList());
    }
}

