/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.condition;

import io.github.maki99999.biomebeats.biome.BiomeChangeListener;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionType;
import io.github.maki99999.biomebeats.util.StringUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class TagCondition
extends Condition
implements BiomeChangeListener {
    private final Collection<TagKey<Biome>> biomeTagKeys;

    public TagCondition(Collection<TagKey<Biome>> biomeTagKeys) {
        super(TagCondition.getId(biomeTagKeys), ConditionType.TAG, StringUtils.formatToTitleCase(biomeTagKeys.stream().findAny().orElseThrow().f_203868_().m_135815_()));
        this.biomeTagKeys = biomeTagKeys;
    }

    @NotNull
    public static String getId(Collection<TagKey<Biome>> biomeTagKeys) {
        return "tag:" + biomeTagKeys.stream().map(TagKey::f_203868_).map(ResourceLocation::toString).sorted().collect(Collectors.joining(","));
    }

    @Override
    public void onBiomeChanged(Holder<Biome> newBiome) {
        if (newBiome == null) {
            this.setConditionMet(false);
            return;
        }
        for (TagKey<Biome> tagKey : this.biomeTagKeys) {
            if (!newBiome.m_203656_(tagKey)) continue;
            this.setConditionMet(true);
            return;
        }
        this.setConditionMet(false);
    }
}

