/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.condition;

import io.github.maki99999.biomebeats.BiomeBeatsCommon;
import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionType;
import io.github.maki99999.biomebeats.util.TickListener;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;

public class DayTimeCondition
extends Condition
implements TickListener {
    public static final String IS_DAY = "IsDay";
    public static final String IS_NIGHT = "IsNight";
    private final boolean checkForDay;

    public DayTimeCondition(boolean checkForDay) {
        super(checkForDay ? IS_DAY : IS_NIGHT, ConditionType.OTHER, checkForDay ? "Is Day" : "Is Night");
        this.checkForDay = checkForDay;
        BiomeBeatsCommon.addTickListener(this);
    }

    @Override
    public void onTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            try (Level level = player.m_9236_();){
                if (this.checkForDay) {
                    this.setConditionMet(!DayTimeCondition.isNight(level.m_46468_()));
                } else {
                    this.setConditionMet(DayTimeCondition.isNight(level.m_46468_()));
                }
            }
            catch (IOException e) {
                Constants.LOG.error(e.getMessage(), (Throwable)e);
                this.setConditionMet(false);
            }
        } else {
            this.setConditionMet(false);
        }
    }

    private static boolean isNight(long dayTime) {
        return dayTime >= 12786L && dayTime <= 23216L;
    }
}

