/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.condition;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.ActiveConditionsListener;
import io.github.maki99999.biomebeats.condition.BiomeCondition;
import io.github.maki99999.biomebeats.condition.BossOverlayWithMusicCondition;
import io.github.maki99999.biomebeats.condition.CombinedCondition;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionType;
import io.github.maki99999.biomebeats.condition.DayTimeCondition;
import io.github.maki99999.biomebeats.condition.InGameModeCondition;
import io.github.maki99999.biomebeats.condition.IsUnderWaterCondition;
import io.github.maki99999.biomebeats.condition.NoOtherMusicCondition;
import io.github.maki99999.biomebeats.condition.ScreenCondition;
import io.github.maki99999.biomebeats.condition.TagCondition;
import io.github.maki99999.biomebeats.config.CombinedConditionConfig;
import io.github.maki99999.biomebeats.config.ConditionConfig;
import io.github.maki99999.biomebeats.config.ConfigChangeListener;
import io.github.maki99999.biomebeats.config.MainConfig;
import io.github.maki99999.biomebeats.event.ConditionChangeEvent;
import io.github.maki99999.biomebeats.util.BiomeUtils;
import io.github.maki99999.biomebeats.util.EventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class ConditionManager
implements ConfigChangeListener {
    public static final String END_BOSS_CONDITION_NAME = "End Boss";
    private static final Map<String, Condition> CONDITIONS = new HashMap<String, Condition>();
    private static final Map<ConditionType, Collection<Condition>> CONDITIONS_BY_TYPE = new HashMap<ConditionType, Collection<Condition>>();
    private static final Collection<CombinedCondition> COMBINED_CONDITIONS = new ArrayList<CombinedCondition>();
    private final Collection<ActiveConditionsListener> activeConditionsListener = new HashSet<ActiveConditionsListener>();
    private final Collection<Condition> activeConditions = new HashSet<Condition>();
    private boolean firstTickWithLevel = true;
    private boolean needsToNotifyListeners = true;

    public ConditionManager() {
        EventBus.subscribe(ConditionChangeEvent.class, e -> this.onConditionChanged(e.condition()));
    }

    public static void createCondition(String id, Supplier<Condition> factory) {
        CONDITIONS.computeIfAbsent(id, key -> {
            Condition condition = (Condition)factory.get();
            if (condition instanceof CombinedCondition) {
                CombinedCondition combinedCondition = (CombinedCondition)condition;
                COMBINED_CONDITIONS.add(combinedCondition);
            } else {
                CONDITIONS_BY_TYPE.computeIfAbsent(condition.getType(), key2 -> new ArrayList()).add(condition);
            }
            return condition;
        });
    }

    public static Condition getCondition(String id) {
        return CONDITIONS.getOrDefault(id, null);
    }

    private static void initTagConditions(Collection<TagKey<Biome>> biomeTagKeys) {
        HashMap<String, Collection> tagKeysByName = new HashMap<String, Collection>();
        for (TagKey<Biome> tagKey : biomeTagKeys) {
            String path = tagKey.f_203868_().m_135815_();
            if (!Arrays.stream(new String[]{"is_", "plays_"}).anyMatch(path::startsWith)) continue;
            tagKeysByName.computeIfAbsent(path, k -> new ArrayList()).add(tagKey);
        }
        HashSet keys = new HashSet(tagKeysByName.keySet());
        for (String key : keys) {
            String baseKey;
            if (!key.contains("/") || !tagKeysByName.containsKey(baseKey = key.substring(0, key.indexOf(47)))) continue;
            ((Collection)tagKeysByName.get(baseKey)).addAll((Collection)tagKeysByName.get(key));
            tagKeysByName.remove(key);
        }
        for (Collection tagKeys : tagKeysByName.values()) {
            ConditionManager.createCondition(TagCondition.getId(tagKeys), () -> {
                TagCondition tagCondition = new TagCondition(tagKeys);
                Constants.BIOME_MANAGER.addBiomeChangeListener(tagCondition);
                return tagCondition;
            });
        }
    }

    public Collection<? extends Condition> getTagConditions() {
        return CONDITIONS_BY_TYPE.get((Object)ConditionType.TAG);
    }

    public Collection<? extends Condition> getBiomeConditions() {
        return CONDITIONS_BY_TYPE.get((Object)ConditionType.BIOME);
    }

    public Collection<? extends Condition> getOtherConditions() {
        return CONDITIONS_BY_TYPE.get((Object)ConditionType.OTHER);
    }

    public Collection<CombinedCondition> getCombinedConditions() {
        return COMBINED_CONDITIONS;
    }

    public void init() {
        this.initOtherConditions();
        Constants.CONFIG_IO.addListener(this);
    }

    private void initOtherConditions() {
        ConditionManager.createCondition("MainMenu", () -> new ScreenCondition("MainMenu", "In Main Menu", null));
        ConditionManager.createCondition("WinScreen", () -> new ScreenCondition("WinScreen", "In Win Screen", WinScreen.class));
        ConditionManager.createCondition("IsDay", () -> new DayTimeCondition(true));
        ConditionManager.createCondition("IsNight", () -> new DayTimeCondition(false));
        ConditionManager.createCondition("BossOverlayWithMusic", BossOverlayWithMusicCondition::new);
        ConditionManager.createCondition("IsUnderWater", IsUnderWaterCondition::new);
        ConditionManager.createCondition(InGameModeCondition.getId(GameType.CREATIVE), () -> new InGameModeCondition(GameType.CREATIVE));
        ConditionManager.createCondition(InGameModeCondition.getId(GameType.SPECTATOR), () -> new InGameModeCondition(GameType.SPECTATOR));
        ConditionManager.createCondition("NoOtherMusic", NoOtherMusicCondition::new);
    }

    private void initBiomeConditions(@NotNull Level level) {
        for (ResourceLocation rl : BiomeUtils.getBiomeRLs(level)) {
            ConditionManager.createCondition(BiomeCondition.getId(rl), () -> {
                BiomeCondition biomeCondition = new BiomeCondition(rl);
                Constants.BIOME_MANAGER.addBiomeChangeListener(biomeCondition);
                return biomeCondition;
            });
        }
        ConditionManager.initTagConditions(BiomeUtils.getBiomeTagKeys(level));
    }

    public void tick() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.firstTickWithLevel && minecraft.f_91073_ != null) {
            this.firstTickWithLevel = false;
            this.initBiomeConditions((Level)minecraft.f_91073_);
            Constants.CONFIG_IO.updateConfigListeners();
        }
        if (this.needsToNotifyListeners) {
            this.needsToNotifyListeners = false;
            for (ActiveConditionsListener listener : this.activeConditionsListener) {
                listener.onActiveConditionsChanged(this.activeConditions);
            }
        }
    }

    public void onConditionChanged(Condition condition) {
        if (condition.isConditionMet()) {
            this.activeConditions.add(condition);
        } else {
            this.activeConditions.remove(condition);
        }
        this.needsToNotifyListeners = true;
    }

    public void addListener(ActiveConditionsListener listener) {
        this.activeConditionsListener.add(listener);
    }

    public Collection<Condition> getConditions() {
        return CONDITIONS.values();
    }

    @Override
    public void beforeConfigChange(MainConfig config) {
        ArrayList<CombinedConditionConfig> combinedConditionConfigs = new ArrayList<CombinedConditionConfig>();
        for (CombinedCondition condition : COMBINED_CONDITIONS) {
            combinedConditionConfigs.add(new CombinedConditionConfig(condition.getId(), condition.getName(), condition.getDescription(), condition.getConditionIds()));
        }
        config.setCombinedConditionConfigs(combinedConditionConfigs);
        Map<String, ConditionConfig> conditionConfigById = config.getConditionConfigById();
        for (Condition condition : CONDITIONS.values()) {
            ConditionConfig conditionConfig = conditionConfigById.computeIfAbsent(condition.getId(), k -> new ConditionConfig());
            conditionConfig.setPriority(condition.getPriority());
        }
    }

    @Override
    public void afterConfigChange(MainConfig config) {
        COMBINED_CONDITIONS.stream().map(Condition::getId).forEach(CONDITIONS::remove);
        COMBINED_CONDITIONS.clear();
        for (CombinedConditionConfig conditionConfig : config.getCombinedConditionConfigs()) {
            ConditionManager.createCondition(conditionConfig.getUuid(), () -> new CombinedCondition(conditionConfig.getUuid(), conditionConfig.getName(), conditionConfig.getDescription(), conditionConfig.getConditionIds()));
        }
        Map<String, ConditionConfig> conditionConfigById = config.getConditionConfigById();
        for (Condition condition : CONDITIONS.values()) {
            if (conditionConfigById.containsKey(condition.getId())) {
                ConditionConfig conditionConfig = conditionConfigById.get(condition.getId());
                condition.setPriority(conditionConfig.getPriority());
                continue;
            }
            condition.setPriority(0);
        }
        for (ActiveConditionsListener listener : this.activeConditionsListener) {
            listener.onActiveConditionsChanged(this.activeConditions);
        }
        if (config.isNewConfig()) {
            this.addDefaultConfig();
        }
    }

    private void addDefaultConfig() {
        Condition isEnd = this.findCondition(c -> {
            TagCondition tagCondition;
            return c instanceof TagCondition && (tagCondition = (TagCondition)c).getName().equals("Is End");
        });
        if (isEnd != null) {
            CombinedCondition endBoss = new CombinedCondition(END_BOSS_CONDITION_NAME, "Default Configuration", List.of(isEnd.getId(), "BossOverlayWithMusic"));
            endBoss.setPriority(4);
            this.addCondition(endBoss);
            isEnd.setPriority(3);
        } else {
            Constants.LOG.warn("Missing 'Is End' condition");
        }
        Condition playsUnderWaterMusic = this.findCondition(c -> {
            TagCondition tagCondition;
            return c instanceof TagCondition && (tagCondition = (TagCondition)c).getName().equals("Plays Underwater Music");
        });
        if (playsUnderWaterMusic != null) {
            playsUnderWaterMusic.setPriority(2);
        } else {
            Constants.LOG.warn("Missing 'Plays Underwater Music' condition");
        }
        this.findCondition(c -> c instanceof IsUnderWaterCondition).setPriority(2);
        this.findCondition(c -> {
            ScreenCondition screenCondition;
            return c instanceof ScreenCondition && Objects.equals((screenCondition = (ScreenCondition)c).getScreen(), WinScreen.class);
        }).setPriority(6);
        this.findCondition(c -> {
            ScreenCondition screenCondition;
            return c instanceof ScreenCondition && (screenCondition = (ScreenCondition)c).getScreen() == null;
        }).setPriority(5);
        this.findCondition(c -> {
            InGameModeCondition inGameModeCondition;
            return c instanceof InGameModeCondition && (inGameModeCondition = (InGameModeCondition)c).getName().contains("Creative");
        }).setPriority(1);
    }

    public Condition findCondition(Predicate<? super Condition> predicate) {
        return CONDITIONS.values().stream().filter(predicate).findAny().orElse(null);
    }

    public void addCondition(Condition combinedCondition) {
        ConditionManager.createCondition(combinedCondition.getId(), () -> combinedCondition);
    }

    public void updateCombinedCondition(CombinedCondition combinedCondition, String name, String description, Collection<String> conditionIds) {
        combinedCondition.setName(name);
        combinedCondition.setDescription(description);
        combinedCondition.setConditionIds(conditionIds);
    }

    public void removeCombinedCondition(CombinedCondition combinedCondition) {
        combinedCondition.dispose();
        CONDITIONS.remove(combinedCondition.getId());
        COMBINED_CONDITIONS.remove(combinedCondition);
    }

    public boolean isConditionMet(String conditionId) {
        if (CONDITIONS.containsKey(conditionId)) {
            return CONDITIONS.get(conditionId).isConditionMet();
        }
        return false;
    }
}

