/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.condition;

import io.github.maki99999.biomebeats.condition.ConditionType;
import io.github.maki99999.biomebeats.event.ConditionChangeEvent;
import io.github.maki99999.biomebeats.util.EventBus;
import java.util.Objects;

public abstract class Condition {
    private final String id;
    private final ConditionType type;
    private String name;
    private int priority;
    private boolean met = false;
    private boolean metInitialized = false;

    public Condition(String id, ConditionType type, String name) {
        this.id = id;
        this.type = type;
        this.name = name;
    }

    public Condition(String id, ConditionType type, String name, int priority) {
        this(id, type, name);
        this.priority = priority;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
        EventBus.publish(new ConditionChangeEvent(this));
    }

    public final int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        if (this.priority != priority) {
            this.priority = priority;
            EventBus.publish(new ConditionChangeEvent(this));
        }
    }

    public final boolean isConditionMet() {
        return this.met;
    }

    protected final void setConditionMet(boolean met) {
        if (!this.metInitialized || this.met != met) {
            this.met = met;
            this.metInitialized = true;
            EventBus.publish(new ConditionChangeEvent(this));
        }
    }

    public final ConditionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.getId(), ((Condition)o).getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return this.name;
    }
}

