/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.condition;

import io.github.maki99999.biomebeats.Constants;
import io.github.maki99999.biomebeats.condition.Condition;
import io.github.maki99999.biomebeats.condition.ConditionType;
import io.github.maki99999.biomebeats.event.ConditionChangeEvent;
import io.github.maki99999.biomebeats.util.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class CombinedCondition
extends Condition {
    private final Collection<String> conditionIds = new ArrayList<String>();
    private final Collection<String> metConditionIds = new ArrayList<String>();
    private String description;

    public CombinedCondition(String id, String name, String description, Collection<String> conditionIds) {
        super(id, ConditionType.COMBINED, name);
        this.description = description;
        this.setConditionIds(conditionIds);
        EventBus.subscribe(ConditionChangeEvent.class, e -> this.onConditionChanged(e.condition()));
    }

    public CombinedCondition(String name, String description, List<String> conditionIds) {
        this(UUID.randomUUID().toString(), name, description, conditionIds);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getConditionIds() {
        return this.conditionIds.stream().toList();
    }

    public void onConditionChanged(Condition condition) {
        if (!this.conditionIds.contains(condition.getId())) {
            return;
        }
        if (condition.isConditionMet()) {
            if (!this.metConditionIds.contains(condition.getId())) {
                this.metConditionIds.add(condition.getId());
            }
        } else {
            this.metConditionIds.remove(condition.getId());
        }
        this.updateConditionMet();
    }

    private void updateConditionMet() {
        if (this.metConditionIds.size() > this.conditionIds.size()) {
            Constants.LOG.error("Invalid state: {} conditions met, but only {} possible.", (Object)this.metConditionIds.size(), (Object)this.conditionIds.size());
        }
        this.setConditionMet(!this.conditionIds.isEmpty() && this.metConditionIds.size() >= this.conditionIds.size());
    }

    public void dispose() {
        EventBus.unsubscribe(ConditionChangeEvent.class, e -> this.onConditionChanged(e.condition()));
    }

    public void setConditionIds(Collection<String> conditionIds) {
        this.conditionIds.clear();
        this.metConditionIds.clear();
        this.conditionIds.addAll(conditionIds);
        this.metConditionIds.addAll(conditionIds.stream().filter(Constants.CONDITION_MANAGER::isConditionMet).toList());
        this.updateConditionMet();
    }
}

