/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.tools;

import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.enums.AudioType;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.tools.IOInfo;
import io.github.maki99999.biomebeats.org.jaudiotagger.audio.mp3.MP3File;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class TimeTool {
    private TimeTool() {
    }

    public static String getTimeEditedOnHours(int seconds) {
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public static String getTimeEdited(int seconds) {
        if (seconds < 60) {
            return String.format("%02ds", seconds % 60);
        }
        if (seconds / 60 / 60 <= 0) {
            return String.format("%02dm:%02d", seconds / 60 % 60, seconds % 60);
        }
        return String.format("%02dh:%02dm:%02d", seconds / 60 / 60, seconds / 60 % 60, seconds % 60);
    }

    public static String millisecondsToTime(long ms) {
        int millis = (int)(ms % 1000L / 100L);
        return String.format(".%d", millis);
    }

    public static int durationInSeconds(String name, AudioType type) {
        long time = TimeTool.durationInMilliseconds(name, type);
        return (int)(time == 0L || time == -1L ? time : time / 1000L);
    }

    public static long durationInMilliseconds(String input, AudioType audioType) {
        return audioType == AudioType.FILE ? TimeTool.durationInMilliseconds_Part2(new File(input)) : (audioType == AudioType.URL || audioType == AudioType.INPUTSTREAM || audioType == AudioType.UNKNOWN ? -1L : -1L);
    }

    private static long durationInMilliseconds_Part2(File file) {
        long milliseconds = -1L;
        if (file.exists() && file.length() != 0L) {
            String extension = IOInfo.getFileExtension(file.getName());
            if ("mp3".equals(extension)) {
                try {
                    milliseconds = new MP3File(file).getMP3AudioHeader().getTrackLength() * 1000;
                }
                catch (Exception ex) {
                    System.err.println("Problem getting the time of-> " + file.getAbsolutePath());
                }
            } else if ("ogg".equals(extension) || "wav".equals(extension)) {
                try (AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);){
                    AudioFormat format = audioInputStream.getFormat();
                    milliseconds = (int)(file.length() / (long)(format.getFrameSize() * (int)format.getFrameRate())) * 1000;
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    System.err.println("Problem getting the time of-> " + file.getAbsolutePath());
                }
            }
        }
        return milliseconds < 0L ? -1L : milliseconds;
    }
}

