/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream;

import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.enums.AudioType;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.enums.Status;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerEventLauncher;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerException;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.StreamPlayerListener;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.stream.ThreadFactoryWithNamePrefix;
import io.github.maki99999.biomebeats.com.goxr3plus.streamplayer.tools.TimeTool;
import io.github.maki99999.biomebeats.javazoom.spi.PropertiesContainer;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.TAudioFormat;
import io.github.maki99999.biomebeats.org.tritonus.share.sampled.file.TAudioFileFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class StreamPlayer
implements Callable<Void> {
    private static final Logger logger = Logger.getLogger(StreamPlayer.class.getName());
    private volatile Status status = Status.NOT_SPECIFIED;
    private Object dataSource;
    private volatile AudioInputStream audioInputStream;
    private AudioInputStream encodedAudioInputStream;
    private AudioFileFormat audioFileFormat;
    private SourceDataLine sourceDataLine;
    private FloatControl gainControl;
    private FloatControl panControl;
    private FloatControl balanceControl;
    private BooleanControl muteControl;
    private volatile Object audioLock = new Object();
    private String mixerName;
    private int currentLineBufferSize = -1;
    private int lineBufferSize = -1;
    private int encodedAudioLength = -1;
    private double speedFactor = 1.0;
    private static final int EXTERNAL_BUFFER_SIZE = 4096;
    byte[] trimBuffer;
    private final ExecutorService streamPlayerExecutorService;
    private Future<Void> future;
    private final ExecutorService eventsExecutorService;
    private final ArrayList<StreamPlayerListener> listeners;
    private final Map<String, Object> emptyMap = new HashMap<String, Object>();
    Map<String, Object> audioProperties;

    public StreamPlayer() {
        this.streamPlayerExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryWithNamePrefix("StreamPlayer"));
        this.eventsExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryWithNamePrefix("StreamPlayerEvent"));
        this.listeners = new ArrayList();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.audioLock;
        synchronized (object) {
            this.closeStream();
        }
        if (this.sourceDataLine != null) {
            this.sourceDataLine.flush();
            this.sourceDataLine.close();
            this.sourceDataLine = null;
        }
        this.audioInputStream = null;
        this.audioFileFormat = null;
        this.encodedAudioInputStream = null;
        this.encodedAudioLength = -1;
        this.gainControl = null;
        this.panControl = null;
        this.balanceControl = null;
        this.status = Status.NOT_SPECIFIED;
        this.generateEvent(Status.NOT_SPECIFIED, -1, null);
    }

    private String generateEvent(Status status, int encodedStreamPosition, Object description) {
        try {
            return this.eventsExecutorService.submit(new StreamPlayerEventLauncher(this, status, encodedStreamPosition, description, this.listeners)).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            logger.log(Level.WARNING, "Problem in StreamPlayer generateEvent() method", ex);
            return "Problem in StreamPlayer generateEvent() method";
        }
    }

    public void addStreamPlayerListener(StreamPlayerListener streamPlayerListener) {
        this.listeners.add(streamPlayerListener);
    }

    public void removeStreamPlayerListener(StreamPlayerListener streamPlayerListener) {
        if (this.listeners != null) {
            this.listeners.remove(streamPlayerListener);
        }
    }

    public void open(Object object) throws StreamPlayerException {
        logger.info(() -> "open(" + object + ")\n");
        if (object == null) {
            return;
        }
        this.dataSource = object;
        this.initAudioInputStream();
    }

    private void initAudioInputStream() throws StreamPlayerException {
        try {
            logger.info("Entered initAudioInputStream\n");
            this.reset();
            this.status = Status.OPENING;
            this.generateEvent(Status.OPENING, this.getEncodedStreamPosition(), this.dataSource);
            if (this.dataSource instanceof URL) {
                this.audioInputStream = AudioSystem.getAudioInputStream((URL)this.dataSource);
                this.audioFileFormat = AudioSystem.getAudioFileFormat((URL)this.dataSource);
            } else if (this.dataSource instanceof File) {
                this.audioInputStream = AudioSystem.getAudioInputStream((File)this.dataSource);
                this.audioFileFormat = AudioSystem.getAudioFileFormat((File)this.dataSource);
            } else if (this.dataSource instanceof InputStream) {
                this.audioInputStream = AudioSystem.getAudioInputStream((InputStream)this.dataSource);
                this.audioFileFormat = AudioSystem.getAudioFileFormat((InputStream)this.dataSource);
            }
            this.createLine();
            this.determineProperties();
            this.status = Status.OPENED;
            this.generateEvent(Status.OPENED, this.getEncodedStreamPosition(), null);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException \u00a2) {
            logger.log(Level.INFO, \u00a2.getMessage(), \u00a2);
            throw new StreamPlayerException(\u00a2);
        }
        logger.info("Exited initAudioInputStream\n");
    }

    private void determineProperties() {
        AudioFormat audioFormat;
        logger.info("Entered determineProperties()!\n");
        if (this.audioFileFormat == null) {
            return;
        }
        if (!(this.audioFileFormat instanceof TAudioFileFormat)) {
            this.audioProperties = new HashMap<String, Object>();
        } else {
            this.audioProperties = ((TAudioFileFormat)this.audioFileFormat).properties();
            this.audioProperties = this.deepCopy(this.audioProperties);
        }
        if (this.audioFileFormat.getByteLength() > 0) {
            this.audioProperties.put("audio.length.bytes", this.audioFileFormat.getByteLength());
        }
        if (this.audioFileFormat.getFrameLength() > 0) {
            this.audioProperties.put("audio.length.frames", this.audioFileFormat.getFrameLength());
        }
        if (this.audioFileFormat.getType() != null) {
            this.audioProperties.put("audio.type", this.audioFileFormat.getType());
        }
        if ((audioFormat = this.audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
            this.audioProperties.put("audio.framerate.fps", Float.valueOf(audioFormat.getFrameRate()));
        }
        if (audioFormat.getFrameSize() > 0) {
            this.audioProperties.put("audio.framesize.bytes", audioFormat.getFrameSize());
        }
        if (audioFormat.getSampleRate() > 0.0f) {
            this.audioProperties.put("audio.samplerate.hz", Float.valueOf(audioFormat.getSampleRate()));
        }
        if (audioFormat.getSampleSizeInBits() > 0) {
            this.audioProperties.put("audio.samplesize.bits", audioFormat.getSampleSizeInBits());
        }
        if (audioFormat.getChannels() > 0) {
            this.audioProperties.put("audio.channels", audioFormat.getChannels());
        }
        if (audioFormat instanceof TAudioFormat) {
            this.audioProperties.putAll(((TAudioFormat)audioFormat).properties());
        }
        this.audioProperties.put("basicplayer.sourcedataline", this.sourceDataLine);
        Map<String, Object> audioPropertiesCopy = this.audioProperties;
        this.listeners.forEach(listener -> listener.opened(this.dataSource, audioPropertiesCopy));
        logger.info("Exited determineProperties()!\n");
    }

    private void initLine() throws LineUnavailableException, StreamPlayerException {
        logger.info("Initiating the line...");
        if (this.sourceDataLine == null) {
            this.createLine();
        }
        if (!this.sourceDataLine.isOpen()) {
            this.openLine();
        } else if (!this.sourceDataLine.getFormat().equals(this.audioInputStream == null ? null : this.audioInputStream.getFormat())) {
            this.sourceDataLine.close();
            this.openLine();
        }
    }

    public void setSpeedFactor(double speedFactor) {
        this.speedFactor = speedFactor;
    }

    private void createLine() throws LineUnavailableException, StreamPlayerException {
        logger.info("Entered CreateLine()!:\n");
        if (this.sourceDataLine != null) {
            logger.warning("Warning Source DataLine is not null!\n");
        } else {
            Mixer mixer;
            AudioFormat sourceFormat = this.audioInputStream.getFormat();
            logger.info(() -> "Create Line : Source format : " + sourceFormat + "\n");
            int nSampleSizeInBits = sourceFormat.getSampleSizeInBits();
            if (sourceFormat.getEncoding() == AudioFormat.Encoding.ULAW || sourceFormat.getEncoding() == AudioFormat.Encoding.ALAW || nSampleSizeInBits <= 0 || nSampleSizeInBits != 8) {
                nSampleSizeInBits = 16;
            }
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, (float)((double)sourceFormat.getSampleRate() * this.speedFactor), nSampleSizeInBits, sourceFormat.getChannels(), nSampleSizeInBits / 8 * sourceFormat.getChannels(), sourceFormat.getSampleRate(), false);
            logger.info(() -> "Sample Rate =" + targetFormat.getSampleRate() + ",Frame Rate=" + targetFormat.getFrameRate() + ",Bit Rate=" + targetFormat.getSampleSizeInBits() + "Target format: " + targetFormat + "\n");
            this.encodedAudioInputStream = this.audioInputStream;
            try {
                this.encodedAudioLength = this.encodedAudioInputStream.available();
            }
            catch (IOException e) {
                logger.warning("Cannot get m_encodedaudioInputStream.available()\n" + e);
            }
            this.audioInputStream = AudioSystem.getAudioInputStream(targetFormat, this.audioInputStream);
            DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.audioInputStream.getFormat(), -1);
            if (!AudioSystem.isLineSupported(lineInfo)) {
                throw new StreamPlayerException(StreamPlayerException.PlayerException.LINE_NOT_SUPPORTED);
            }
            if (this.mixerName == null) {
                this.mixerName = this.getMixers().get(0);
            }
            if ((mixer = this.getMixer(this.mixerName)) == null) {
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
                this.mixerName = null;
            } else {
                logger.info("Mixer: " + mixer.getMixerInfo());
                this.sourceDataLine = (SourceDataLine)mixer.getLine(lineInfo);
            }
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
            logger.info(() -> "Line : " + this.sourceDataLine);
            logger.info(() -> "Line Info : " + this.sourceDataLine.getLineInfo());
            logger.info(() -> "Line AudioFormat: " + this.sourceDataLine.getFormat() + "\n");
            logger.info("Exited CREATELINE()!:\n");
        }
    }

    private void openLine() throws LineUnavailableException {
        logger.info("Entered OpenLine()!:\n");
        if (this.sourceDataLine != null) {
            AudioFormat audioFormat = this.audioInputStream.getFormat();
            this.currentLineBufferSize = this.lineBufferSize >= 0 ? this.lineBufferSize : this.sourceDataLine.getBufferSize();
            this.sourceDataLine.open(audioFormat, this.currentLineBufferSize);
            if (this.sourceDataLine.isOpen()) {
                this.gainControl = this.sourceDataLine.isControlSupported(FloatControl.Type.MASTER_GAIN) ? (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN) : null;
                this.panControl = this.sourceDataLine.isControlSupported(FloatControl.Type.PAN) ? (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.PAN) : null;
                this.muteControl = this.sourceDataLine.isControlSupported(BooleanControl.Type.MUTE) ? (BooleanControl)this.sourceDataLine.getControl(BooleanControl.Type.MUTE) : null;
                this.balanceControl = this.sourceDataLine.isControlSupported(FloatControl.Type.BALANCE) ? (FloatControl)this.sourceDataLine.getControl(FloatControl.Type.BALANCE) : null;
            }
        }
        logger.info("Exited OpenLine()!:\n");
    }

    public void play() throws StreamPlayerException {
        if (this.status == Status.STOPPED) {
            this.initAudioInputStream();
        }
        if (this.status != Status.OPENED) {
            return;
        }
        this.awaitTermination();
        try {
            this.initLine();
        }
        catch (LineUnavailableException ex) {
            throw new StreamPlayerException(StreamPlayerException.PlayerException.CAN_NOT_INIT_LINE, (Throwable)ex);
        }
        if (this.sourceDataLine != null && !this.sourceDataLine.isRunning()) {
            this.sourceDataLine.start();
            logger.info("Submitting new StreamPlayer Thread");
            this.streamPlayerExecutorService.submit(this);
            this.status = Status.PLAYING;
            this.generateEvent(Status.PLAYING, this.getEncodedStreamPosition(), null);
        }
    }

    public boolean pause() {
        if (this.sourceDataLine == null || this.status != Status.PLAYING) {
            return false;
        }
        this.status = Status.PAUSED;
        logger.info("pausePlayback() completed");
        this.generateEvent(Status.PAUSED, this.getEncodedStreamPosition(), null);
        return true;
    }

    public void stop() {
        if (this.status == Status.STOPPED) {
            return;
        }
        if (this.isPlaying()) {
            this.pause();
        }
        this.status = Status.STOPPED;
        logger.info("StreamPlayer stopPlayback() completed");
    }

    public boolean resume() {
        if (this.sourceDataLine == null || this.status != Status.PAUSED) {
            return false;
        }
        this.sourceDataLine.start();
        this.status = Status.PLAYING;
        this.generateEvent(Status.RESUMED, this.getEncodedStreamPosition(), null);
        logger.info("resumePlayback() completed");
        return true;
    }

    private void awaitTermination() {
        if (this.future != null && !this.future.isDone()) {
            try {
                Thread delay = new Thread(() -> {
                    try {
                        for (int i = 0; i < 50 && !this.future.isDone(); ++i) {
                            Thread.sleep(20L);
                            System.out.println("StreamPlayer Future is not yet done...");
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        logger.log(Level.INFO, ex.getMessage(), ex);
                    }
                });
                delay.start();
                delay.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            finally {
                this.future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long seekBytes(long bytes) throws StreamPlayerException {
        long totalSkipped = 0L;
        if (this.dataSource instanceof File) {
            long bytesLength = this.getTotalBytes();
            System.out.println("Bytes: " + bytes + " BytesLength: " + bytesLength);
            if (bytesLength <= 0L || bytes >= bytesLength) {
                this.generateEvent(Status.EOM, this.getEncodedStreamPosition(), null);
                return totalSkipped;
            }
            logger.info(() -> "Bytes to skip : " + bytes);
            Status previousStatus = this.status;
            this.status = Status.SEEKING;
            try {
                Object object = this.audioLock;
                synchronized (object) {
                    this.generateEvent(Status.SEEKING, -1, null);
                    this.initAudioInputStream();
                    if (this.audioInputStream != null) {
                        long skipped;
                        while (totalSkipped < bytes && (skipped = this.audioInputStream.skip(bytes - totalSkipped)) != 0L) {
                            logger.info("Skipped : " + (totalSkipped += skipped) + "/" + bytes);
                            if (totalSkipped == -1L) {
                                throw new StreamPlayerException(StreamPlayerException.PlayerException.SKIP_NOT_SUPPORTED);
                            }
                            logger.info("Skeeping:" + totalSkipped);
                        }
                    }
                }
                this.generateEvent(Status.SEEKED, this.getEncodedStreamPosition(), null);
                this.status = Status.OPENED;
                if (previousStatus == Status.PLAYING) {
                    this.play();
                } else if (previousStatus == Status.PAUSED) {
                    this.play();
                    this.pause();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return totalSkipped;
    }

    public long seekSeconds(int seconds) throws Exception {
        int durationInSeconds = this.getDurationInSeconds();
        this.validateSeconds(seconds, durationInSeconds);
        long totalBytes = this.getTotalBytes();
        double percentage = seconds * 100 / durationInSeconds;
        long bytes = (long)((double)totalBytes * (percentage / 100.0));
        return this.seekBytes((long)this.getEncodedStreamPosition() + bytes);
    }

    public long seekTo(int seconds) throws Exception {
        int durationInSeconds = this.getDurationInSeconds();
        this.validateSeconds(seconds, durationInSeconds);
        long totalBytes = this.getTotalBytes();
        double percentage = seconds * 100 / durationInSeconds;
        long bytes = (long)((double)totalBytes * (percentage / 100.0));
        return this.seekBytes(bytes);
    }

    private void validateSeconds(int seconds, int durationInSeconds) throws Exception {
        if (seconds < 0) {
            throw new Exception("Trying to skip negative seconds ");
        }
        if (seconds >= durationInSeconds) {
            throw new Exception("Trying to skip with seconds {" + seconds + "} > maximum {" + durationInSeconds + "}");
        }
    }

    public int getDurationInSeconds() {
        if (this.dataSource instanceof File) {
            return TimeTool.durationInSeconds(((File)this.dataSource).getAbsolutePath(), AudioType.FILE);
        }
        if (this.dataSource instanceof URL) {
            return -1;
        }
        if (this.dataSource instanceof InputStream) {
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() {
        int nBytesRead = 0;
        int audioDataLength = 4096;
        ByteBuffer audioDataBuffer = ByteBuffer.allocate(4096);
        audioDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Object object = this.audioLock;
        synchronized (object) {
            while (nBytesRead != -1 && this.status != Status.STOPPED && this.status != Status.NOT_SPECIFIED && this.status != Status.SEEKING) {
                try {
                    if (this.status == Status.PLAYING) {
                        int totalRead = 0;
                        for (int toRead = 4096; toRead > 0 && (nBytesRead = this.audioInputStream.read(audioDataBuffer.array(), totalRead, toRead)) != -1; toRead -= nBytesRead, totalRead += nBytesRead) {
                            if (this.sourceDataLine.available() < this.sourceDataLine.getBufferSize()) continue;
                            logger.info(() -> "Underrun> Available=" + this.sourceDataLine.available() + " , SourceDataLineBuffer=" + this.sourceDataLine.getBufferSize());
                        }
                        if (totalRead <= 0) continue;
                        this.trimBuffer = audioDataBuffer.array();
                        if (totalRead < this.trimBuffer.length) {
                            this.trimBuffer = new byte[totalRead];
                            System.arraycopy(audioDataBuffer.array(), 0, this.trimBuffer, 0, totalRead);
                        }
                        this.sourceDataLine.write(this.trimBuffer, 0, totalRead);
                        int nEncodedBytes = this.getEncodedStreamPosition();
                        this.listeners.forEach(listener -> {
                            if (this.audioInputStream instanceof PropertiesContainer) {
                                listener.progress(nEncodedBytes, this.sourceDataLine.getMicrosecondPosition(), this.trimBuffer, ((PropertiesContainer)((Object)this.audioInputStream)).properties());
                            } else {
                                listener.progress(nEncodedBytes, this.sourceDataLine.getMicrosecondPosition(), this.trimBuffer, this.emptyMap);
                            }
                        });
                        continue;
                    }
                    if (this.status != Status.PAUSED) continue;
                    if (this.sourceDataLine != null && this.sourceDataLine.isRunning()) {
                        this.sourceDataLine.flush();
                        this.sourceDataLine.stop();
                    }
                    try {
                        while (this.status == Status.PAUSED) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        logger.warning("Thread cannot sleep.\n" + ex);
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "\"Decoder Exception: \" ", ex);
                    this.status = Status.STOPPED;
                    this.generateEvent(Status.STOPPED, this.getEncodedStreamPosition(), null);
                }
            }
            if (this.sourceDataLine != null) {
                this.sourceDataLine.drain();
                this.sourceDataLine.stop();
                this.sourceDataLine.close();
                this.sourceDataLine = null;
            }
            this.closeStream();
            if (nBytesRead == -1) {
                this.generateEvent(Status.EOM, -1, null);
            }
        }
        this.status = Status.STOPPED;
        this.generateEvent(Status.STOPPED, -1, null);
        logger.info("Decoding thread completed");
        return null;
    }

    public int getEncodedStreamPosition() {
        int position = -1;
        if (this.dataSource instanceof File && this.encodedAudioInputStream != null) {
            try {
                position = this.encodedAudioLength - this.encodedAudioInputStream.available();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Cannot get m_encodedaudioInputStream.available()", ex);
                this.stop();
            }
        }
        return position;
    }

    private void closeStream() {
        try {
            if (this.audioInputStream != null) {
                this.audioInputStream.close();
                logger.info("Stream closed");
            }
        }
        catch (IOException ex) {
            logger.warning("Cannot close stream\n" + ex);
        }
    }

    public int getLineBufferSize() {
        return this.lineBufferSize;
    }

    public int getLineCurrentBufferSize() {
        return this.currentLineBufferSize;
    }

    public List<String> getMixers() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (mixerInfos != null) {
            Arrays.stream(mixerInfos).forEach(mInfo -> {
                Line.Info lineInfo = new Line.Info(SourceDataLine.class);
                Mixer mixer = AudioSystem.getMixer(mInfo);
                if (mixer.isLineSupported(lineInfo)) {
                    mixers.add(mInfo.getName());
                }
            });
        }
        return mixers;
    }

    private Mixer getMixer(String name) {
        Mixer mixer = null;
        Mixer.Info[] mixerInfos = AudioSystem.getMixerInfo();
        if (name != null && mixerInfos != null) {
            for (int i = 0; i < mixerInfos.length; ++i) {
                if (!mixerInfos[i].getName().equals(name)) continue;
                mixer = AudioSystem.getMixer(mixerInfos[i]);
                break;
            }
        }
        return mixer;
    }

    private boolean hasControl(Control.Type control, Control component) {
        return component != null && this.sourceDataLine != null && this.sourceDataLine.isControlSupported(control);
    }

    public float getGainValue() {
        return !this.hasControl(FloatControl.Type.MASTER_GAIN, this.gainControl) ? 0.0f : this.gainControl.getValue();
    }

    public float getMaximumGain() {
        return !this.hasControl(FloatControl.Type.MASTER_GAIN, this.gainControl) ? 0.0f : this.gainControl.getMaximum();
    }

    public float getMinimumGain() {
        return !this.hasControl(FloatControl.Type.MASTER_GAIN, this.gainControl) ? 0.0f : this.gainControl.getMinimum();
    }

    public float getPrecision() {
        return !this.hasControl(FloatControl.Type.PAN, this.panControl) ? 0.0f : this.panControl.getPrecision();
    }

    public float getPan() {
        return !this.hasControl(FloatControl.Type.PAN, this.panControl) ? 0.0f : this.panControl.getValue();
    }

    public boolean getMute() {
        return this.hasControl(BooleanControl.Type.MUTE, this.muteControl) && this.muteControl.getValue();
    }

    public float getBalance() {
        return !this.hasControl(FloatControl.Type.BALANCE, this.balanceControl) ? 0.0f : this.balanceControl.getValue();
    }

    public long getTotalBytes() {
        return this.encodedAudioLength;
    }

    public int getPositionByte() {
        int positionByte = -1;
        if (this.audioProperties != null) {
            if (this.audioProperties.containsKey("mp3.position.byte")) {
                return (Integer)this.audioProperties.get("mp3.position.byte");
            }
            if (this.audioProperties.containsKey("ogg.position.byte")) {
                return (Integer)this.audioProperties.get("ogg.position.byte");
            }
        }
        return -1;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public Status getStatus() {
        return this.status;
    }

    private Map<String, Object> deepCopy(Map<String, Object> map) {
        HashMap<String, Object> copier = new HashMap<String, Object>();
        if (map != null) {
            map.keySet().forEach(key -> copier.put((String)key, map.get(key)));
        }
        return copier;
    }

    public void setLineBufferSize(int size) {
        this.lineBufferSize = size;
    }

    public void setPan(double fPan) {
        if (!this.hasControl(FloatControl.Type.PAN, this.panControl) || fPan < -1.0 || fPan > 1.0) {
            return;
        }
        logger.info(() -> "Pan : " + fPan);
        this.panControl.setValue((float)fPan);
        this.generateEvent(Status.PAN, this.getEncodedStreamPosition(), null);
    }

    public void setGain(double fGain) {
        if (this.isPlaying() || this.isPaused() && this.hasControl(FloatControl.Type.MASTER_GAIN, this.gainControl)) {
            this.gainControl.setValue((float)(20.0 * Math.log10(fGain != 0.0 ? fGain : 0.0)));
        }
    }

    public void setMute(boolean mute) {
        if (this.hasControl(BooleanControl.Type.MUTE, this.muteControl) && this.muteControl.getValue() != mute) {
            this.muteControl.setValue(mute);
        }
    }

    public void setBalance(float fBalance) {
        if (this.hasControl(FloatControl.Type.BALANCE, this.balanceControl) && (double)fBalance >= -1.0 && (double)fBalance <= 1.0) {
            this.balanceControl.setValue(fBalance);
        } else {
            try {
                throw new StreamPlayerException(StreamPlayerException.PlayerException.BALANCE_CONTROL_NOT_SUPPORTED);
            }
            catch (StreamPlayerException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void setEqualizer(float[] array, int stop) {
        if (!this.isPausedOrPlaying() || !(this.audioInputStream instanceof PropertiesContainer)) {
            return;
        }
        float[] equalizer = (float[])((PropertiesContainer)((Object)this.audioInputStream)).properties().get("mp3.equalizer");
        for (int i = 0; i < stop; ++i) {
            equalizer[i] = array[i];
        }
    }

    public void setEqualizerKey(float value, int key) {
        if (!this.isPausedOrPlaying() || !(this.audioInputStream instanceof PropertiesContainer)) {
            return;
        }
        float[] equalizer = (float[])((PropertiesContainer)((Object)this.audioInputStream)).properties().get("mp3.equalizer");
        equalizer[key] = value;
    }

    public double getSpeedFactor() {
        return this.speedFactor;
    }

    public boolean isUnknown() {
        return this.status == Status.NOT_SPECIFIED;
    }

    public boolean isPlaying() {
        return this.status == Status.PLAYING;
    }

    public boolean isPaused() {
        return this.status == Status.PAUSED;
    }

    public boolean isPausedOrPlaying() {
        return this.isPlaying() || this.isPaused();
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isOpened() {
        return this.status == Status.OPENED;
    }

    public boolean isSeeking() {
        return this.status == Status.SEEKING;
    }
}

