/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.sampled.spi;

import io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.spi.TAudioFileReader;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.util.SoundException;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jogg.Packet;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jogg.Page;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jogg.StreamState;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jogg.SyncState;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jorbis.Comment;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jorbis.Info;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.jcraft.jorbis.VorbisFile;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.vorbis.sampled.VorbisAudioFileFormat;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class VorbisAudioFileReader
extends TAudioFileReader {
    private static final Logger LOG = Logger.getLogger(VorbisAudioFileReader.class.getName());
    public static final AudioFormat.Encoding VORBISENC = new AudioFormat.Encoding("VORBISENC");
    public static final AudioFileFormat.Type OGG_AUDIOFILEFORMAT_TYPE = new AudioFileFormat.Type("OGG", "ogg");
    private SyncState oggSyncState_ = null;
    private StreamState oggStreamState_ = null;
    private Page oggPage_ = null;
    private Packet oggPacket_ = null;
    private Info vorbisInfo = null;
    private Comment vorbisComment = null;
    private final int bufferMultiple_ = 4;
    private final int bufferSize_ = 2048;
    private byte[] buffer = null;
    private int bytes = 0;
    private int index = 0;
    private InputStream oggBitStream_ = null;
    private static final int INITAL_READ_LENGTH = 64000;
    private static final int MARK_LIMIT = 64001;

    public VorbisAudioFileReader() {
        super(64001, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioFileFormat(File file)");
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            ((InputStream)inputStream).mark(64001);
            this.getAudioFileFormat(inputStream);
            ((InputStream)inputStream).reset();
            VorbisFile vf = new VorbisFile(file.getAbsolutePath());
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, (int)file.length(), Math.round(vf.time_total(-1) * 1000.0f));
            return audioFileFormat;
        }
        catch (SoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioFileFormat(URL url)");
        try (InputStream inputStream = url.openStream();){
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioFileFormat(InputStream inputStream)");
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, -1, -1);
            return audioFileFormat;
        }
        finally {
            inputStream.reset();
        }
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long medialength) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, (int)medialength, -1);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream bitStream, int mediaLength, int totalms) throws UnsupportedAudioFileException, IOException {
        HashMap<String, Object> aff_properties = new HashMap<String, Object>();
        HashMap<String, Object> af_properties = new HashMap<String, Object>();
        if (totalms == -1) {
            totalms = 0;
        }
        if (totalms > 0) {
            aff_properties.put("duration", (long)totalms * 1000L);
        }
        this.oggBitStream_ = bitStream;
        this.oggSyncState_ = new SyncState();
        this.oggStreamState_ = new StreamState();
        this.oggPage_ = new Page();
        this.oggPacket_ = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.buffer = null;
        this.bytes = 0;
        this.oggSyncState_.init();
        this.index = 0;
        try {
            this.readHeaders(aff_properties, af_properties);
        }
        catch (IOException ioe) {
            LOG.log(Level.FINE, ioe.getMessage());
            throw new UnsupportedAudioFileException(ioe.getMessage());
        }
        String dmp = this.vorbisInfo.toString();
        LOG.log(Level.FINE, dmp);
        int ind = dmp.lastIndexOf("bitrate:");
        int minbitrate = -1;
        int nominalbitrate = -1;
        int maxbitrate = -1;
        if (ind != -1) {
            StringTokenizer st = new StringTokenizer(dmp = dmp.substring(ind + 8, dmp.length()), ",");
            if (st.hasMoreTokens()) {
                minbitrate = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                nominalbitrate = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                maxbitrate = Integer.parseInt(st.nextToken());
            }
        }
        if (nominalbitrate > 0) {
            af_properties.put("bitrate", nominalbitrate);
        }
        af_properties.put("vbr", true);
        if (minbitrate > 0) {
            aff_properties.put("ogg.bitrate.min.bps", minbitrate);
        }
        if (maxbitrate > 0) {
            aff_properties.put("ogg.bitrate.max.bps", maxbitrate);
        }
        if (nominalbitrate > 0) {
            aff_properties.put("ogg.bitrate.nominal.bps", nominalbitrate);
        }
        if (this.vorbisInfo.channels > 0) {
            aff_properties.put("ogg.channels", this.vorbisInfo.channels);
        }
        if (this.vorbisInfo.rate > 0) {
            aff_properties.put("ogg.frequency.hz", this.vorbisInfo.rate);
        }
        if (mediaLength > 0) {
            aff_properties.put("ogg.length.bytes", mediaLength);
        }
        aff_properties.put("ogg.version", this.vorbisInfo.version);
        float frameRate = -1.0f;
        if (nominalbitrate > 0) {
            frameRate = nominalbitrate / 8;
        } else if (minbitrate > 0) {
            frameRate = minbitrate / 8;
        }
        AudioFormat format = new AudioFormat(VORBISENC, this.vorbisInfo.rate, -1, this.vorbisInfo.channels, 1, frameRate, false, af_properties);
        return new VorbisAudioFileFormat(OGG_AUDIOFILEFORMAT_TYPE, format, -1, mediaLength, aff_properties);
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioInputStream(InputStream inputStream)");
        return this.getAudioInputStream(inputStream, -1, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream, int medialength, int totalms) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioInputStream(InputStream inputStreamint medialength, int totalms)");
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(64001);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, medialength, totalms);
            inputStream.reset();
            return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        }
        catch (IOException | UnsupportedAudioFileException e) {
            inputStream.reset();
            throw e;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioInputStream(File file)");
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "getAudioInputStream(URL url)");
        InputStream inputStream = url.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw e;
        }
    }

    private void readHeaders(Map<String, Object> aff_properties, Map<String, Object> af_properties) throws IOException {
        LOG.log(Level.FINE, "readHeaders(");
        this.index = this.oggSyncState_.buffer(2048);
        this.buffer = this.oggSyncState_.data;
        this.bytes = this.readFromStream(this.buffer, this.index, 2048);
        if (this.bytes == -1) {
            LOG.log(Level.FINE, "Cannot get any data from selected Ogg bitstream.");
            throw new IOException("Cannot get any data from selected Ogg bitstream.");
        }
        this.oggSyncState_.wrote(this.bytes);
        if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
            if (this.bytes < 2048) {
                throw new IOException("EOF");
            }
            LOG.log(Level.FINE, "Input does not appear to be an Ogg bitstream.");
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.oggStreamState_.init(this.oggPage_.serialno());
        this.vorbisInfo.init();
        this.vorbisComment.init();
        aff_properties.put("ogg.serial", this.oggPage_.serialno());
        if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
            LOG.log(Level.FINE, "Error reading first page of Ogg bitstream data.");
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
            LOG.log(Level.FINE, "Error reading initial header packet.");
            throw new IOException("Error reading initial header packet.");
        }
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
            LOG.log(Level.FINE, "This Ogg bitstream does not contain Vorbis audio data.");
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
        int i = 0;
        while (i < 2) {
            int result;
            while (i < 2 && (result = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                if (result != 1) continue;
                this.oggStreamState_.pagein(this.oggPage_);
                while (i < 2 && (result = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                    if (result == -1) {
                        LOG.log(Level.FINE, "Corrupt secondary header.  Exiting.");
                        throw new IOException("Corrupt secondary header.  Exiting.");
                    }
                    this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_);
                    ++i;
                }
            }
            this.index = this.oggSyncState_.buffer(2048);
            this.buffer = this.oggSyncState_.data;
            this.bytes = this.readFromStream(this.buffer, this.index, 2048);
            if (this.bytes == -1) break;
            if (this.bytes == 0 && i < 2) {
                LOG.log(Level.FINE, "End of file before finding all Vorbis headers!");
                throw new IOException("End of file before finding all Vorbis  headers!");
            }
            this.oggSyncState_.wrote(this.bytes);
        }
        byte[][] ptr = this.vorbisComment.user_comments;
        int c = 0;
        for (byte[] ptr1 : ptr) {
            if (ptr1 == null) break;
            String currComment = new String(ptr1, 0, ptr1.length - 1, "UTF-8").trim();
            LOG.log(Level.FINE, currComment);
            if (currComment.toLowerCase(Locale.ENGLISH).startsWith("artist")) {
                aff_properties.put("author", currComment.substring(7));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("title")) {
                aff_properties.put("title", currComment.substring(6));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("album")) {
                aff_properties.put("album", currComment.substring(6));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("date")) {
                aff_properties.put("date", currComment.substring(5));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("copyright")) {
                aff_properties.put("copyright", currComment.substring(10));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("comment")) {
                aff_properties.put("comment", currComment.substring(8));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("genre")) {
                aff_properties.put("ogg.comment.genre", currComment.substring(6));
            } else if (currComment.toLowerCase(Locale.ENGLISH).startsWith("tracknumber")) {
                aff_properties.put("ogg.comment.track", currComment.substring(12));
            } else {
                aff_properties.put("ogg.comment.ext." + ++c, currComment);
            }
            aff_properties.put("ogg.comment.encodedby", new String(this.vorbisComment.vendor, 0, this.vorbisComment.vendor.length - 1, Charset.forName("US-ASCII")));
        }
    }

    private int readFromStream(byte[] buffer, int index, int bufferSize_) {
        int bytes;
        try {
            bytes = this.oggBitStream_.read(buffer, index, bufferSize_);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Cannot Read Selected Song");
            bytes = -1;
        }
        return bytes;
    }
}

