/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.spi;

import io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.AudioFormats;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public abstract class TFormatConversionProvider
extends FormatConversionProvider {
    private static final Logger LOG = Logger.getLogger(TFormatConversionProvider.class.getName());
    protected static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream audioInputStream) {
        AudioFormat sourceFormat = audioInputStream.getFormat();
        AudioFormat targetFormat = new AudioFormat(targetEncoding, -1.0f, -1, -1, -1, -1.0f, sourceFormat.isBigEndian());
        LOG.log(Level.FINE, "TFormatConversionProvider.getAudioInputStream(AudioFormat.Encoding, AudioInputStream):");
        LOG.log(Level.FINE, "trying to convert to {0}", targetFormat);
        return this.getAudioInputStream(targetFormat, audioInputStream);
    }

    @Override
    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        AudioFormat[] aTargetFormats;
        LOG.log(Level.FINE, ">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
        LOG.log(Level.FINE, "class: {0}", this.getClass().getName());
        LOG.log(Level.FINE, "checking if conversion possible");
        LOG.log(Level.FINE, "from: {0}", sourceFormat);
        LOG.log(Level.FINE, "to: {0}", targetFormat);
        for (AudioFormat aTargetFormat : aTargetFormats = this.getTargetFormats(targetFormat.getEncoding(), sourceFormat)) {
            LOG.log(Level.FINE, "checking against possible target format: {0}", aTargetFormat);
            if (aTargetFormat == null || !AudioFormats.matches(aTargetFormat, targetFormat)) continue;
            LOG.log(Level.FINE, "<result=true");
            return true;
        }
        LOG.log(Level.FINE, "<result=false");
        return false;
    }
}

