/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.spi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public abstract class TAudioFileReader
extends AudioFileReader {
    private static final Logger LOG = Logger.getLogger(TAudioFileReader.class.getName());
    private int m_nMarkLimit = -1;
    private final boolean m_bRereading;

    protected TAudioFileReader(int nMarkLimit, boolean bRereading) {
        this.m_nMarkLimit = nMarkLimit;
        this.m_bRereading = bRereading;
    }

    private int getMarkLimit() {
        return this.m_nMarkLimit;
    }

    private boolean isRereading() {
        return this.m_bRereading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(File): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = file.length();
        AudioFileFormat audioFileFormat = null;
        try (FileInputStream inputStream = new FileInputStream(file);){
            audioFileFormat = this.getAudioFileFormat(inputStream, lFileLengthInBytes);
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(File): end");
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(URL): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = TAudioFileReader.getDataLength(url);
        AudioFileFormat audioFileFormat = null;
        try (InputStream inputStream = url.openStream();){
            audioFileFormat = this.getAudioFileFormat(inputStream, lFileLengthInBytes);
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(URL): end");
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(InputStream): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = -1L;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, this.getMarkLimit());
        }
        inputStream.mark(this.getMarkLimit());
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream, lFileLengthInBytes);
        }
        finally {
            inputStream.reset();
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioFileFormat(InputStream): end");
        return audioFileFormat;
    }

    protected abstract AudioFileFormat getAudioFileFormat(InputStream var1, long var2) throws UnsupportedAudioFileException, IOException;

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(File): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = file.length();
        FileInputStream inputStream = new FileInputStream(file);
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(File): end");
        return audioInputStream;
    }

    @Override
    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(URL): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = TAudioFileReader.getDataLength(url);
        InputStream inputStream = url.openStream();
        AudioInputStream audioInputStream = null;
        try {
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            inputStream.close();
            throw e;
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(URL): end");
        return audioInputStream;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(InputStream): begin (class: {0})", this.getClass().getSimpleName());
        long lFileLengthInBytes = -1L;
        AudioInputStream audioInputStream = null;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, this.getMarkLimit());
        }
        inputStream.mark(this.getMarkLimit());
        try {
            audioInputStream = this.getAudioInputStream(inputStream, lFileLengthInBytes);
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.reset();
            throw e;
        }
        catch (IOException e) {
            block6: {
                try {
                    inputStream.reset();
                }
                catch (IOException e2) {
                    if (e2.getCause() != null) break block6;
                    e2.initCause(e);
                    throw e2;
                }
            }
            throw e;
        }
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(InputStream): end");
        return audioInputStream;
    }

    protected AudioInputStream getAudioInputStream(InputStream inputStream, long lFileLengthInBytes) throws UnsupportedAudioFileException, IOException {
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(InputStream, long): begin (class: {0})", this.getClass().getSimpleName());
        if (this.isRereading()) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, this.getMarkLimit());
            }
            inputStream.mark(this.getMarkLimit());
        }
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, lFileLengthInBytes);
        if (this.isRereading()) {
            inputStream.reset();
        }
        AudioInputStream audioInputStream = new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        LOG.log(Level.FINE, "TAudioFileReader.getAudioInputStream(InputStream, long): end");
        return audioInputStream;
    }

    private static long getDataLength(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        int length = connection.getContentLength();
        return length > 0 ? (long)length : -1L;
    }
}

