/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.spi;

import io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.AudioFormats;
import io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled.spi.TFormatConversionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public abstract class SimpleFormatConversionProvider
extends TFormatConversionProvider {
    private static final Logger LOG = Logger.getLogger(SimpleFormatConversionProvider.class.getName());
    private final Collection<AudioFormat.Encoding> m_sourceEncodings = new ArrayList<AudioFormat.Encoding>();
    private final Collection<AudioFormat.Encoding> m_targetEncodings = new ArrayList<AudioFormat.Encoding>();
    private final Collection<AudioFormat> m_sourceFormats;
    private final Collection<AudioFormat> m_targetFormats;

    private static void collectEncodings(Collection<AudioFormat> formats, Collection<AudioFormat.Encoding> encodings) {
        for (AudioFormat format : formats) {
            encodings.add(format.getEncoding());
        }
    }

    protected SimpleFormatConversionProvider(Collection<AudioFormat> sourceFormats, Collection<AudioFormat> targetFormats) {
        if (sourceFormats == null) {
            sourceFormats = new ArrayList<AudioFormat>();
        }
        if (targetFormats == null) {
            targetFormats = new ArrayList<AudioFormat>();
        }
        this.m_sourceFormats = sourceFormats;
        this.m_targetFormats = targetFormats;
        SimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        SimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.m_sourceEncodings.toArray(EMPTY_ENCODING_ARRAY);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.m_targetEncodings.toArray(EMPTY_ENCODING_ARRAY);
    }

    @Override
    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        return this.m_sourceEncodings.contains(sourceEncoding);
    }

    @Override
    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        return this.m_targetEncodings.contains(targetEncoding);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (this.isAllowedSourceFormat(sourceFormat)) {
            return this.getTargetEncodings();
        }
        return EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            return this.m_targetFormats.toArray(EMPTY_FORMAT_ARRAY);
        }
        return EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceFormat(AudioFormat sourceFormat) {
        for (AudioFormat format : this.m_sourceFormats) {
            if (!AudioFormats.matches(format, sourceFormat)) continue;
            return true;
        }
        return false;
    }
}

