/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.com.github.trilarion.sound.sampled;

import java.util.logging.Level;
import java.util.logging.Logger;

public class CircularBuffer {
    private static final Logger LOG = Logger.getLogger(CircularBuffer.class.getName());
    private final boolean m_bBlockingRead;
    private final boolean m_bBlockingWrite;
    private final byte[] m_abData;
    private final int m_nSize;
    private long m_lReadPos;
    private long m_lWritePos;
    private final BufferListener m_trigger;
    private boolean m_bOpen;

    public CircularBuffer(int nSize, boolean bBlockingRead, boolean bBlockingWrite, BufferListener trigger) {
        this.m_bBlockingRead = bBlockingRead;
        this.m_bBlockingWrite = bBlockingWrite;
        this.m_nSize = nSize;
        this.m_abData = new byte[this.m_nSize];
        this.m_lReadPos = 0L;
        this.m_lWritePos = 0L;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    private boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return (int)(this.m_lWritePos - this.m_lReadPos);
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return (int)(this.m_lReadPos % (long)this.m_nSize);
    }

    private int getWritePos() {
        return (int)(this.m_lWritePos % (long)this.m_nSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] abData, int nOffset, int nLength) {
        LOG.log(Level.FINE, ">TCircularBuffer.read(): called.");
        this.dumpInternalState();
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                nLength = Math.min(nLength, this.availableRead());
                LOG.log(Level.FINE, "reading rest in closed buffer, length: {0}", nLength);
            } else {
                LOG.log(Level.FINE, "< not open. returning -1.");
                return -1;
            }
        }
        CircularBuffer circularBuffer = this;
        synchronized (circularBuffer) {
            if (this.m_trigger != null && this.availableRead() < nLength) {
                LOG.log(Level.FINE, "executing trigger.");
                this.m_trigger.dataReady();
            }
            if (!this.m_bBlockingRead) {
                nLength = Math.min(this.availableRead(), nLength);
            }
            int nRemainingBytes = nLength;
            while (nRemainingBytes > 0) {
                while (this.availableRead() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.log(Level.FINE, e.getMessage());
                    }
                }
                int nAvailable = Math.min(this.availableRead(), nRemainingBytes);
                while (nAvailable > 0) {
                    int nToRead = Math.min(nAvailable, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), abData, nOffset, nToRead);
                    this.m_lReadPos += (long)nToRead;
                    nOffset += nToRead;
                    nAvailable -= nToRead;
                    nRemainingBytes -= nToRead;
                }
                this.notifyAll();
            }
            LOG.log(Level.FINE, "After read:");
            LOG.log(Level.FINE, "< completed. Read {0} bytes", nLength);
            return nLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] abData, int nOffset, int nLength) {
        LOG.log(Level.FINE, ">TCircularBuffer.write(): called; nLength: {0}", nLength);
        this.dumpInternalState();
        CircularBuffer circularBuffer = this;
        synchronized (circularBuffer) {
            LOG.log(Level.FINE, "entered synchronized block.");
            if (!this.m_bBlockingWrite) {
                nLength = Math.min(this.availableWrite(), nLength);
            }
            int nRemainingBytes = nLength;
            while (nRemainingBytes > 0) {
                while (this.availableWrite() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.log(Level.FINE, e.getMessage());
                    }
                }
                int nAvailable = Math.min(this.availableWrite(), nRemainingBytes);
                while (nAvailable > 0) {
                    int nToWrite = Math.min(nAvailable, this.m_nSize - this.getWritePos());
                    System.arraycopy(abData, nOffset, this.m_abData, this.getWritePos(), nToWrite);
                    this.m_lWritePos += (long)nToWrite;
                    nOffset += nToWrite;
                    nAvailable -= nToWrite;
                    nRemainingBytes -= nToWrite;
                }
                this.notifyAll();
            }
            LOG.log(Level.FINE, "After write:");
            this.dumpInternalState();
            LOG.log(Level.FINE, "< completed. Wrote {0} bytes", nLength);
            return nLength;
        }
    }

    private void dumpInternalState() {
        LOG.log(Level.FINE, "m_lReadPos  = {0} ^= {1}", new Object[]{this.m_lReadPos, this.getReadPos()});
        LOG.log(Level.FINE, "m_lWritePos = {0} ^= {1}", new Object[]{this.m_lWritePos, this.getWritePos()});
        LOG.log(Level.FINE, "availableRead()  = {0}", this.availableRead());
        LOG.log(Level.FINE, "availableWrite() = {0}", this.availableWrite());
    }

    public static interface BufferListener {
        public void dataReady();
    }
}

