/*
 * Decompiled with CFR 0.152.
 */
package io.github.maki99999.biomebeats.biome;

import io.github.maki99999.biomebeats.biome.BiomeChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

public class BiomeManager {
    private static final int MOST_RECENT_BIOMES_COUNT = 5;
    private static final int TICKS_BEFORE_NOTIFYING = 60;
    private final Collection<BiomeChangeListener> biomeChangeListener = new HashSet<BiomeChangeListener>();
    private final List<Holder<Biome>> mostRecentBiomes = new ArrayList<Holder<Biome>>();
    private Holder<Biome> lastBiome;
    private long ticksNotInCurrentBiome = Integer.MAX_VALUE;

    public void tick() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.detectBiomeChange(minecraft.f_91073_, minecraft.f_91074_);
    }

    private void updateMostRecentBiomes(Holder<Biome> currentBiome) {
        this.mostRecentBiomes.remove(currentBiome);
        this.mostRecentBiomes.add(0, currentBiome);
        if (this.mostRecentBiomes.size() > 5) {
            this.mostRecentBiomes.remove(this.mostRecentBiomes.size() - 1);
        }
    }

    public List<Holder<Biome>> getMostRecentBiomes() {
        return this.mostRecentBiomes;
    }

    private void detectBiomeChange(ClientLevel level, LocalPlayer player) {
        if (level != null && player != null) {
            Holder currentBiome = level.m_204166_(player.m_20183_());
            this.updateMostRecentBiomes((Holder<Biome>)currentBiome);
            if (this.lastBiome != currentBiome) {
                ++this.ticksNotInCurrentBiome;
                if (this.ticksNotInCurrentBiome > 60L) {
                    for (BiomeChangeListener listener : this.biomeChangeListener) {
                        listener.onBiomeChanged((Holder<Biome>)currentBiome);
                    }
                    this.lastBiome = currentBiome;
                }
            } else {
                this.ticksNotInCurrentBiome = 0L;
            }
        } else {
            this.ticksNotInCurrentBiome = Integer.MAX_VALUE;
            for (BiomeChangeListener listener : this.biomeChangeListener) {
                listener.onBiomeChanged(null);
            }
            this.lastBiome = null;
        }
    }

    public void addBiomeChangeListener(BiomeChangeListener listener) {
        this.biomeChangeListener.add(listener);
        listener.onBiomeChanged(this.lastBiome);
    }

    public void clearBiomeChangeListeners() {
        this.biomeChangeListener.clear();
    }
}

