/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.emi;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.emi.EmiBaseLoot;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.TooltipWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EmiGameplayLoot
extends EmiBaseLoot {
    private final ResourceLocation location;

    public EmiGameplayLoot(EmiRecipeCategory category, ResourceLocation id, IDataNode lootTable, List<ItemStack> outputs) {
        super(category, id, lootTable, 0, 10, Collections.emptyList(), outputs);
        this.location = id;
    }

    public int getDisplayHeight() {
        return 10 + this.getItemsHeight();
    }

    @Override
    protected List<Widget> getAdditionalWidgets(WidgetHolder widgetHolder) {
        String key = "ali/loot_table/" + this.location.m_135815_();
        Component text = GenericUtils.ellipsis(key, this.location.m_135815_(), widgetHolder.getWidth() - 10);
        MutableComponent fullText = Component.m_237113_((String)this.location.toString());
        Bounds bounds = new Bounds(0, 0, widgetHolder.getWidth() - 10, 8);
        return List.of(new TextWidget(text.m_7532_(), 0, 0, 0, false), new TitleWidget(bounds, (Component)fullText));
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }

    private static class TitleWidget
    extends TooltipWidget {
        public TitleWidget(Bounds bounds, Component component) {
            super(TitleWidget.getTooltipSupplier(bounds, component), 0, 0, bounds.width(), bounds.height());
        }

        @NotNull
        private static BiFunction<Integer, Integer, List<ClientTooltipComponent>> getTooltipSupplier(Bounds bounds, Component component) {
            return (mx, my) -> {
                if (bounds.contains(mx.intValue(), my.intValue())) {
                    return List.of(ClientTooltipComponent.m_169948_((FormattedCharSequence)component.m_7532_()));
                }
                return List.of();
            };
        }
    }
}

