/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.compat.crafttweaker;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class ActionSetStructureStaging
implements IUndoableAction {
    private final ResourceLocation structureLocation;
    private final String[] stages;

    public ActionSetStructureStaging(ResourceLocation structureLocation, String[] stages) {
        this.structureLocation = structureLocation;
        this.stages = stages;
    }

    public boolean shouldApplyOn(IScriptLoadSource source, Logger logger) {
        return true;
    }

    public void undo() {
        Set strings = GameStagesHelper.STRUCTURE_STAGES.computeIfAbsent(this.structureLocation, s -> new HashSet());
        List.of(this.stages).forEach(strings::remove);
        GameStagesHelper.STRUCTURE_STAGES.put(this.structureLocation, strings);
    }

    public String describeUndo() {
        return "Removing the stages \"" + Arrays.toString(this.stages) + "\" of structure: \"" + String.valueOf(this.structureLocation) + "\"";
    }

    public void apply() {
        Set strings = GameStagesHelper.STRUCTURE_STAGES.computeIfAbsent(this.structureLocation, s -> new HashSet());
        strings.addAll(Arrays.asList(this.stages));
        GameStagesHelper.STRUCTURE_STAGES.put(this.structureLocation, strings);
    }

    public String describe() {
        return "Set the stages of structure: \"" + String.valueOf(this.structureLocation) + "\" to: " + Arrays.toString(this.stages);
    }

    public String systemName() {
        return "structurecompass";
    }
}

