/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.mixin.LivingEntityAccessor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class KnockoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(LivingDamageEvent.class, KnockoutHandler::onPlayerDamage);
        Balm.getEvents().onEvent(PlayerRespawnEvent.class, KnockoutHandler::onPlayerRespawn);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, KnockoutHandler::onPlayerTick);
    }

    public static void onPlayerDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            boolean canDamageSourceKnockout;
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource damageSource = event.getDamageSource();
            if (HardcoreRevival.getRevivalData((Entity)event.getEntity()).isKnockedOut()) {
                Entity attacker = damageSource.m_7639_();
                if (attacker instanceof Mob) {
                    Mob mob = (Mob)attacker;
                    mob.m_6710_(null);
                }
                if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_276093_(HardcoreRevivalManager.NOT_RESCUED_IN_TIME)) {
                    event.setCanceled(true);
                }
                return;
            }
            boolean bl = canDamageSourceKnockout = !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
            if (canDamageSourceKnockout && KnockoutHandler.isKnockoutEnabledFor(player, damageSource) && player.m_21223_() - event.getDamageAmount() <= 0.0f) {
                event.setDamageAmount(Math.min(event.getDamageAmount(), Math.max(0.0f, player.m_21223_() - 1.0f)));
                if (((LivingEntityAccessor)player).callCheckTotemDeathProtection(damageSource)) {
                    event.setCanceled(true);
                } else {
                    HardcoreRevival.getManager().knockout((Player)player, damageSource);
                }
            }
        }
    }

    private static boolean isKnockoutEnabledFor(ServerPlayer player, DamageSource damageSource) {
        ResourceLocation entityTypeId;
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return false;
        }
        boolean canDamageSourceKnockout = !damageSource.m_276093_(DamageTypes.f_268724_) && !damageSource.m_276093_(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
        ResourceLocation damageSourceId = player.m_20194_().m_206579_().m_175515_(Registries.f_268580_).m_7981_((Object)damageSource.m_269415_());
        if (!canDamageSourceKnockout || HardcoreRevivalConfig.getActive().instantDeathSources.contains(Objects.toString(damageSourceId))) {
            return false;
        }
        Entity attacker = damageSource.m_7639_();
        if (attacker != null && HardcoreRevivalConfig.getActive().instantDeathEntityTypes.contains(Objects.toString(entityTypeId = BuiltInRegistries.f_256780_.m_7981_((Object)attacker.m_6095_())))) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInSingleplayer && server.m_129792_() && server.m_7416_() == 1) {
            return false;
        }
        return !HardcoreRevivalConfig.getActive().disableInLonelyMultiplayer || server.m_129792_() || server.m_7416_() != 1;
    }

    public static void onPlayerTick(ServerPlayer player) {
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((Entity)player);
        if (revivalData.isKnockedOut() && player.m_6084_()) {
            int maxTicksUntilDeath;
            player.m_21153_(1.0f);
            revivalData.setKnockoutTicksPassed(revivalData.getKnockoutTicksPassed() + 1);
            if (player.f_19797_ % 20 == 0) {
                Balm.getHooks().setForcedPose((Player)player, (Pose)(revivalData.isKnockedOut() ? Pose.FALL_FLYING : null));
            }
            if ((maxTicksUntilDeath = HardcoreRevivalConfig.getActive().ticksUntilDeath) > 0 && revivalData.getKnockoutTicksPassed() >= maxTicksUntilDeath) {
                HardcoreRevival.getManager().notRescuedInTime((Player)player);
            }
        }
    }

    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        HardcoreRevival.getManager().reset((Player)event.getNewPlayer());
    }
}

