/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.item.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.jrdemiurge.skyarena.Config;
import net.jrdemiurge.skyarena.config.SkyArenaConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RewardKeyItem
extends Item {
    public static final Set<BlockPos> keyedChests = new HashSet<BlockPos>();
    public static final List<String> BLOCK_ID_BLACKLIST = List.of("lootr:lootr_chest", "lootr:lootr_inventory", "lootr:lootr_trapped_chest");

    public RewardKeyItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos positionClicked = pContext.m_8083_();
        Player player = pContext.m_43723_();
        InteractionHand hand = pContext.m_43724_();
        if (!level.m_5776_() && player != null) {
            BlockEntity blockEntity = level.m_7702_(positionClicked);
            BlockState clickedBlockState = level.m_8055_(positionClicked);
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)clickedBlockState.m_60734_());
            if (blockId != null && BLOCK_ID_BLACKLIST.contains(blockId.toString())) {
                return InteractionResult.PASS;
            }
            if (blockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestEntity = (ChestBlockEntity)blockEntity;
                if (Config.requireEmptyChest && !chestEntity.m_7983_()) {
                    return InteractionResult.FAIL;
                }
                chestEntity.m_6211_();
                ItemStack itemStack = player.m_21120_(hand);
                String itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString();
                List<String> lootTables = SkyArenaConfig.configData.keys.getOrDefault(itemId, SkyArenaConfig.DEFAULT_KEY);
                LootDataManager lootManager = level.m_7654_().m_278653_();
                List<ResourceLocation> validLootTables = lootTables.stream().map(ResourceLocation::new).filter(id -> lootManager.m_278676_(id) != LootTable.f_79105_).toList();
                if (!validLootTables.isEmpty()) {
                    ResourceLocation randomLootTable = validLootTables.get(new Random().nextInt(validLootTables.size()));
                    System.out.println("Loot table: " + String.valueOf(randomLootTable));
                    chestEntity.m_59626_(randomLootTable, player.m_217043_().m_188505_());
                    chestEntity.m_59640_(player);
                }
                int keyCount = itemStack.m_41613_();
                player.m_36335_().m_41524_(player.m_21120_(hand).m_41720_(), 15);
                player.m_21120_(hand).m_41774_(1);
                level.m_5594_(null, positionClicked, SoundEvents.f_144245_, SoundSource.PLAYERS, 5.0f, 1.0f);
                if (keyCount == 1) {
                    keyedChests.add(positionClicked.m_7949_());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.skyarena.reward_key"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

