/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.event;

import net.jrdemiurge.skyarena.util.MobGriefingProtectionZones;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="skyarena")
public class MobGriefingHandler {
    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Vec3 explosionPos = event.getExplosion().getPosition();
        BlockPos center = BlockPos.m_274446_((Position)explosionPos);
        if (MobGriefingProtectionZones.isInZone(level, center)) {
            event.getAffectedBlocks().clear();
        }
    }

    @SubscribeEvent
    public static void onMobGriefingCheck(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.f_46443_ && MobGriefingProtectionZones.isInZone(level, entity.m_20183_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (!level.f_46443_ && MobGriefingProtectionZones.isInZone(level, event.getPos())) {
            event.setCanceled(true);
        }
    }
}

