/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.skyarena.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jrdemiurge.skyarena.Config;
import net.jrdemiurge.skyarena.block.custom.AltarBlock;
import net.jrdemiurge.skyarena.block.entity.ModBlockEntity;
import net.jrdemiurge.skyarena.config.ArenaConfig;
import net.jrdemiurge.skyarena.config.DifficultyLevelRange;
import net.jrdemiurge.skyarena.config.ExpandedMobInfo;
import net.jrdemiurge.skyarena.config.MobGroup;
import net.jrdemiurge.skyarena.config.PresetWave;
import net.jrdemiurge.skyarena.config.SkyArenaConfig;
import net.jrdemiurge.skyarena.config.WaveMob;
import net.jrdemiurge.skyarena.scheduler.Scheduler;
import net.jrdemiurge.skyarena.util.BossBarHideZones;
import net.jrdemiurge.skyarena.util.FullProtectionZones;
import net.jrdemiurge.skyarena.util.MobGriefingProtectionZones;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class AltarBlockEntity
extends BlockEntity {
    private static final Map<Player, BlockPos> activeAltarBlocks = new HashMap<Player, BlockPos>();
    private Player activatingPlayer;
    public final List<Entity> summonedMobs = new ArrayList<Entity>();
    private boolean battlePhaseActive = false;
    private boolean playerDeath = false;
    private int deathDelay = 0;
    private long battleEndTime = 0L;
    private int glowingCounter = 0;
    private boolean firstMessageSent = false;
    private static final Map<Player, Long> playerMessageTimestamps = new HashMap<Player, Long>();
    private ItemStack recordItem = ItemStack.f_41583_;
    private boolean isPlayingMusic = false;
    private long musicEndTick = 0L;
    private long musicTickCount = 0L;
    private int difficultyLevel = 1;
    private int battleDifficultyLevel = 1;
    private String arenaType = "sky_arena";
    private int mobSpawnRadius;
    private int spawnDistanceFromPlayer;
    private int battleLossDistance;
    private int mobTeleportDistance;
    private int mobGriefingProtectionRadius = 0;
    private int fullProtectionRadius = 0;
    private int bossBarHideRadius = 0;
    private int mobCostRatio;
    private boolean allowDifficultyReset;
    private boolean allowWaterAndAirSpawn;
    private boolean individualPlayerStats;
    private boolean setNight;
    private boolean setRain;
    private boolean disableMobItemDrop;
    private int startingPoints;
    private double startingStatMultiplier;
    private boolean resetDifficultyOnDefeat;
    private boolean autoWaveRun;
    private double pointsCoefficientPerBlocks;
    private double statMultiplierCoefficientPerBlocks;
    private double lootTableCountCoefficientPerBlocks;
    private List<DifficultyLevelRange> difficultyLevelRanges = new ArrayList<DifficultyLevelRange>();
    private LinkedHashMap<String, MobGroup> mobGroups = new LinkedHashMap();
    private LinkedHashMap<Integer, PresetWave> presetWaves = new LinkedHashMap();
    private final Map<String, Integer> playerDifficulty = new HashMap<String, Integer>();

    public AltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntity.ALTAR_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public void loadArenaConfig(String arenaType) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return;
        }
        ArenaConfig arenaConfig = SkyArenaConfig.configData == null ? SkyArenaConfig.DEFAULT_ARENA : SkyArenaConfig.configData.arenas.getOrDefault(arenaType, SkyArenaConfig.DEFAULT_ARENA);
        if (arenaConfig != null) {
            this.arenaType = arenaType;
            this.mobSpawnRadius = arenaConfig.mobSpawnRadius != 0 ? arenaConfig.mobSpawnRadius : 36;
            this.spawnDistanceFromPlayer = arenaConfig.spawnDistanceFromPlayer;
            this.battleLossDistance = arenaConfig.battleLossDistance != 0 ? arenaConfig.battleLossDistance : 60;
            this.mobTeleportDistance = arenaConfig.mobTeleportDistance != 0 ? arenaConfig.mobTeleportDistance : 50;
            this.mobGriefingProtectionRadius = arenaConfig.mobGriefingProtectionRadius;
            this.fullProtectionRadius = arenaConfig.fullProtectionRadius;
            this.bossBarHideRadius = arenaConfig.bossBarHideRadius;
            this.mobCostRatio = arenaConfig.mobCostRatio != 0 ? arenaConfig.mobCostRatio : 20;
            this.allowDifficultyReset = arenaConfig.allowDifficultyReset;
            this.allowWaterAndAirSpawn = arenaConfig.allowWaterAndAirSpawn;
            this.individualPlayerStats = arenaConfig.individualPlayerStats;
            this.setNight = arenaConfig.setNight;
            this.setRain = arenaConfig.setRain;
            this.disableMobItemDrop = arenaConfig.disableMobItemDrop;
            this.startingPoints = arenaConfig.startingPoints != 0 ? arenaConfig.startingPoints : 500;
            this.startingStatMultiplier = arenaConfig.startingStatMultiplier != 0.0 ? arenaConfig.startingStatMultiplier : 1.0;
            this.resetDifficultyOnDefeat = arenaConfig.resetDifficultyOnDefeat;
            this.autoWaveRun = arenaConfig.autoWaveRun;
            this.pointsCoefficientPerBlocks = arenaConfig.pointsCoefficientPer1000BlocksFromWorldCenter;
            this.statMultiplierCoefficientPerBlocks = arenaConfig.statMultiplierCoefficientPer1000BlocksFromWorldCenter;
            this.lootTableCountCoefficientPerBlocks = arenaConfig.lootTableCountCoefficientPer1000BlocksFromWorldCenter;
            if (this.fullProtectionRadius != 0 && this.fullProtectionRadius > this.mobGriefingProtectionRadius) {
                this.mobGriefingProtectionRadius = this.fullProtectionRadius;
            }
            this.difficultyLevelRanges = arenaConfig.difficultyLevelRanges != null ? new ArrayList<DifficultyLevelRange>(arenaConfig.difficultyLevelRanges) : new ArrayList<DifficultyLevelRange>();
            this.mobGroups = arenaConfig.mobGroups != null ? new LinkedHashMap<String, MobGroup>(arenaConfig.mobGroups) : new LinkedHashMap();
            this.presetWaves = arenaConfig.presetWaves != null ? new LinkedHashMap<Integer, PresetWave>(arenaConfig.presetWaves) : new LinkedHashMap();
            if (this.f_58857_ != null) {
                MobGriefingProtectionZones.remove(this.f_58857_, this.m_58899_());
                if (this.mobGriefingProtectionRadius != 0) {
                    MobGriefingProtectionZones.add(this.f_58857_, this.m_58899_(), this.mobGriefingProtectionRadius);
                }
                FullProtectionZones.remove(this.f_58857_, this.m_58899_());
                if (this.fullProtectionRadius != 0) {
                    FullProtectionZones.add(this.f_58857_, this.m_58899_(), this.fullProtectionRadius);
                }
                BossBarHideZones.remove(this.f_58857_, this.m_58899_());
                if (this.bossBarHideRadius != 0) {
                    BossBarHideZones.add(this.f_58857_, this.m_58899_(), this.bossBarHideRadius);
                }
            }
            if (this.f_58857_ != null) {
                this.f_58857_.m_151543_(this.m_58899_());
            }
        }
    }

    public void switchToNextArena() {
        if (SkyArenaConfig.configData == null) {
            return;
        }
        ArrayList<String> arenaTypes = new ArrayList<String>(SkyArenaConfig.configData.arenas.keySet());
        if (arenaTypes.isEmpty()) {
            return;
        }
        int currentIndex = arenaTypes.indexOf(this.arenaType);
        int nextIndex = (currentIndex + 1) % arenaTypes.size();
        this.arenaType = (String)arenaTypes.get(nextIndex);
        this.loadArenaConfig(this.arenaType);
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }

    public void m_6339_() {
        super.m_6339_();
        if (!this.f_58857_.m_5776_()) {
            if (this.mobGriefingProtectionRadius != 0) {
                MobGriefingProtectionZones.add(this.f_58857_, this.m_58899_(), this.mobGriefingProtectionRadius);
            }
            if (this.fullProtectionRadius != 0) {
                FullProtectionZones.add(this.f_58857_, this.m_58899_(), this.fullProtectionRadius);
            }
            if (this.bossBarHideRadius != 0) {
                BossBarHideZones.add(this.f_58857_, this.m_58899_(), this.bossBarHideRadius);
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.removeSummonedMobs();
        if (!this.f_58857_.m_5776_()) {
            MobGriefingProtectionZones.remove(this.f_58857_, this.m_58899_());
            FullProtectionZones.remove(this.f_58857_, this.m_58899_());
            BossBarHideZones.remove(this.f_58857_, this.m_58899_());
        }
        this.stopMusic();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("DifficultyLevel", this.difficultyLevel);
        pTag.m_128359_("ArenaType", this.arenaType);
        pTag.m_128405_("StartingPoints", this.startingPoints);
        pTag.m_128347_("StartingStatMultiplier", this.startingStatMultiplier);
        pTag.m_128405_("MobSpawnRadius", this.mobSpawnRadius);
        pTag.m_128405_("MobCostRatio", this.mobCostRatio);
        pTag.m_128405_("SpawnDistanceFromPlayer", this.spawnDistanceFromPlayer);
        pTag.m_128405_("BattleLossDistance", this.battleLossDistance);
        pTag.m_128405_("MobTeleportDistance", this.mobTeleportDistance);
        pTag.m_128379_("AllowDifficultyReset", this.allowDifficultyReset);
        pTag.m_128379_("AllowWaterAndAirSpawn", this.allowWaterAndAirSpawn);
        pTag.m_128379_("IndividualPlayerStats", this.individualPlayerStats);
        pTag.m_128379_("SetNight", this.setNight);
        pTag.m_128379_("SetRain", this.setRain);
        pTag.m_128379_("EnableMobItemDrop", this.disableMobItemDrop);
        pTag.m_128405_("MobGriefingProtectionRadius", this.mobGriefingProtectionRadius);
        pTag.m_128405_("FullProtectionRadius", this.fullProtectionRadius);
        pTag.m_128405_("BossBarHideRadius", this.bossBarHideRadius);
        pTag.m_128379_("ResetDifficultyOnDefeat", this.resetDifficultyOnDefeat);
        pTag.m_128379_("AutoWaveRun", this.autoWaveRun);
        pTag.m_128347_("PointsCoefficientPerBlocks", this.pointsCoefficientPerBlocks);
        pTag.m_128347_("StatMultiplierCoefficientPerBlocks", this.statMultiplierCoefficientPerBlocks);
        pTag.m_128347_("LootTableCountCoefficientPerBlocks", this.lootTableCountCoefficientPerBlocks);
        if (!this.recordItem.m_41619_()) {
            pTag.m_128365_("RecordItem", (Tag)this.recordItem.m_41739_(new CompoundTag()));
        }
        if (!this.playerDifficulty.isEmpty()) {
            CompoundTag difficultyTag = new CompoundTag();
            for (Map.Entry entry : this.playerDifficulty.entrySet()) {
                difficultyTag.m_128405_((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            pTag.m_128365_("PlayerDifficulty", (Tag)difficultyTag);
        }
        if (!this.difficultyLevelRanges.isEmpty()) {
            ListTag rangesTag = new ListTag();
            for (DifficultyLevelRange difficultyLevelRange : this.difficultyLevelRanges) {
                CompoundTag rangeTag = new CompoundTag();
                ListTag intList = new ListTag();
                Iterator<Object> iterator = difficultyLevelRange.range.iterator();
                while (iterator.hasNext()) {
                    int val = iterator.next();
                    intList.add((Object)IntTag.m_128679_((int)val));
                }
                rangeTag.m_128365_("Range", (Tag)intList);
                rangeTag.m_128405_("PointsIncrease", difficultyLevelRange.pointsIncrease);
                rangeTag.m_128347_("StatMultiplierIncrease", difficultyLevelRange.statMultiplierIncrease);
                rangeTag.m_128359_("RewardLootTable", difficultyLevelRange.rewardLootTable);
                rangeTag.m_128405_("RewardCount", difficultyLevelRange.rewardCount);
                ListTag usedGroupsTag = new ListTag();
                for (String group : difficultyLevelRange.mobGroupsUsed) {
                    usedGroupsTag.add((Object)StringTag.m_129297_((String)group));
                }
                rangeTag.m_128365_("MobGroupsUsed", (Tag)usedGroupsTag);
                rangesTag.add((Object)rangeTag);
            }
            pTag.m_128365_("DifficultyLevelRanges", (Tag)rangesTag);
        }
        if (!this.mobGroups.isEmpty()) {
            CompoundTag groupsTag = new CompoundTag();
            for (Map.Entry entry : this.mobGroups.entrySet()) {
                CompoundTag groupTag = new CompoundTag();
                MobGroup group = (MobGroup)entry.getValue();
                groupTag.m_128347_("SquadSpawnChance", group.squadSpawnChance);
                groupTag.m_128405_("SquadSpawnSize", group.squadSpawnSize);
                groupTag.m_128347_("StatMultiplierCoefficient", group.statMultiplierCoefficient);
                groupTag.m_128347_("MobSpawnChance", group.mobSpawnChance);
                CompoundTag mobValuesTag = new CompoundTag();
                for (Map.Entry<String, Integer> mobEntry : group.mobValues.entrySet()) {
                    mobValuesTag.m_128405_(mobEntry.getKey(), mobEntry.getValue().intValue());
                }
                groupTag.m_128365_("MobValues", (Tag)mobValuesTag);
                groupsTag.m_128365_((String)entry.getKey(), (Tag)groupTag);
            }
            pTag.m_128365_("MobGroups", (Tag)groupsTag);
        }
        if (!this.presetWaves.isEmpty()) {
            CompoundTag presetWavesTag = new CompoundTag();
            for (Map.Entry entry : this.presetWaves.entrySet()) {
                CompoundTag waveTag = new CompoundTag();
                waveTag.m_128347_("MobStatMultiplier", ((PresetWave)entry.getValue()).mobStatMultiplier);
                waveTag.m_128359_("RewardLootTable", ((PresetWave)entry.getValue()).rewardLootTable);
                waveTag.m_128405_("RewardCount", ((PresetWave)entry.getValue()).rewardCount);
                ListTag mobsTag = new ListTag();
                for (WaveMob mob : ((PresetWave)entry.getValue()).mobs) {
                    CompoundTag mobTag = new CompoundTag();
                    mobTag.m_128359_("Type", mob.type);
                    mobTag.m_128405_("Count", mob.count);
                    mobsTag.add((Object)mobTag);
                }
                waveTag.m_128365_("Mobs", (Tag)mobsTag);
                presetWavesTag.m_128365_(((Integer)entry.getKey()).toString(), (Tag)waveTag);
            }
            pTag.m_128365_("PresetWaves", (Tag)presetWavesTag);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        ArenaConfig arenaConfig;
        super.m_142466_(pTag);
        if (pTag.m_128441_("DifficultyLevel")) {
            this.difficultyLevel = pTag.m_128451_("DifficultyLevel");
        }
        if (pTag.m_128441_("ArenaType")) {
            this.arenaType = pTag.m_128461_("ArenaType");
        }
        if (pTag.m_128441_("StartingPoints")) {
            this.startingPoints = pTag.m_128451_("StartingPoints");
        }
        if (pTag.m_128441_("StartingStatMultiplier")) {
            this.startingStatMultiplier = pTag.m_128459_("StartingStatMultiplier");
        }
        if (pTag.m_128441_("MobSpawnRadius")) {
            this.mobSpawnRadius = pTag.m_128451_("MobSpawnRadius");
        }
        if (pTag.m_128441_("MobCostRatio")) {
            this.mobCostRatio = pTag.m_128451_("MobCostRatio");
        }
        if (pTag.m_128441_("SpawnDistanceFromPlayer")) {
            this.spawnDistanceFromPlayer = pTag.m_128451_("SpawnDistanceFromPlayer");
        }
        if (pTag.m_128441_("BattleLossDistance")) {
            this.battleLossDistance = pTag.m_128451_("BattleLossDistance");
        }
        if (pTag.m_128441_("MobTeleportDistance")) {
            this.mobTeleportDistance = pTag.m_128451_("MobTeleportDistance");
        }
        if (pTag.m_128441_("AllowDifficultyReset")) {
            this.allowDifficultyReset = pTag.m_128471_("AllowDifficultyReset");
        }
        if (pTag.m_128441_("AllowWaterAndAirSpawn")) {
            this.allowWaterAndAirSpawn = pTag.m_128471_("AllowWaterAndAirSpawn");
        }
        if (pTag.m_128441_("IndividualPlayerStats")) {
            this.individualPlayerStats = pTag.m_128471_("IndividualPlayerStats");
        }
        if (pTag.m_128441_("SetNight")) {
            this.setNight = pTag.m_128471_("SetNight");
        }
        if (pTag.m_128441_("SetRain")) {
            this.setRain = pTag.m_128471_("SetRain");
        }
        if (pTag.m_128441_("EnableMobItemDrop")) {
            this.disableMobItemDrop = pTag.m_128471_("EnableMobItemDrop");
        }
        if (pTag.m_128441_("MobGriefingProtectionRadius")) {
            this.mobGriefingProtectionRadius = pTag.m_128451_("MobGriefingProtectionRadius");
        }
        if (pTag.m_128441_("FullProtectionRadius")) {
            this.fullProtectionRadius = pTag.m_128451_("FullProtectionRadius");
        }
        if (pTag.m_128441_("BossBarHideRadius")) {
            this.bossBarHideRadius = pTag.m_128451_("BossBarHideRadius");
        }
        if (pTag.m_128441_("ResetDifficultyOnDefeat")) {
            this.resetDifficultyOnDefeat = pTag.m_128471_("ResetDifficultyOnDefeat");
        }
        if (pTag.m_128441_("AutoWaveRun")) {
            this.autoWaveRun = pTag.m_128471_("AutoWaveRun");
        }
        if (pTag.m_128441_("PointsCoefficientPerBlocks")) {
            this.pointsCoefficientPerBlocks = pTag.m_128459_("PointsCoefficientPerBlocks");
        }
        if (pTag.m_128441_("StatMultiplierCoefficientPerBlocks")) {
            this.statMultiplierCoefficientPerBlocks = pTag.m_128459_("StatMultiplierCoefficientPerBlocks");
        }
        if (pTag.m_128441_("LootTableCountCoefficientPerBlocks")) {
            this.lootTableCountCoefficientPerBlocks = pTag.m_128459_("LootTableCountCoefficientPerBlocks");
        }
        if (pTag.m_128441_("RecordItem")) {
            this.recordItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("RecordItem"));
        }
        if (pTag.m_128441_("PlayerDifficulty")) {
            CompoundTag difficultyTag = pTag.m_128469_("PlayerDifficulty");
            for (String key : difficultyTag.m_128431_()) {
                this.playerDifficulty.put(key, difficultyTag.m_128451_(key));
            }
        }
        if (pTag.m_128441_("DifficultyLevelRanges")) {
            ListTag rangesTag = pTag.m_128437_("DifficultyLevelRanges", 10);
            this.difficultyLevelRanges.clear();
            for (Tag tag : rangesTag) {
                Object intTag2;
                CompoundTag rangeTag = (CompoundTag)tag;
                DifficultyLevelRange range = new DifficultyLevelRange();
                ListTag intList = rangeTag.m_128437_("Range", 3);
                range.range = new ArrayList<Integer>();
                for (Object intTag2 : intList) {
                    range.range.add(((IntTag)intTag2).m_7047_());
                }
                range.pointsIncrease = rangeTag.m_128451_("PointsIncrease");
                range.statMultiplierIncrease = rangeTag.m_128459_("StatMultiplierIncrease");
                range.rewardLootTable = rangeTag.m_128461_("RewardLootTable");
                range.rewardCount = rangeTag.m_128451_("RewardCount");
                ListTag usedGroupsTag = rangeTag.m_128437_("MobGroupsUsed", 8);
                range.mobGroupsUsed = new ArrayList<String>();
                intTag2 = usedGroupsTag.iterator();
                while (intTag2.hasNext()) {
                    Tag groupTag = (Tag)intTag2.next();
                    range.mobGroupsUsed.add(((StringTag)groupTag).m_7916_());
                }
                this.difficultyLevelRanges.add(range);
            }
        }
        if (pTag.m_128441_("MobGroups")) {
            CompoundTag groupsTag = pTag.m_128469_("MobGroups");
            this.mobGroups.clear();
            for (String key : groupsTag.m_128431_()) {
                CompoundTag groupTag = groupsTag.m_128469_(key);
                MobGroup group = new MobGroup();
                group.squadSpawnChance = groupTag.m_128459_("SquadSpawnChance");
                group.squadSpawnSize = groupTag.m_128451_("SquadSpawnSize");
                group.statMultiplierCoefficient = groupTag.m_128459_("StatMultiplierCoefficient");
                group.mobSpawnChance = groupTag.m_128459_("MobSpawnChance");
                CompoundTag mobValuesTag = groupTag.m_128469_("MobValues");
                group.mobValues = new LinkedHashMap();
                for (String mobId : mobValuesTag.m_128431_()) {
                    group.mobValues.put(mobId, mobValuesTag.m_128451_(mobId));
                }
                this.mobGroups.put(key, group);
            }
        }
        if (pTag.m_128441_("PresetWaves")) {
            CompoundTag presetWavesTag = pTag.m_128469_("PresetWaves");
            this.presetWaves.clear();
            for (String key : presetWavesTag.m_128431_()) {
                int waveNumber = Integer.parseInt(key);
                CompoundTag waveTag = presetWavesTag.m_128469_(key);
                PresetWave wave = new PresetWave();
                wave.mobStatMultiplier = waveTag.m_128459_("MobStatMultiplier");
                wave.rewardLootTable = waveTag.m_128461_("RewardLootTable");
                wave.rewardCount = waveTag.m_128451_("RewardCount");
                ListTag mobsTag = waveTag.m_128437_("Mobs", 10);
                wave.mobs = new ArrayList<WaveMob>();
                for (Tag tag : mobsTag) {
                    CompoundTag mobTag = (CompoundTag)tag;
                    WaveMob mob = new WaveMob();
                    mob.type = mobTag.m_128461_("Type");
                    mob.count = mobTag.m_128451_("Count");
                    wave.mobs.add(mob);
                }
                this.presetWaves.put(waveNumber, wave);
            }
        }
        if (SkyArenaConfig.configData != null && (arenaConfig = (ArenaConfig)SkyArenaConfig.configData.arenas.getOrDefault(this.arenaType, null)) != null) {
            this.loadArenaConfig(this.arenaType);
        }
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.battlePhaseActive) {
            this.handleMusic();
            this.checkPlayerLeftArena();
            this.handlePlayerDeath();
            this.updateSummonedMobs();
            if (this.autoWaveRun) {
                this.runAutoWave();
            }
        } else {
            this.updateDifficultyMessages();
        }
    }

    private void updateDifficultyMessages() {
        long gameTime = this.f_58857_.m_46467_();
        if (gameTime % 10L != 0L) {
            return;
        }
        AABB area = new AABB(this.f_58858_).m_82400_(2.0);
        List players = this.f_58857_.m_45976_(Player.class, area);
        for (Player player : players) {
            if (!this.isBattleOngoing(this.getDifficultyLevel(player))) {
                return;
            }
            long lastShownTick = playerMessageTimestamps.getOrDefault(player, -40L);
            if (gameTime - lastShownTick < 60L) continue;
            int diff = this.getDifficultyLevel(player);
            player.m_5661_((Component)Component.m_237115_((String)"message.skyarena.difficult_level").m_7220_((Component)Component.m_237113_((String)String.valueOf(diff))), true);
            playerMessageTimestamps.put(player, this.f_58857_.m_46467_() - 20L);
        }
    }

    private void handleMusic() {
        if (!this.isPlayingMusic || this.f_58857_ == null || this.recordItem.m_41619_()) {
            return;
        }
        if (this.musicTickCount >= this.musicEndTick) {
            this.stopMusic();
            this.startMusic();
        }
        ++this.musicTickCount;
    }

    public void startMusic() {
        if (this.f_58857_ != null && !this.recordItem.m_41619_() && !this.isPlayingMusic) {
            this.musicTickCount = this.f_58857_.m_46467_();
            RecordItem record = (RecordItem)this.recordItem.m_41720_();
            this.musicEndTick = this.musicTickCount + (long)record.m_43036_() + 20L;
            this.isPlayingMusic = true;
            this.f_58857_.m_5898_(null, 1010, this.m_58899_(), Item.m_41393_((Item)this.recordItem.m_41720_()));
            this.m_6596_();
        }
    }

    public void stopMusic() {
        if (this.f_58857_ != null && this.isPlayingMusic) {
            this.isPlayingMusic = false;
            this.f_58857_.m_46796_(1011, this.m_58899_(), 0);
            this.m_6596_();
        }
    }

    private void checkPlayerLeftArena() {
        if (this.activatingPlayer == null) {
            return;
        }
        double distance = this.activatingPlayer.m_20238_(this.f_58858_.m_252807_());
        if (distance > (double)(this.battleLossDistance * this.battleLossDistance)) {
            this.onDefeat();
            Player player = this.activatingPlayer;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (Config.enableLossMessageLeave) {
                    this.sendTitle(serverPlayer, "message.skyarena.battle_failed", ChatFormatting.DARK_RED, "message.skyarena.left_arena", ChatFormatting.WHITE);
                }
            }
        }
    }

    private void handlePlayerDeath() {
        if (!this.playerDeath) {
            return;
        }
        ++this.deathDelay;
        if (this.activatingPlayer != null && this.deathDelay > 10) {
            if (this.activatingPlayer.m_21223_() > 0.0f) {
                this.playerDeath = false;
                this.deathDelay = 0;
                return;
            }
            this.onDefeat();
            Player player = this.activatingPlayer;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (Config.enableLossMessageDeath) {
                    this.sendTitle(serverPlayer, "message.skyarena.wasted", ChatFormatting.WHITE, "message.skyarena.battle_failed", ChatFormatting.DARK_RED);
                }
            }
        }
    }

    private void sendTitle(ServerPlayer player, String titleKey, ChatFormatting titleColor, String subtitleKey, ChatFormatting subtitleColor) {
        MutableComponent title = Component.m_237115_((String)titleKey).m_130940_(titleColor);
        MutableComponent subtitle = Component.m_237115_((String)subtitleKey).m_130940_(subtitleColor);
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)title));
        player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitle));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 80, 10));
    }

    public void onDefeat() {
        this.removeSummonedMobs();
        this.setBattlePhaseActive(false);
        this.stopMusic();
        if (this.resetDifficultyOnDefeat) {
            this.setDifficultyLevel(this.activatingPlayer, 1);
        }
        this.removeAltarActivationForPlayer();
        this.playerDeath = false;
        this.deathDelay = 0;
    }

    private void updateSummonedMobs() {
        if (this.activatingPlayer == null) {
            return;
        }
        this.summonedMobs.removeIf(Entity::m_213877_);
        for (Entity entity : this.summonedMobs) {
            List<BlockPos> spawnPositions;
            double mobDistanceToAltar;
            double mobDistance;
            Mob mob;
            if (!(!(entity instanceof Mob) || (mob = (Mob)entity).m_5448_() != null && mob.m_5448_().m_6084_() || this.activatingPlayer.m_7500_() || this.activatingPlayer.m_5833_() || !((mobDistance = this.activatingPlayer.m_20280_(entity)) <= 256.0))) {
                mob.m_6710_((LivingEntity)this.activatingPlayer);
            }
            if (!((mobDistanceToAltar = entity.m_20238_(this.f_58858_.m_252807_())) > (double)(this.mobTeleportDistance * this.mobTeleportDistance)) || (spawnPositions = this.findValidSpawnPositions(this.f_58857_, this.f_58858_, this.activatingPlayer)).isEmpty()) continue;
            BlockPos teleportPos = spawnPositions.get(this.f_58857_.f_46441_.m_188503_(spawnPositions.size()));
            entity.m_6021_((double)teleportPos.m_123341_() + 0.5, (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_() + 0.5);
        }
    }

    private void runAutoWave() {
        if (!this.battlePhaseActive || !this.canSummonMobs()) {
            return;
        }
        long gameTime = this.f_58857_.m_46467_();
        if (gameTime % 5L != 0L) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Block block = state.m_60734_();
        if (!(block instanceof AltarBlock)) {
            return;
        }
        AltarBlock customBlock = (AltarBlock)block;
        customBlock.m_6227_(state, this.f_58857_, this.f_58858_, this.activatingPlayer, InteractionHand.OFF_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)this.f_58858_), Direction.UP, this.f_58858_, false));
        if (!this.isBattleOngoing(this.getDifficultyLevel(this.activatingPlayer))) {
            this.removeAltarActivationForPlayer();
            return;
        }
        for (int i = 0; i < 5; ++i) {
            int finalI = i;
            Scheduler.schedule(() -> {
                Player patt29224$temp = this.activatingPlayer;
                if (patt29224$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt29224$temp;
                    MutableComponent title = Component.m_237115_((String)String.valueOf(5 - finalI));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)title));
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(5, 15, 0));
                }
            }, 20 * i);
        }
        Scheduler.schedule(() -> customBlock.m_6227_(state, this.f_58857_, this.f_58858_, this.activatingPlayer, InteractionHand.OFF_HAND, new BlockHitResult(Vec3.m_82512_((Vec3i)this.f_58858_), Direction.UP, this.f_58858_, false)), 100);
    }

    public List<BlockPos> findValidSpawnPositions(Level level, BlockPos center, Player player) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        if (!this.allowWaterAndAirSpawn) {
            for (int x = -this.mobSpawnRadius; x <= this.mobSpawnRadius; ++x) {
                for (int z = -this.mobSpawnRadius; z <= this.mobSpawnRadius; ++z) {
                    BlockPos currentPos = center.m_7918_(x, 0, z);
                    if (x * x + z * z > this.mobSpawnRadius * this.mobSpawnRadius || !level.m_46859_(currentPos) || !level.m_46859_(currentPos.m_7494_()) || !level.m_46859_(currentPos.m_6630_(2)) || !level.m_46859_(currentPos.m_122012_()) || !level.m_46859_(currentPos.m_122019_()) || !level.m_46859_(currentPos.m_122029_()) || !level.m_46859_(currentPos.m_122024_()) || level.m_46859_(currentPos.m_7495_()) || !(player.m_20183_().m_123331_((Vec3i)currentPos) > (double)(this.spawnDistanceFromPlayer * this.spawnDistanceFromPlayer))) continue;
                    validPositions.add(currentPos);
                }
            }
            return validPositions;
        }
        for (int x = -this.mobSpawnRadius; x <= this.mobSpawnRadius; ++x) {
            for (int z = -this.mobSpawnRadius; z <= this.mobSpawnRadius; ++z) {
                BlockPos currentPos = center.m_7918_(x, 0, z);
                if (x * x + z * z > this.mobSpawnRadius * this.mobSpawnRadius || !level.m_8055_(currentPos).m_60812_((BlockGetter)level, currentPos).m_83281_() || !level.m_8055_(currentPos.m_7494_()).m_60812_((BlockGetter)level, currentPos.m_7494_()).m_83281_() || !level.m_8055_(currentPos.m_6630_(2)).m_60812_((BlockGetter)level, currentPos.m_6630_(2)).m_83281_() || !level.m_8055_(currentPos.m_122012_()).m_60812_((BlockGetter)level, currentPos.m_122012_()).m_83281_() || !level.m_8055_(currentPos.m_122019_()).m_60812_((BlockGetter)level, currentPos.m_122019_()).m_83281_() || !level.m_8055_(currentPos.m_122029_()).m_60812_((BlockGetter)level, currentPos.m_122029_()).m_83281_() || !level.m_8055_(currentPos.m_122024_()).m_60812_((BlockGetter)level, currentPos.m_122024_()).m_83281_() || !(player.m_20183_().m_123331_((Vec3i)currentPos) > (double)(this.spawnDistanceFromPlayer * this.spawnDistanceFromPlayer))) continue;
                validPositions.add(currentPos);
            }
        }
        return validPositions;
    }

    public void applyGlowEffectToSummonedMobs(Player pPlayer) {
        ++this.glowingCounter;
        if (this.glowingCounter > 4) {
            int duration = 12000;
            int amplifier = 0;
            this.glowingCounter = 0;
            int affectedMobs = 0;
            for (Entity mob : this.summonedMobs) {
                if (!(mob instanceof LivingEntity)) continue;
                LivingEntity livingMob = (LivingEntity)mob;
                livingMob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, duration, amplifier, false, false));
                ++affectedMobs;
            }
            if (Config.enableUnclaimedRewardMessage) {
                if (!this.firstMessageSent) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"message.skyarena.unclaimed_reward"), false);
                    this.firstMessageSent = true;
                } else {
                    pPlayer.m_5661_((Component)Component.m_237110_((String)"message.skyarena.mobs_glowing", (Object[])new Object[]{affectedMobs}), true);
                }
                this.putPlayerMessageTimestamps(pPlayer);
            }
        }
    }

    public boolean isBattleOngoing(int difficultyLevel) {
        for (DifficultyLevelRange range : this.difficultyLevelRanges) {
            int start = range.range.get(0);
            int end = range.range.get(1);
            if (difficultyLevel < start || difficultyLevel > end) continue;
            return true;
        }
        return this.presetWaves.containsKey(difficultyLevel);
    }

    public LootReward getRewardFromDifficultyRanges(int difficultyLevel) {
        for (DifficultyLevelRange range : this.difficultyLevelRanges) {
            int start = range.range.get(0);
            int end = range.range.get(1);
            if (difficultyLevel < start || difficultyLevel > end) continue;
            String lootTable = range.rewardLootTable;
            int count = range.rewardCount;
            return new LootReward(lootTable, count);
        }
        return null;
    }

    public List<ExpandedMobInfo> getAvailableMobs(int difficultyLevel) {
        ArrayList<ExpandedMobInfo> result = new ArrayList<ExpandedMobInfo>();
        for (DifficultyLevelRange range : this.difficultyLevelRanges) {
            int start = range.range.get(0);
            int end = range.range.get(1);
            if (difficultyLevel < start || difficultyLevel > end) continue;
            for (String groupId : range.mobGroupsUsed) {
                MobGroup group = this.mobGroups.get(groupId);
                if (group == null) continue;
                for (Map.Entry<String, Integer> entry : group.mobValues.entrySet()) {
                    String mobId = entry.getKey();
                    int cost = entry.getValue();
                    if (!ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(mobId))) continue;
                    ExpandedMobInfo info = new ExpandedMobInfo(mobId, cost, group.squadSpawnChance, group.squadSpawnSize, group.statMultiplierCoefficient, group.mobSpawnChance);
                    result.add(info);
                }
            }
        }
        return result;
    }

    public void removeSummonedMobs() {
        for (Entity mob : this.summonedMobs) {
            if (mob == null || !mob.m_6084_()) continue;
            mob.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.summonedMobs.clear();
    }

    public int getPoints(Player player) {
        int difficulty = this.getDifficultyLevel(player);
        int completedLevels = difficulty - 1;
        int totalPoints = this.startingPoints;
        for (DifficultyLevelRange range : this.difficultyLevelRanges) {
            int start = range.range.get(0);
            int end = range.range.get(1);
            if (completedLevels < start) continue;
            int levelsPassedInRange = Math.min(completedLevels, end) - start + 1;
            totalPoints += levelsPassedInRange * range.pointsIncrease;
        }
        return totalPoints;
    }

    public double getStatMultiplier(Player player) {
        int difficulty = this.getDifficultyLevel(player);
        int completedLevels = difficulty - 1;
        double totalStatMultiplier = this.startingStatMultiplier;
        for (DifficultyLevelRange range : this.difficultyLevelRanges) {
            int start = range.range.get(0);
            int end = range.range.get(1);
            if (completedLevels < start) continue;
            int levelsPassedInRange = Math.min(completedLevels, end) - start + 1;
            totalStatMultiplier += (double)levelsPassedInRange * range.statMultiplierIncrease;
        }
        return totalStatMultiplier;
    }

    public int getDifficultyLevel(Player player) {
        if (this.individualPlayerStats) {
            String key = player.m_36316_().getName() + "_" + this.arenaType;
            return this.playerDifficulty.getOrDefault(key, 1);
        }
        return this.difficultyLevel;
    }

    public void increaseDifficultyLevel(Player player) {
        if (this.individualPlayerStats) {
            String key = player.m_36316_().getName() + "_" + this.arenaType;
            this.playerDifficulty.put(key, this.getDifficultyLevel(player) + 1);
        } else {
            ++this.difficultyLevel;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }

    public void setDifficultyLevel(Player player, int level) {
        if (player == null) {
            return;
        }
        if (this.individualPlayerStats) {
            String key = player.m_36316_().getName() + "_" + this.arenaType;
            this.playerDifficulty.put(key, level);
        } else {
            this.difficultyLevel = level;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }

    public void setRecordItem(ItemStack stack) {
        if (stack.m_41720_() instanceof RecordItem) {
            this.recordItem = stack.m_41777_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_151543_(this.m_58899_());
            }
        }
    }

    public void clearRecordItem() {
        this.recordItem = ItemStack.f_41583_;
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }

    public void addSummonedMob(Entity mob) {
        this.summonedMobs.add(mob);
    }

    public boolean canSummonMobs() {
        this.summonedMobs.removeIf(Entity::m_213877_);
        return this.summonedMobs.isEmpty();
    }

    public void recordAltarActivation(Player player, BlockPos pos) {
        activeAltarBlocks.put(player, pos);
        this.activatingPlayer = player;
    }

    public static BlockPos getAltarPosForPlayer(Player player) {
        return activeAltarBlocks.get(player);
    }

    public void removeAltarActivationForPlayer() {
        activeAltarBlocks.remove(this.activatingPlayer);
    }

    public void putPlayerMessageTimestamps(Player player) {
        playerMessageTimestamps.put(player, this.f_58857_.m_46467_());
    }

    public boolean isResetDifficultyOnDefeat() {
        return this.resetDifficultyOnDefeat;
    }

    public boolean isAutoWaveRun() {
        return this.autoWaveRun;
    }

    public double getPointsCoefficientPerBlocks() {
        return this.pointsCoefficientPerBlocks;
    }

    public double getStatMultiplierCoefficientPerBlocks() {
        return this.statMultiplierCoefficientPerBlocks;
    }

    public double getLootTableCountCoefficientPerBlocks() {
        return this.lootTableCountCoefficientPerBlocks;
    }

    public int getFullProtectionRadius() {
        return this.fullProtectionRadius;
    }

    public int getStartingPoints() {
        return this.startingPoints;
    }

    public void setGlowingCounter(int glowingCounter) {
        this.glowingCounter = glowingCounter;
    }

    public void setPlayerDeath(boolean death) {
        this.playerDeath = death;
    }

    public int getBattleDifficultyLevel() {
        return this.battleDifficultyLevel;
    }

    public void setBattleDifficultyLevel(int battleDifficultyLevel) {
        this.battleDifficultyLevel = battleDifficultyLevel;
    }

    public String getArenaType() {
        return this.arenaType;
    }

    public boolean isBattlePhaseActive() {
        return this.battlePhaseActive;
    }

    public int getSpawnDistanceFromPlayer() {
        return this.spawnDistanceFromPlayer;
    }

    public int getBattleLossDistance() {
        return this.battleLossDistance;
    }

    public int getMobTeleportDistance() {
        return this.mobTeleportDistance;
    }

    public boolean isAllowWaterAndAirSpawn() {
        return this.allowWaterAndAirSpawn;
    }

    public boolean isIndividualPlayerStats() {
        return this.individualPlayerStats;
    }

    public int getMobSpawnRadius() {
        return this.mobSpawnRadius;
    }

    public int getMobCostRatio() {
        return this.mobCostRatio;
    }

    public boolean isSetNight() {
        return this.setNight;
    }

    public boolean isSetRain() {
        return this.setRain;
    }

    public boolean isDisableMobItemDrop() {
        return this.disableMobItemDrop;
    }

    public boolean isAllowDifficultyReset() {
        return this.allowDifficultyReset;
    }

    public int getMobGriefingProtectionRadius() {
        return this.mobGriefingProtectionRadius;
    }

    public int getBossBarHideRadius() {
        return this.bossBarHideRadius;
    }

    public Map<Integer, PresetWave> getPresetWaves() {
        return this.presetWaves;
    }

    public long getBattleEndTime() {
        return this.battleEndTime;
    }

    public void setBattleEndTime(long battleEndTime) {
        this.battleEndTime = battleEndTime;
    }

    public double getStartingStatMultiplier() {
        return this.startingStatMultiplier;
    }

    public List<DifficultyLevelRange> getDifficultyLevelRanges() {
        return this.difficultyLevelRanges;
    }

    public LinkedHashMap<String, MobGroup> getMobGroups() {
        return this.mobGroups;
    }

    public void setBattlePhaseActive(boolean battlePhaseActive) {
        this.battlePhaseActive = battlePhaseActive;
    }

    public Player getActivatingPlayer() {
        return this.activatingPlayer;
    }

    public record LootReward(String rewardLootTable, int rewardCount) {
    }
}

