/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.serialization;

import com.faboslav.structurify.common.config.data.StructureNamespaceData;
import com.faboslav.structurify.common.config.data.structure.BiomeCheckData;
import com.faboslav.structurify.common.config.data.structure.DistanceFromWorldCenterCheckData;
import com.faboslav.structurify.common.config.data.structure.FlatnessCheckData;
import com.faboslav.structurify.common.config.data.structure.OverlapCheckData;
import com.faboslav.structurify.common.config.serialization.BiomeCheckDataSerializer;
import com.faboslav.structurify.common.config.serialization.DistanceFromWorldCenterDataSerializer;
import com.faboslav.structurify.common.config.serialization.FlatnessCheckDataSerializer;
import com.faboslav.structurify.common.config.serialization.OverlapCheckDataSerializer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public final class StructureNamespaceDataSerializer {
    public static final String NAME_PROPERTY = "name";
    private static final String IS_DISABLED_PROPERTY = "is_disabled";

    public static void load(JsonObject structureJson, StructureNamespaceData structureNamespaceData) {
        if (structureJson.has(IS_DISABLED_PROPERTY)) {
            structureNamespaceData.setDisabled(structureJson.get(IS_DISABLED_PROPERTY).getAsBoolean());
        }
        DistanceFromWorldCenterDataSerializer.load(structureJson, structureNamespaceData.getDistanceFromWorldCenterCheckData());
        OverlapCheckDataSerializer.load(structureJson, structureNamespaceData.getOverlapCheckData());
        FlatnessCheckDataSerializer.load(structureJson, structureNamespaceData.getFlatnessCheckData());
        BiomeCheckDataSerializer.load(structureJson, structureNamespaceData.getBiomeCheckData());
    }

    public static void save(JsonArray structureNamespacesJson, String structureName, StructureNamespaceData structureNamespaceData) {
        BiomeCheckData biomeCheckData;
        FlatnessCheckData flatnessCheckData;
        OverlapCheckData overlapCheckData;
        JsonObject structureNamespace = new JsonObject();
        structureNamespace.addProperty(NAME_PROPERTY, structureName);
        structureNamespace.addProperty(IS_DISABLED_PROPERTY, Boolean.valueOf(structureNamespaceData.isDisabled()));
        DistanceFromWorldCenterCheckData distanceFromWorldCenterData = structureNamespaceData.getDistanceFromWorldCenterCheckData();
        if (!distanceFromWorldCenterData.isUsingDefaultValues()) {
            DistanceFromWorldCenterDataSerializer.save(structureNamespace, distanceFromWorldCenterData);
        }
        if (!(overlapCheckData = structureNamespaceData.getOverlapCheckData()).isUsingDefaultValues()) {
            OverlapCheckDataSerializer.save(structureNamespace, overlapCheckData);
        }
        if (!(flatnessCheckData = structureNamespaceData.getFlatnessCheckData()).isUsingDefaultValues()) {
            FlatnessCheckDataSerializer.save(structureNamespace, flatnessCheckData);
        }
        if (!(biomeCheckData = structureNamespaceData.getBiomeCheckData()).isUsingDefaultValues()) {
            BiomeCheckDataSerializer.save(structureNamespace, biomeCheckData);
        }
        structureNamespacesJson.add((JsonElement)structureNamespace);
    }
}

