/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.loot.DepthLayer;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import com.li64.tide.registries.items.StrengthFish;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class TideUtils {
    public static HashMap<String, Item> PROFILE_ITEMS;

    public static boolean moddedDimension(ResourceKey<Level> dimension) {
        return dimension != Level.f_46428_ && dimension != Level.f_46429_ && dimension != Level.f_46430_;
    }

    public static boolean shouldGrabTideLootTable(List<ItemStack> items, FluidState fluid) {
        if (items.stream().anyMatch(item -> item.m_204117_(TideTags.Items.CRATES))) {
            return false;
        }
        if (items.stream().anyMatch(item -> item.m_204117_(TideTags.Items.VANILLA_FISH)) || new Random().nextInt(0, 4) == 0) {
            return true;
        }
        return fluid.m_205070_(TideTags.Fluids.LAVA_FISHING);
    }

    public static ResourceLocation getTideLootTable(double x, double y, double z, FluidState fluid, Level level) {
        DepthLayer layer = DepthLayer.getLayerAt(y);
        Holder biomeHolder = level.m_204166_(new BlockPos((int)x, (int)y, (int)z));
        if (TideUtils.moddedDimension((ResourceKey<Level>)level.m_46472_())) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_SURFACE;
            }
            return BuiltInLootTables.f_78720_;
        }
        if (level.m_46472_() == Level.f_46429_) {
            if (Tide.PLATFORM.isModLoaded("netherdepthsupgrade")) {
                Random random = new Random();
                if (random.nextFloat() > 0.65f) {
                    return new ResourceLocation("netherdepthsupgrade", "gameplay/nether_fishing");
                }
            }
            return TideLootTables.Fishing.NETHER;
        }
        if (level.m_46472_() == Level.f_46430_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.END_LAVA;
            }
            return TideLootTables.Fishing.END_WATER;
        }
        if (layer == DepthLayer.UNDERGROUND && level.m_46472_() == Level.f_46428_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_UNDERGROUND;
            }
            return TideLootTables.Fishing.UNDERGROUND;
        }
        if (layer == DepthLayer.DEPTHS && level.m_46472_() == Level.f_46428_) {
            if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_DEPTHS;
            }
            return TideLootTables.Fishing.DEPTHS;
        }
        if (fluid.m_205070_(TideTags.Fluids.LAVA_FISHING)) {
            return TideLootTables.Fishing.LAVA_SURFACE;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_COLD)) {
            if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_COLD;
            }
            return TideLootTables.Fishing.FRESHWATER_COLD;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_WARM)) {
            if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_WARM;
            }
            return TideLootTables.Fishing.FRESHWATER_WARM;
        }
        if (biomeHolder.m_203656_(TideTags.Climate.IS_SALTWATER)) {
            return TideLootTables.Fishing.SALTWATER_NORMAL;
        }
        return TideLootTables.Fishing.FRESHWATER_NORMAL;
    }

    public static boolean isJournalFish(ItemStack stack) {
        if (PROFILE_ITEMS == null || PROFILE_ITEMS.size() != Tide.JOURNAL.getProfileConfigs().size()) {
            PROFILE_ITEMS = new HashMap();
            Tide.JOURNAL.getProfileConfigs().forEach(config -> PROFILE_ITEMS.put(config.fishItem(), TideUtils.getItemFromName(config.fishItem())));
        }
        return PROFILE_ITEMS.containsKey(TideUtils.getNameFromItem(stack.m_41720_()));
    }

    public static String getNameFromItem(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    public static Item getItemFromName(String name) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(name));
    }

    public static void checkPageCompletion(TidePlayerData data, JournalPage page, ServerPlayer player) {
        if (TideUtils.isCategoryCompleted(data, page) && !data.hasPageCompleted(page)) {
            data.pagesCompleted.add(page.id());
            if (data.pagesCompleted.size() <= 1) {
                TideCriteriaTriggers.FINISH_PAGE.trigger(player);
            }
            if (data.pagesCompleted.size() >= Tide.JOURNAL.getPageConfigs().size() - 1) {
                data.finishedJournal = true;
                TideCriteriaTriggers.FINISH_JOURNAL.trigger(player);
            }
            data.syncTo(player);
            Tide.LOG.debug("Player completed category: {}", (Object)page.idName());
            Tide.LOG.debug("Completed {}/{} categories", (Object)data.pagesCompleted.size(), (Object)Tide.JOURNAL.getPageConfigs().size());
        }
    }

    public static boolean isCategoryCompleted(TidePlayerData data, JournalPage page) {
        List<Item> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        if (fishes == null) {
            return false;
        }
        for (Item fish : fishes) {
            ItemStack fishStack = new ItemStack((ItemLike)fish);
            if (data.hasFishUnlocked(fishStack)) continue;
            return false;
        }
        return true;
    }

    public static void unlockPage(ServerPlayer player, JournalPage page) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        if (!data.hasPageUnlocked(page)) {
            data.unlockPage(page);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((Component)Component.m_237115_((String)"newpage.toast.title"), TideUtils.getPageToastDesc(page), TideUtils.getPageToastIcon(page)), player);
            data.syncTo(player);
        }
    }

    public static void unlockFishForCategory(ServerPlayer player, String name) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return;
        }
        List<Item> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        for (Item fish : fishes) {
            if (data.hasFishUnlocked(fish.m_7968_())) continue;
            data.unlockFish(fish.m_7968_());
        }
        TideUtils.checkPageCompletion(data, page, player);
        data.syncTo(player);
    }

    public static boolean isInPage(String pageName, ItemStack stack) {
        List<Item> fishes = TideUtils.getFishFromPageName(pageName);
        if (fishes == null) {
            return false;
        }
        return fishes.contains(stack.m_41720_());
    }

    public static Component removeRawTextInName(Component initialName) {
        String[] splitName = Component.m_237115_((String)initialName.getString()).getString().split("Raw ");
        StringBuilder nameBuilder = new StringBuilder();
        for (String string : splitName) {
            nameBuilder.append(string);
        }
        return Component.m_237113_((String)nameBuilder.toString());
    }

    public static ItemStack getPageToastIcon(JournalPage page) {
        return page.icon();
    }

    public static Component getPageToastDesc(JournalPage page) {
        return Component.m_237115_((String)page.title());
    }

    public static List<Item> getFishFromProfileList(List<JournalLayout.Profile> profiles) {
        return profiles.stream().map(profile -> (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(profile.fishItem()))).toList();
    }

    public static List<Item> getFishFromPageName(String name) {
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return null;
        }
        return TideUtils.getFishFromProfileList(page.getAllProfiles());
    }

    public static JournalPage getPageByName(String name) {
        JournalLayout.Page pageConfig = Tide.JOURNAL.getPageConfigs().stream().filter(config -> config.id().matches(name)).findFirst().orElse(null);
        if (pageConfig == null) {
            return null;
        }
        return new JournalPage(pageConfig);
    }

    public static JournalLayout.Profile getProfileFromItem(ItemStack item) {
        return Tide.JOURNAL.getProfileConfigs().stream().filter(config -> item.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(config.fishItem())))).findFirst().orElse(null);
    }

    public static float getHighestStrength(List<ItemStack> hookedItems) {
        float bestStrength = 0.0f;
        for (ItemStack hookedItem : hookedItems) {
            float strength = 0.0f;
            Item fish = hookedItem.m_41720_();
            if (fish instanceof StrengthFish) {
                StrengthFish strengthFish = (StrengthFish)fish;
                strength = strengthFish.getStrength();
            }
            if (BuiltInRegistries.f_257033_.m_7981_((Object)fish).m_135827_().contains("unusualend")) {
                strength = 4.5f;
            }
            if (!(strength >= bestStrength)) continue;
            bestStrength = strength;
        }
        return bestStrength;
    }
}

