/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.BaitData;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.items.TideFishingRodItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BaitUtils {
    public static boolean isHoldingBait(ItemStack rod) {
        return BaitUtils.isBait(BaitUtils.getPrimaryBait(rod));
    }

    public static ItemStack getPrimaryBait(ItemStack rod) {
        BaitContents contents = TideFishingRodItem.getContents(rod);
        if (contents.items() == null) {
            return Items.f_41852_.m_7968_();
        }
        for (int i = 0; i < contents.size(); ++i) {
            ItemStack stack = contents.get(i);
            if (!BaitUtils.isBait(stack)) continue;
            return stack;
        }
        return Items.f_41852_.m_7968_();
    }

    public static boolean isBait(ItemStack stack) {
        return Tide.BAIT_DATA.get().stream().anyMatch(baitData -> stack.m_150930_(baitData.getItem()));
    }

    public static Optional<BaitData> getBaitData(ItemStack stack) {
        return Tide.BAIT_DATA.get().stream().filter(baitData -> stack.m_150930_(baitData.getItem())).findFirst();
    }

    public static int getBaitSpeed(ItemStack stack) {
        return BaitUtils.getBaitData(stack).map(BaitData::speedBonus).orElse(0);
    }

    public static int getBaitLuck(ItemStack stack) {
        return BaitUtils.getBaitData(stack).map(BaitData::luckBonus).orElse(0);
    }

    public static int getCrateChance(ItemStack stack) {
        return stack.m_150930_(TideItems.MAGNETIC_BAIT) ? 25 : 0;
    }

    public static List<Component> getDescriptionLines(ItemStack bait) {
        ArrayList<MutableComponent> builder = new ArrayList<MutableComponent>();
        if (!BaitUtils.isBait(bait)) {
            return ImmutableList.copyOf(builder);
        }
        int speed = BaitUtils.getBaitSpeed(bait);
        int luck = BaitUtils.getBaitLuck(bait);
        int crateChance = BaitUtils.getCrateChance(bait);
        if (speed != 0) {
            builder.add(Component.m_237110_((String)"text.tide.bait_tooltip.speed", (Object[])new Object[]{(speed < 0 ? "-" : "+") + speed}).m_130940_(ChatFormatting.BLUE));
        }
        if (luck != 0) {
            builder.add(Component.m_237110_((String)"text.tide.bait_tooltip.lucky", (Object[])new Object[]{(luck < 0 ? "-" : "+") + luck}).m_130940_(ChatFormatting.BLUE));
        }
        if (crateChance != 0) {
            builder.add(Component.m_237110_((String)"text.tide.bait_tooltip.crate", (Object[])new Object[]{(crateChance < 0 ? "-" : "+") + crateChance + "%"}).m_130940_(ChatFormatting.BLUE));
        }
        if (!builder.isEmpty()) {
            builder.add(0, Component.m_237115_((String)"text.tide.bait_tooltip.prefix").m_130940_(ChatFormatting.GRAY));
        } else {
            builder.add(0, Component.m_237115_((String)"text.tide.bait_tooltip.unknown_effects").m_130940_(ChatFormatting.GRAY));
        }
        builder.add(0, Component.m_237119_());
        return ImmutableList.copyOf(builder);
    }
}

