/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.items;

import com.google.common.collect.ImmutableList;
import com.li64.tide.Tide;
import com.li64.tide.client.gui.overlays.CastBarOverlay;
import com.li64.tide.client.gui.overlays.CatchMinigameOverlay;
import com.li64.tide.data.minigame.FishCatchMinigame;
import com.li64.tide.data.rods.AccessoryData;
import com.li64.tide.data.rods.BaitContents;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.data.rods.FishingRodTooltip;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.TideItems;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.util.BaitUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class TideFishingRodItem
extends FishingRodItem {
    public static final ResourceLocation CAST_PROPERTY = Tide.resource("cast");

    public TideFishingRodItem(double baseDurability, Item.Properties properties) {
        super(properties.m_41503_((int)(baseDurability * (Tide.CONFIG == null ? 1.0 : Tide.CONFIG.general.rodDurabilityMultiplier))));
    }

    public boolean isLavaproof(ItemStack stack) {
        return CustomRodManager.getHook(stack).m_150930_(TideItems.LAVAPROOF_FISHING_HOOK) || stack.m_150930_(TideItems.NETHERITE_FISHING_ROD);
    }

    public static List<Component> getDescriptionLines(ItemStack stack) {
        ArrayList<MutableComponent> builder = new ArrayList<MutableComponent>();
        ItemStack bobber = CustomRodManager.getBobber(stack);
        ItemStack hook = CustomRodManager.getHook(stack);
        ItemStack line = CustomRodManager.getLine(stack);
        if (CustomRodManager.hasBobber(stack)) {
            MutableComponent bobberComponent = AccessoryData.getTranslation(bobber);
            builder.add(bobberComponent.m_130940_(ChatFormatting.BLUE));
        }
        if (CustomRodManager.hasHook(stack)) {
            MutableComponent hookComponent = AccessoryData.getTranslation(hook);
            builder.add(hookComponent.m_130940_(ChatFormatting.BLUE));
        }
        if (CustomRodManager.hasLine(stack)) {
            MutableComponent lineComponent = AccessoryData.getTranslation(line);
            builder.add(lineComponent.m_130940_(ChatFormatting.BLUE));
        }
        if (!builder.isEmpty()) {
            builder.add(0, Component.m_237115_((String)"text.tide.rod_tooltip.accessories_prefix").m_130940_(ChatFormatting.GRAY));
            builder.add(0, Component.m_237119_());
            builder.add(Component.m_237119_());
        }
        if (stack.m_150930_(TideItems.CRYSTAL_FISHING_ROD)) {
            builder.add(Component.m_237115_((String)"text.tide.rod_tooltip.crystal_bonus").m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_150930_(TideItems.GOLDEN_FISHING_ROD)) {
            builder.add(Component.m_237115_((String)"text.tide.rod_tooltip.gold_bonus").m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_150930_(TideItems.DIAMOND_FISHING_ROD)) {
            builder.add(Component.m_237115_((String)"text.tide.rod_tooltip.diamond_bonus").m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_150930_(TideItems.NETHERITE_FISHING_ROD)) {
            builder.add(Component.m_237115_((String)"text.tide.rod_tooltip.netherite_bonus").m_130940_(ChatFormatting.GOLD));
        }
        return ImmutableList.copyOf(builder);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return Optional.of(new FishingRodTooltip(TideFishingRodItem.getContents(stack)));
    }

    public static BaitContents getContents(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("bait-contents")) {
            TideFishingRodItem.setContents(stack, new BaitContents());
        }
        return BaitContents.fromNbt(stack.m_41784_().m_128469_("bait-contents"));
    }

    public static void setContents(ItemStack stack, BaitContents contents) {
        stack.m_41784_().m_128365_("bait-contents", (Tag)contents.toNbt());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_142207_(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        BaitContents.Mutable contents = new BaitContents.Mutable(TideFishingRodItem.getContents(stack));
        ItemStack slotStack = slot.m_7993_();
        if (slotStack.m_41619_() && !contents.isEmpty()) {
            ItemStack removedStack = contents.removeStack();
            if (removedStack == null || removedStack.m_41619_()) return false;
            slot.m_150659_(removedStack);
        } else {
            if (slotStack.m_41619_() || !slotStack.m_41720_().m_142095_() || !BaitUtils.isBait(slotStack)) return false;
            contents.tryTransfer(slot, player);
        }
        TideFishingRodItem.setContents(stack, contents.toImmutable());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) return false;
        BaitContents.Mutable contents = new BaitContents.Mutable(TideFishingRodItem.getContents(stack));
        if (other.m_41619_()) {
            ItemStack itemstack = contents.removeStack();
            if (itemstack == null || itemstack.m_41619_()) return false;
            access.m_142104_(itemstack);
        } else {
            if (!other.m_41720_().m_142095_() || !BaitUtils.isBait(other)) return false;
            contents.tryInsert(other);
        }
        TideFishingRodItem.setContents(stack, contents.toImmutable());
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isHookActive(player)) {
            TideFishingHook hook = this.getHook(player);
            if (this.isMinigameStopped(player, level.m_5776_()) && Tide.CONFIG.minigame.doMinigame) {
                if (Tide.PLATFORM.isModLoaded("stardew_fishing")) {
                    if (hook.getCatchType() == TideFishingHook.CatchType.FISH || hook.getCatchType() == TideFishingHook.CatchType.ITEM) {
                        if (!level.m_5776_()) {
                            Tide.LOG.info("Starting stardew fishing minigame");
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
                            if (!Tide.PLATFORM.stardewStart((ServerPlayer)player, (HookAccessor)player.f_36083_, player.m_21120_(hand), hook.getHookedItems())) {
                                this.retrieveHook(player.m_21120_(hand), player, level);
                            }
                        }
                    } else {
                        this.retrieveHook(player.m_21120_(hand), player, level);
                    }
                } else if (hook.getCatchType() == TideFishingHook.CatchType.FISH) {
                    if (!level.m_5776_() && this.isMinigameStopped(player, level.m_5776_())) {
                        Tide.LOG.info("Starting tide fishing minigame");
                        FishCatchMinigame.create(player);
                    }
                } else {
                    if (!level.m_5776_() && FishCatchMinigame.delayActive((ServerPlayer)player)) {
                        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
                    }
                    this.retrieveHook(player.m_21120_(hand), player, level);
                }
            } else if (!Tide.CONFIG.minigame.doMinigame) {
                if (!level.m_5776_()) {
                    hook.retrieve();
                }
            } else if (level.m_5776_()) {
                CatchMinigameOverlay.interact();
            }
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
        }
        if (!level.m_5776_() && FishCatchMinigame.delayActive((ServerPlayer)player)) {
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        if (Tide.CONFIG.general.holdToCast) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.5f, 0.3f / (level.m_213780_().m_188501_() * 0.4f + 0.7f));
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
        }
        this.castHook(player.m_21120_(hand), player, level, 1.0f);
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    private boolean isMinigameStopped(Player player, boolean clientSide) {
        return clientSide ? !CatchMinigameOverlay.isActive() : !FishCatchMinigame.minigameActive(player);
    }

    public void m_5551_(@NotNull ItemStack rod, @NotNull Level level, @NotNull LivingEntity user, int charge) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeDifference = this.m_8105_(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            float chargeMultiplier = (float)chargeDifference / (float)this.getChargeDuration(rod) + 0.5f;
            this.castHook(rod, player, level, chargeMultiplier);
        }
    }

    public boolean isHookActive(Player player) {
        TideFishingHook hook = HookAccessor.getHook(player);
        return hook != null;
    }

    public TideFishingHook getHook(Player player) {
        return HookAccessor.getHook(player);
    }

    public void castHook(ItemStack rod, Player player, Level level, float charge) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook == null) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                int speed = EnchantmentHelper.m_44916_((ItemStack)rod);
                int luck = EnchantmentHelper.m_44904_((ItemStack)rod);
                if (BaitUtils.isHoldingBait(rod)) {
                    speed += BaitUtils.getBaitSpeed(BaitUtils.getPrimaryBait(rod));
                    luck += BaitUtils.getBaitLuck(BaitUtils.getPrimaryBait(rod));
                }
                if (rod.m_150930_(TideItems.GOLDEN_FISHING_ROD)) {
                    ++luck;
                }
                if (Tide.PLATFORM.isModLoaded("hybrid-aquatic")) {
                    if (CustomRodManager.getHook(rod).m_41720_().toString().matches("barbed_hook") && level.m_46461_()) {
                        ++speed;
                    }
                    if (CustomRodManager.getHook(rod).m_41720_().toString().matches("glowing_hook") && level.m_46462_()) {
                        ++speed;
                    }
                    if (CustomRodManager.getHook(rod).m_41720_().toString().matches("magnetic_hook")) {
                        ++luck;
                    }
                }
                level.m_7967_((Entity)new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, level, luck, speed, charge, rod));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            player.m_146850_(GameEvent.f_223698_);
        }
    }

    public void retrieveHook(ItemStack rod, Player player, Level level) {
        TideFishingHook activeHook = HookAccessor.getHook(player);
        if (activeHook != null) {
            if (!level.f_46443_) {
                int durabilityLoss = activeHook.retrieve(rod, (ServerLevel)level, player);
                rod.m_41622_(durabilityLoss, (LivingEntity)player, playerTemp -> playerTemp.m_21190_(player.m_7655_()));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.2f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            player.m_146850_(GameEvent.f_223697_);
        }
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity user, @NotNull ItemStack rod, int charge) {
        super.m_5929_(level, user, rod, charge);
        if (level.m_5776_() && user == Minecraft.m_91087_().f_91074_) {
            int chargeDifference = this.m_8105_(rod) - charge;
            if (chargeDifference > this.getChargeDuration(rod)) {
                chargeDifference = this.getChargeDuration(rod);
            }
            CastBarOverlay.rodChargeTick((float)chargeDifference / (float)this.getChargeDuration(rod));
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 60000;
    }

    public int getChargeDuration(ItemStack rod) {
        return CustomRodManager.getLine(rod).m_150930_(TideItems.BRAIDED_LINE) ? 15 : 25;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    public void onItemBroken(ItemStack stack, ServerPlayer player) {
        List<ItemStack> accessories = CustomRodManager.getAccessoryList(stack);
        accessories.forEach(accessory -> this.giveOrDrop((ItemStack)accessory, (Player)player));
    }

    private void giveOrDrop(ItemStack stack, Player player) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        ItemEntity item = player.m_36176_(stack, false);
        if (item != null) {
            item.m_32061_();
        }
    }
}

