/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc;

import com.li64.tide.Tide;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideEntityTypes;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;

public class LootCrateEntity
extends Entity {
    private BlockState blockState = TideBlocks.SURFACE_LOOT_CRATE.m_49966_();
    private ResourceLocation lootTable;
    private LootParams lootParams;
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(LootCrateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public LootCrateEntity(EntityType<? extends LootCrateEntity> entityType, Level level) {
        super(entityType, level);
    }

    private LootCrateEntity(BlockState blockState, Level level, double px, double py, double pz, ResourceLocation lootTable, LootParams lootParams, double dx, double dy, double dz) {
        this(TideEntityTypes.LOOT_CRATE, level);
        this.blockState = blockState;
        this.f_19850_ = true;
        this.m_6034_(px, py, pz);
        this.m_20334_(dx, dy, dz);
        this.f_19854_ = px;
        this.f_19855_ = py;
        this.f_19856_ = pz;
        this.lootTable = lootTable;
        this.lootParams = lootParams;
        this.setStartPos(this.m_20183_());
    }

    public static LootCrateEntity fall(Level level, BlockPos pos, BlockState blockState, ResourceLocation lootTable, LootParams lootparams, double dx, double dy, double dz) {
        LootCrateEntity entity = new LootCrateEntity(blockState, level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, lootTable, lootparams, dx, dy, dz);
        level.m_7731_(pos, blockState.m_60819_().m_76188_(), 3);
        level.m_7967_((Entity)entity);
        return entity;
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else {
            Block block = this.blockState.m_60734_();
            ++this.time;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.m_9236_().f_46443_) {
                BlockPos blockpos = this.m_20183_();
                if (!this.m_20096_()) {
                    if (!(this.m_9236_().f_46443_ || (this.time <= 100 || blockpos.m_123342_() > this.m_9236_().m_141937_() && blockpos.m_123342_() <= this.m_9236_().m_151558_()) && this.time <= 600)) {
                        if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        if (!this.cancelDrop) {
                            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                            if (flag2) {
                                if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                    this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.m_9236_().m_7731_(blockpos, this.blockState, 3)) {
                                    ((ServerLevel)this.m_9236_()).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.m_9236_().m_8055_(blockpos)));
                                    this.m_146870_();
                                    BlockEntity blockEntity = this.m_9236_().m_7702_(blockpos);
                                    if (blockEntity instanceof Container) {
                                        Container container = (Container)blockEntity;
                                        if (this.blockData != null) {
                                            CompoundTag compoundtag = blockEntity.m_187482_();
                                            for (String s : this.blockData.m_128431_()) {
                                                compoundtag.m_128365_(s, this.blockData.m_128423_(s).m_6426_());
                                            }
                                            try {
                                                blockEntity.m_142466_(compoundtag);
                                            }
                                            catch (Exception exception) {
                                                Tide.LOG.error("Failed to load block entity from loot crate", (Throwable)exception);
                                            }
                                        }
                                        this.setCrateLoot(container);
                                        container.m_6596_();
                                    }
                                } else if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            } else {
                                this.m_146870_();
                                if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            }
                        } else {
                            this.m_146870_();
                            this.callOnBrokenAfterFall(block, blockpos);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos blockPos) {
        this.dropCrateLoot();
    }

    public boolean m_142535_(float p_149643_, float p_149644_, DamageSource source) {
        int i;
        if (this.hurtEntities && (i = Mth.m_14167_((float)(p_149643_ - 1.0f))) >= 0) {
            DamageSource damagesource1;
            Predicate predicate = EntitySelector.f_20406_.and(EntitySelector.f_20403_);
            Block block = this.blockState.m_60734_();
            if (block instanceof Fallable) {
                Fallable fallable = (Fallable)block;
                damagesource1 = fallable.m_252932_((Entity)this);
            } else {
                damagesource1 = this.m_269291_().m_269564_((Entity)this);
            }
            DamageSource damagesource = damagesource1;
            float f = Math.min(Mth.m_14143_((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
            this.m_9236_().m_6249_((Entity)this, this.m_20191_(), predicate).forEach(entity -> entity.m_6469_(damagesource, f));
        }
        return false;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        tag.m_128405_("Time", this.time);
        tag.m_128379_("DropItem", this.dropItem);
        tag.m_128379_("HurtEntities", this.hurtEntities);
        tag.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        tag.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            tag.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        tag.m_128379_("CancelDrop", this.cancelDrop);
    }

    protected void m_7378_(CompoundTag tag) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
        this.time = tag.m_128451_("Time");
        if (tag.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = tag.m_128471_("HurtEntities");
            this.fallDamagePerDistance = tag.m_128457_("FallHurtAmount");
            this.fallDamageMax = tag.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (tag.m_128425_("DropItem", 99)) {
            this.dropItem = tag.m_128471_("DropItem");
        }
        if (tag.m_128425_("TileEntityData", 10)) {
            this.blockData = tag.m_128469_("TileEntityData");
        }
        this.cancelDrop = tag.m_128471_("CancelDrop");
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public void setHurtsEntities(float p_149657_, int p_149658_) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = p_149657_;
        this.fallDamageMax = p_149658_;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory category) {
        super.m_7976_(category);
        category.m_128159_("Imitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.blockState = Block.m_49803_((int)packet.m_131509_());
        this.f_19850_ = true;
        double d0 = packet.m_131500_();
        double d1 = packet.m_131501_();
        double d2 = packet.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }

    public void dropCrateLoot() {
        if (this.lootTable != null && this.m_9236_().m_7654_() != null) {
            LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.lootTable);
            lootTable.m_287195_(this.lootParams).forEach(arg_0 -> ((LootCrateEntity)this).m_19983_(arg_0));
        }
    }

    public void setCrateLoot(Container container) {
        if (this.lootTable != null && this.m_9236_().m_7654_() != null) {
            LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.lootTable);
            loottable.m_287188_(container, this.lootParams, this.f_19796_.m_188505_());
        }
    }
}

