/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.platform;

import com.li64.tide.TideForge;
import com.li64.tide.compat.fishingreal.FishingRealCompat;
import com.li64.tide.compat.hybrid_aquatic.HybridAquaticCompat;
import com.li64.tide.compat.stardewfishing.StardewFishingCompat;
import com.li64.tide.platform.services.TideMainPlatform;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgeMainPlatform
implements TideMainPlatform {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void registerItem(String key, Item item) {
        TideForge.ITEMS.register(key, () -> item);
    }

    @Override
    public void registerBlock(String key, Block block) {
        TideForge.BLOCKS.register(key, () -> block);
    }

    @Override
    public void registerBlockEntity(String key, BlockEntityType<?> blockEntity) {
        TideForge.BLOCK_ENTITIES.register(key, () -> blockEntity);
    }

    @Override
    public void registerEntityType(String key, EntityType<?> entityType) {
        TideForge.ENTITY_TYPES.register(key, () -> entityType);
    }

    @Override
    public void registerCriteriaTrigger(String key, CriterionTrigger<?> trigger) {
        CriteriaTriggers.m_10595_(trigger);
    }

    @Override
    public void registerLootCondition(String key, LootItemConditionType type) {
        TideForge.LOOT_CONDITION_TYPES.register(key, () -> type);
    }

    @Override
    public void registerMenuType(String key, MenuType<?> menuType) {
        TideForge.MENU_TYPES.register(key, () -> menuType);
    }

    @Override
    public void registerSoundEvent(String key, SoundEvent soundEvent) {
        TideForge.SOUND_EVENTS.register(key, () -> soundEvent);
    }

    @Override
    public void registerFeature(String key, Feature<?> feature) {
        TideForge.FEATURES.register(key, () -> feature);
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuType.MenuSupplier<T> menuSupplier, FeatureFlagSet flags) {
        return IForgeMenuType.create((windowId, playerInv, extraData) -> menuSupplier.m_39994_(windowId, playerInv));
    }

    @Override
    public CompoundTag getPlayerData(ServerPlayer player) {
        return player.getPersistentData();
    }

    @Override
    public boolean forgeItemFishedEvent(List<ItemStack> itemList, int i, FishingHook fishing) {
        ItemFishedEvent event = new ItemFishedEvent(itemList, i, fishing);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }

    @Override
    public boolean stardewStart(ServerPlayer player, HookAccessor hook, ItemStack item, List<ItemStack> items) {
        return StardewFishingCompat.start(player, hook, item, items);
    }

    @Override
    public Optional<ArrayList<ItemStack>> stardewGetRewards(HookAccessor hook) {
        return StardewFishingCompat.getRewards(hook);
    }

    @Override
    public double getBiteTimeMultiplier() {
        if (this.isModLoaded("stardew_fishing")) {
            return StardewFishingCompat.getBiteTimeMultiplier();
        }
        return TideMainPlatform.super.getBiteTimeMultiplier();
    }

    @Override
    public Entity fishingRealConvertItemStack(ItemStack stack, Player player, Vec3 pos) {
        return FishingRealCompat.convertItemStack(stack, player, pos);
    }

    @Override
    public Entity hybridAquaticConvertEntity(ItemEntity itemEntity, Player player, TideFishingHook hook) {
        return HybridAquaticCompat.convertEntity(itemEntity, player, hook);
    }
}

