/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.li64.tide.registries.TideLootConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public record MoonPhasePredicate(Optional<List<Integer>> phases) implements LootItemCondition
{
    public static final MapCodec<MoonPhasePredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.listOf().optionalFieldOf("any_of").forGetter(MoonPhasePredicate::phases)).apply((Applicative)instance, MoonPhasePredicate::new));

    public static LootItemCondition.Builder anyOf(int ... phases) {
        return MoonPhasePredicate.anyOf(Arrays.stream(phases).boxed().toList());
    }

    public static LootItemCondition.Builder anyOf(List<Integer> phases) {
        return () -> new MoonPhasePredicate(Optional.ofNullable(phases));
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return TideLootConditions.MOON_PHASE;
    }

    public boolean test(LootContext lootContext) {
        return this.phases.map(phases -> phases.stream().anyMatch(phase -> phase.intValue() == lootContext.m_78952_().m_46941_())).orElse(false);
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return Set.of();
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<MoonPhasePredicate> {
        public void serialize(JsonObject jsonObject, MoonPhasePredicate predicate, @NotNull JsonSerializationContext context) {
            List phases = predicate.phases().orElse(List.of());
            JsonArray array = new JsonArray(phases.size());
            phases.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            jsonObject.add("any_of", (JsonElement)array);
        }

        @NotNull
        public MoonPhasePredicate deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            Optional<List<Integer>> phases = jsonObject.has("any_of") ? Optional.of(jsonObject.get("any_of").getAsJsonArray().asList().stream().map(JsonElement::getAsInt).toList()) : Optional.empty();
            return new MoonPhasePredicate(phases);
        }
    }
}

