/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.li64.tide.registries.TideLootConditions;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record BlockNearbyPredicate(TagKey<Block> blocks, int distance) implements LootItemCondition
{
    public static LootItemCondition.Builder withinDistance(TagKey<Block> blocks, int distance) {
        return () -> new BlockNearbyPredicate(blocks, distance);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return TideLootConditions.BLOCK_NEARBY;
    }

    public boolean test(LootContext context) {
        Vec3 pos = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (pos == null) {
            return false;
        }
        AABB boundingBox = AABB.m_165882_((Vec3)pos, (double)1.0, (double)1.0, (double)1.0).m_82400_((double)this.distance());
        return context.m_78952_().m_45556_(boundingBox).anyMatch(state -> state.m_204336_(this.blocks));
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81460_);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BlockNearbyPredicate> {
        public void serialize(JsonObject jsonObject, BlockNearbyPredicate predicate, @NotNull JsonSerializationContext context) {
            jsonObject.addProperty("blocks", predicate.blocks().f_203868_().toString());
            jsonObject.addProperty("distance", (Number)predicate.distance());
        }

        @NotNull
        public BlockNearbyPredicate deserialize(@NotNull JsonObject jsonObject, @NotNull JsonDeserializationContext context) {
            ResourceLocation location = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"blocks"));
            int distance = jsonObject.get("distance").getAsInt();
            return new BlockNearbyPredicate((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)location), distance);
        }
    }
}

