/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.utils.registry;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.fml.common.Mod;
import net.sonmok14.fromtheshadows.server.Fromtheshadows;
import net.sonmok14.fromtheshadows.server.config.BiomeConfig;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.world.biome.SpawnBiomeData;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="fromtheshadows", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FTSWorldRegistry {
    public static void modifyStructure(Holder<Structure> structure, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (structure.m_203565_(BuiltinStructures.f_209848_) && FTSConfig.clericSpawnRate > 0) {
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.MONSTER).addSpawn(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.CLERIC.get(), FTSConfig.clericSpawnRate, 1, 1));
        }
        if (structure.m_203565_(BuiltinStructures.f_209845_) && FTSConfig.clericSpawnRate > 0) {
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.MONSTER).addSpawn(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.CLERIC.get(), FTSConfig.clericSpawnRate, 1, 1));
        }
        if (structure.m_203565_(BuiltinStructures.f_209857_) && FTSConfig.bulldrogiothShipwreckSpawnRate > 0) {
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.MONSTER).addSpawn(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.BULLDROGIOTH.get(), FTSConfig.bulldrogiothShipwreckSpawnRate, 1, 1));
        }
        if (structure.m_203565_(BuiltinStructures.f_209858_) && FTSConfig.bulldrogiothShipwreckSpawnRate > 0) {
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.MONSTER).addSpawn(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.BULLDROGIOTH.get(), FTSConfig.bulldrogiothShipwreckSpawnRate, 1, 1));
        }
        if (structure.m_203565_(BuiltinStructures.f_209859_) && FTSConfig.nehemothFortressSpawnRate > 0) {
            builder.getStructureSettings().getOrAddSpawnOverrides(MobCategory.MONSTER).addSpawn(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.NEHEMOTH.get(), FTSConfig.nehemothFortressSpawnRate, 1, 1));
        }
    }

    private static ResourceLocation getBiomeName(Holder<Biome> biome) {
        return (ResourceLocation)biome.m_203439_().map(resourceKey -> resourceKey.m_135782_(), noKey -> null);
    }

    public static boolean testBiome(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome) {
        boolean result = false;
        try {
            result = BiomeConfig.test(entry, biome, FTSWorldRegistry.getBiomeName(biome));
        }
        catch (Exception e) {
            Fromtheshadows.LOGGER.warn("could not test biome config for " + (String)entry.getLeft() + ", defaulting to no spawns for mob");
            result = false;
        }
        return result;
    }

    public static void addBiomeSpawns(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (FTSWorldRegistry.testBiome(BiomeConfig.bulldrogith, biome) && FTSConfig.bulldrogiothSpawnRate > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.BULLDROGIOTH.get(), FTSConfig.bulldrogiothSpawnRate, 1, 1));
        }
        if (FTSWorldRegistry.testBiome(BiomeConfig.nehemoth, biome) && FTSConfig.nehemothSpawnRate > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.NEHEMOTH.get(), FTSConfig.nehemothSpawnRate, 1, 1));
        }
        if (FTSWorldRegistry.testBiome(BiomeConfig.murlock, biome) && FTSConfig.froglinSpawnRate > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.FROGLIN.get(), FTSConfig.froglinSpawnRate, 1, 3));
        }
        if (FTSWorldRegistry.testBiome(BiomeConfig.soulnehemoth, biome) && FTSConfig.soulfirenehemothSpawnRate > 0) {
            builder.getMobSpawnSettings().getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)EntityRegistry.NEHEMOTH.get(), FTSConfig.soulfirenehemothSpawnRate, 1, 1));
        }
    }
}

