/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.utils.registry;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.sonmok14.fromtheshadows.server.effect.EffectHealblock;
import net.sonmok14.fromtheshadows.server.effect.EffectHemorrhage;
import net.sonmok14.fromtheshadows.server.effect.EffectPlague;
import net.sonmok14.fromtheshadows.server.effect.EffectSatietyBoost;
import net.sonmok14.fromtheshadows.server.misc.ProperBrewingRecipe;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;

public class EffectRegistry {
    public static final DeferredRegister<Potion> POTION = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"fromtheshadows");
    public static final DeferredRegister<MobEffect> EFFECT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"fromtheshadows");
    public static final RegistryObject<MobEffect> BLESSING_OF_GLUTTONY = EFFECT.register("blessing_of_gluttony", () -> new EffectSatietyBoost(MobEffectCategory.BENEFICIAL, 15909412));
    public static final RegistryObject<MobEffect> PLAGUE = EFFECT.register("plague", () -> new EffectPlague(MobEffectCategory.HARMFUL, 5459280));
    public static final RegistryObject<MobEffect> HEAL_BLOCK = EFFECT.register("heal_block", () -> new EffectHealblock(MobEffectCategory.HARMFUL, 7897742));
    public static final RegistryObject<MobEffect> BLEEDING = EFFECT.register("bleeding", () -> new EffectHemorrhage(MobEffectCategory.HARMFUL, 13249837));
    public static final RegistryObject<Potion> FRENZY_POTION = POTION.register("frenzy", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 1200, 0), new MobEffectInstance(MobEffects.f_19600_, 1200, 1)}));
    public static final RegistryObject<Potion> TERRIBLE_PLAGUE_POTION = POTION.register("terrible_plague", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)PLAGUE.get(), 600, 0), new MobEffectInstance(MobEffects.f_19612_, 300, 1), new MobEffectInstance(MobEffects.f_19613_, 300, 1)}));
    public static final RegistryObject<Potion> BULLDROGIOTH_POTION = POTION.register("hardshell", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 200, 3), new MobEffectInstance(MobEffects.f_19612_, 200, 2)}));

    public static ItemStack createPotion(RegistryObject<Potion> potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)potion.get()));
    }

    public static ItemStack createPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }

    public static void init() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EffectRegistry.createPotion(Potions.f_43586_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.SUSPICIOUS_CLOTH.get()}), EffectRegistry.createPotion(TERRIBLE_PLAGUE_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EffectRegistry.createPotion(Potions.f_43600_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CRIMSON_SHELL.get()}), EffectRegistry.createPotion(BULLDROGIOTH_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EffectRegistry.createPotion(Potions.f_43590_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()}), EffectRegistry.createPotion(FRENZY_POTION)));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()}), (ItemStack)new ItemStack((ItemLike)ItemRegistry.DIABOLIUM_INGOT.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{EffectRegistry.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FROGLIN_LEG.get()}), EffectRegistry.createPotion(Potions.f_43607_)));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{EffectRegistry.createPotion(Potions.f_43599_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CRYSTALLIZED_BLOOD.get()}), (ItemStack)new ItemStack((ItemLike)ItemRegistry.BOTTLE_OF_BLOOD.get()));
    }
}

