/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.utils.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.sonmok14.fromtheshadows.server.items.CrustArmorItem;
import net.sonmok14.fromtheshadows.server.items.PlagueDoctorMaskItem;
import net.sonmok14.fromtheshadows.server.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EnchantmentRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.TagRegistry;

@Mod.EventBusSubscriber
public class ServerEvents {
    private static final double BASE_CHANCE = 0.25;
    private static final double LOOTING_BONUS_PER_LEVEL = 0.15;
    private static final double MAX_DAMAGE_BONUS = 5.0;
    private static final double MAX_ATTACK_SPEED_BONUS = 0.5;
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("7CB67D3C-60ED-4F1E-9242-11BBEF6F43AC");

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        ItemStack weapon = player.m_21205_();
        if (weapon.m_41720_() != ItemRegistry.CRYSTALLIZED_DAGGER.get()) {
            return;
        }
        double health = player.m_21223_();
        AttributeInstance speedAttr = player.m_21051_(Attributes.f_22283_);
        if (speedAttr == null) {
            return;
        }
        speedAttr.m_22120_(SPEED_MODIFIER_UUID);
        if (health < 10.0) {
            double factor = (10.0 - health) / 10.0;
            double bonus = factor * 0.5;
            AttributeModifier speedMod = new AttributeModifier(SPEED_MODIFIER_UUID, "LowHealthAttackSpeedBonus", bonus, AttributeModifier.Operation.ADDITION);
            speedAttr.m_22118_(speedMod);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        LivingEntity target = event.getEntity();
        DamageSource source = event.getSource();
        Level world = target.m_9236_();
        Entity entity = source.m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack weapon = player.m_21205_();
        if (weapon.m_41720_() != ItemRegistry.CRYSTALLIZED_DAGGER.get()) {
            return;
        }
        if (target.m_6095_().m_204039_(TagRegistry.NOT_DROP_CRYSTALLIZED_FRAGMENTS) || target instanceof Animal || target instanceof AbstractFish || target instanceof AbstractVillager || target instanceof AbstractGolem) {
            return;
        }
        int lootingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
        double chance = 0.25 + 0.15 * (double)lootingLevel;
        if (Math.random() < chance) {
            ItemStack crystallized_dagger = new ItemStack((ItemLike)ItemRegistry.CRYSTALLIZED_FRAGMENT.get());
            ItemEntity drop = new ItemEntity(world, target.m_20185_(), target.m_20186_(), target.m_20189_(), crystallized_dagger);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity attacker = event.getEntity();
            ArrayList equipmentList = new ArrayList();
            attacker.m_20158_().forEach(x -> equipmentList.add(x.m_41720_()));
            ArrayList<Item> armorList = new ArrayList<Item>(1);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean flag;
                MobEffectInstance selectedEffect;
                boolean isWearingAll;
                if (slot.m_20743_() == EquipmentSlot.Type.ARMOR && attacker.m_6844_(slot) != null) {
                    armorList.add(attacker.m_6844_(slot).m_41720_());
                }
                if (!(isWearingAll = armorList.containsAll(Arrays.asList((PlagueDoctorMaskItem)((Object)ItemRegistry.PLAGUE_DOCTOR_MASK.get())))) || attacker.m_9236_().f_46443_) continue;
                if (attacker.m_21023_((MobEffect)EffectRegistry.PLAGUE.get())) {
                    attacker.m_21195_((MobEffect)EffectRegistry.PLAGUE.get());
                }
                Iterator itr = attacker.m_21220_().iterator();
                ArrayList<MobEffect> compatibleEffects = new ArrayList<MobEffect>();
                while (itr.hasNext()) {
                    MobEffectInstance effect = (MobEffectInstance)itr.next();
                    if (!effect.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL) || !effect.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))) continue;
                    compatibleEffects.add(effect.m_19544_());
                }
                if (compatibleEffects.size() <= 0 || (selectedEffect = attacker.m_21124_((MobEffect)compatibleEffects.get(attacker.m_9236_().f_46441_.m_188503_(compatibleEffects.size())))) == null || MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(attacker, selectedEffect)) || !(attacker instanceof Player)) continue;
                ItemStack itemStack = attacker.m_6844_(EquipmentSlot.HEAD);
                if (((Player)attacker).m_36335_().m_41519_(itemStack.m_41720_()) || !(flag = attacker.m_21195_(selectedEffect.m_19544_()))) continue;
                ((Player)attacker).m_36335_().m_41524_(itemStack.m_41720_(), 400);
                itemStack.m_41622_(1, attacker, p -> p.m_21166_(EquipmentSlot.HEAD));
            }
        }
    }

    @SubscribeEvent
    public void onFoodConsumed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!item.m_41614_()) {
            return;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)EffectRegistry.BLESSING_OF_GLUTTONY.get());
        if (effect == null) {
            return;
        }
        FoodProperties food = item.m_41720_().m_41473_();
        if (food == null) {
            return;
        }
        int originalHunger = food.m_38744_();
        float saturation = food.m_38745_();
        int bonus = Math.round((float)originalHunger * 0.2f * (float)(effect.m_19564_() + 1));
        player.m_36324_().m_38707_(bonus, saturation);
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_6047_()) {
            ArrayList<Item> armorList = new ArrayList<Item>(3);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean isWearingAll;
                if (slot.m_20743_() == EquipmentSlot.Type.ARMOR && player.m_6844_(slot) != null) {
                    armorList.add(player.m_6844_(slot).m_41720_());
                }
                if (!(isWearingAll = armorList.containsAll(Arrays.asList((CrustArmorItem)((Object)ItemRegistry.CRUST_HEAD.get()), (CrustArmorItem)((Object)ItemRegistry.CRUST_CHEST.get()), (CrustArmorItem)((Object)ItemRegistry.CRUST_LEGGINGS.get()))))) continue;
                event.setAmount(event.getAmount() * 0.5f);
                for (EquipmentSlot crust_armor : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS}) {
                    ItemStack armorPiece = player.m_6844_(crust_armor);
                    armorPiece.m_41622_(10, (LivingEntity)player, p -> p.m_21166_(crust_armor));
                }
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private static boolean isWearingFullDiamondArmor(Player player) {
        ItemStack head = player.m_150109_().m_36052_(3);
        ItemStack chest = player.m_150109_().m_36052_(2);
        ItemStack legs = player.m_150109_().m_36052_(1);
        ItemStack feet = player.m_150109_().m_36052_(0);
        return head.m_41720_() == ItemRegistry.DIABOLIUM_HEAD.get() && chest.m_41720_() == ItemRegistry.DIABOLIUM_CHEST.get() && legs.m_41720_() == ItemRegistry.DIABOLIUM_LEGGINGS.get() && feet.m_41720_() == ItemRegistry.DIABOLIUM_BOOTS.get();
    }

    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent event) {
        if (event.getSource() instanceof DamageSource && event.getSource().m_7639_() instanceof LivingEntity) {
            DamageSource source;
            Entity entity;
            int i;
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            LivingEntity target = event.getEntity();
            ArrayList equipmentList = new ArrayList();
            attacker.m_20158_().forEach(x -> equipmentList.add(x.m_41720_()));
            if (EnchantmentHelper.m_44831_((ItemStack)attacker.m_21205_()).containsKey(EnchantmentRegistry.FREEZING.get()) && (i = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentRegistry.FREEZING.get()), (ItemStack)attacker.m_21205_())) > 0 && target.m_146888_() == 0) {
                target.m_5496_(SoundEvents.f_144205_, 2.0f, 1.0f);
                int frozen = 250 * i;
                target.m_146917_(frozen);
            }
            if (!((entity = (source = event.getSource()).m_7639_()) instanceof Player)) {
                return;
            }
            Player armored_player = (Player)entity;
            if (!ServerEvents.isWearingFullDiamondArmor(armored_player)) {
                return;
            }
            if (ServerEvents.isWearingFullDiamondArmor(armored_player) && !target.m_21023_((MobEffect)EffectRegistry.BLEEDING.get())) {
                target.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 200));
            }
            float damageDealt = event.getAmount();
            float healAmount = damageDealt / 6.0f;
            armored_player.m_5634_(healAmount);
        }
    }
}

