/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.sonmok14.fromtheshadows.client.renderer.items.ThirstforBloodRenderer;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.projectiles.PlayerBreathEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ToolMaterialRegistry;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ThirstforBloodItem
extends SwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Multimap<Attribute, AttributeModifier> attributeModifierMultimap;

    public ThirstforBloodItem(Item.Properties properties) {
        super(ToolMaterialRegistry.THIRST_FOR_BLOOD, 1, -2.4f, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", FTSConfig.thirst_for_blood_damage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("914C2B49-1AD0-451A-A2F3-2ED609F0F291"), "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
        this.attributeModifierMultimap = builder.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ThirstforBloodRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ThirstforBloodRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public int m_6473_() {
        return 18;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifierMultimap : super.m_7167_(equipmentSlot);
    }

    public boolean m_6813_(ItemStack p_43282_, Level p_43283_, BlockState p_43284_, BlockPos p_43285_, LivingEntity p_43286_) {
        if (p_43284_.m_60800_((BlockGetter)p_43283_, p_43285_) != 0.0f) {
            p_43282_.m_41622_(0, p_43286_, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_7579_(ItemStack heldItemStack, LivingEntity target, LivingEntity attacker) {
        heldItemStack.m_41622_(0, attacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        if (!target.m_6084_() && !(target.m_21233_() < 10.0f)) {
            heldItemStack.m_41622_(-1, attacker, p -> p.m_21190_(attacker.m_7655_()));
        }
        return true;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        if (itemStack.m_41773_() < itemStack.m_41776_() - 1) {
            user.m_36335_().m_41524_((Item)this, 40);
            user.m_5496_((SoundEvent)SoundRegistry.SOUL_LASER.get(), 3.0f, 0.8f + user.m_217043_().m_188501_() * 0.1f);
            float radius1 = 0.2f;
            if (!world.f_46443_) {
                ScreenShakeEntity.ScreenShake(world, user.m_20182_(), 5.0f, 0.03f, 15, 10);
                PlayerBreathEntity beam = new PlayerBreathEntity((EntityType<? extends PlayerBreathEntity>)((EntityType)EntityRegistry.PLAYER_BREATH.get()), user.m_9236_(), (LivingEntity)user, user.m_20185_(), user.m_20186_() + (double)1.2f, user.m_20189_(), (float)((double)(user.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-user.m_146909_()) * Math.PI / 180.0), 10);
                world.m_7967_((Entity)beam);
                itemStack.m_41622_(1, (LivingEntity)user, p -> p.m_21190_(user.m_7655_()));
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ != EnchantmentCategory.BREAKABLE && enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.thirst_for_blood.text").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.thirst_for_blood.text2").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

