/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.sonmok14.fromtheshadows.client.renderer.items.DevilSplitterRenderer;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.FTSMobType;
import net.sonmok14.fromtheshadows.server.entity.mob.NehemothEntity;
import net.sonmok14.fromtheshadows.server.items.util.DevilSplitterHandler;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ToolMaterialRegistry;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DevilSplitterItem
extends SwordItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Multimap<Attribute, AttributeModifier> attributeModifierMultimap;

    public DevilSplitterItem(Item.Properties properties) {
        super(ToolMaterialRegistry.DEVIL_SPLITTER, 1, -2.4f, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", FTSConfig.devil_splitter_damage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("D5CD480F-F2CF-4162-955E-B9A2C8EB7425"), "Tool modifier", 1.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifierMultimap = builder.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private DevilSplitterRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DevilSplitterRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public boolean m_7579_(ItemStack p_43278_, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            DevilSplitterHandler.onHitEntity(attacker, target);
        }
        if (target.m_6336_() == FTSMobType.DEMON || target instanceof NehemothEntity) {
            if (!target.m_6084_()) {
                p_43278_.m_41622_(-20, attacker, p -> p.m_21190_(attacker.m_7655_()));
            }
            if (!attacker.m_9236_().m_5776_()) {
                float baseDamage = (float)attacker.m_21133_(Attributes.f_22281_);
                baseDamage *= 2.0f;
                float cooldownFactor = 1.0f;
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    cooldownFactor = player.m_36403_(0.5f);
                }
                float finalDamage = baseDamage * cooldownFactor;
                boolean success = target.m_6469_(attacker.m_269291_().m_269333_(attacker), finalDamage);
                if (success) {
                    float healAmount = finalDamage / 6.0f;
                    attacker.m_5634_(healAmount);
                }
            }
        }
        return super.m_7579_(p_43278_, target, attacker);
    }

    public int m_6473_() {
        return 18;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifierMultimap : super.m_7167_(equipmentSlot);
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6832_(ItemStack p_41134_, ItemStack p_41135_) {
        return p_41135_.m_150930_((Item)ItemRegistry.BOTTLE_OF_BLOOD.get());
    }

    public boolean isRepairable(ItemStack stack) {
        return super.isRepairable(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.devil_splitter.text").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.devil_splitter.text2").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.devil_splitter.text3").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)Component.m_237115_((String)"fromtheshadows.devil_splitter.text4").m_130940_(ChatFormatting.BLUE));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

