/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.entity.mob;

import com.github.darkpred.morehitboxes.api.EntityHitboxData;
import com.github.darkpred.morehitboxes.api.EntityHitboxDataFactory;
import com.github.darkpred.morehitboxes.api.GeckoLibMultiPartEntity;
import com.github.darkpred.morehitboxes.api.MultiPart;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.sonmok14.fromtheshadows.server.Fromtheshadows;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.FTSMobType;
import net.sonmok14.fromtheshadows.server.entity.mob.BulldrogiothEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.DoomBreathEntity;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ScreenShakeEntity;
import net.sonmok14.fromtheshadows.server.misc.WorldData;
import net.sonmok14.fromtheshadows.server.utils.SoundHelper;
import net.sonmok14.fromtheshadows.server.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ParticleRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NehemothEntity
extends Monster
implements Enemy,
GeoEntity,
GeckoLibMultiPartEntity<NehemothEntity> {
    private final EntityHitboxData<NehemothEntity> hitboxData = EntityHitboxDataFactory.create((Mob)this);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_RIGHT = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STONE = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(NehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackID;
    private int stunnedTick;
    public int attacktick;
    public int landingTick;
    public int biteCooldown;
    public int smashCooldown;
    public int breathCooldown;
    public int roarCooldown;
    public float growlProgress;
    public static final byte MELEE_ATTACK = 1;
    public static final byte MELEE_ATTACK_ONCE = 2;
    public static final byte BITE_ATTACK = 3;
    public static final byte ROAR_ATTACK = 4;
    public static final byte SMASH_ATTACK = 5;
    public static final byte BREATH_ATTACK = 6;
    public static final byte GUARD = 7;
    public static final ResourceLocation STONE_LOOT = new ResourceLocation("fromtheshadows", "entities/nehemoth_stone");
    private int triggerLimit = -1;
    private int triggerCount = 0;

    public NehemothEntity(EntityType<? extends NehemothEntity> type, Level world) {
        super(type, world);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        NehemothEntity.setConfigattribute((LivingEntity)this, FTSConfig.nehemoth_health_multiplier, FTSConfig.nehemoth_melee_damage_multiplier);
        this.f_21364_ = 30;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eyeglow", 5, event -> {
            event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.eyeglow"));
            return PlayState.CONTINUE;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "growl", 15, event -> {
            if (this.growlProgress <= 60.0f && this.m_6084_() && !this.isStone() && this.m_5448_() == null) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.growl"));
            }
            event.resetCurrentAnimation();
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "stone", 50, event -> {
            if (this.isStone()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.stop1"));
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, event -> {
            if (!this.isStone()) {
                if (!event.isMoving() && this.attackID == 0 && !this.isClimbing() && this.landingTick <= 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.idle"));
                }
                if (this.attackID == 6 && this.attacktick < 18) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.breathready"));
                }
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 8, event -> {
            if (this.m_6084_()) {
                if (this.attackID == 0) {
                    event.resetCurrentAnimation();
                }
                if (this.attackID == 5 && this.m_20096_() && this.attacktick < 15) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.smash_start"));
                }
                if (this.landingTick > 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                }
                if (this.attackID == 5 && !this.m_20096_()) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.jump"));
                }
                if (this.attackID == 1 && !this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.left_melee"));
                }
                if (this.attackID == 1 && this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.right_melee"));
                }
                if (this.attackID == 2 && !this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.left_melee_once"));
                }
                if (this.attackID == 2 && this.isRight()) {
                    return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.nehemoth.right_melee_once"));
                }
            }
            return PlayState.STOP;
        })});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller3", 3, event -> {
            if (!this.isStone()) {
                if (this.landingTick > 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.smash"));
                }
                if (event.isMoving() && this.f_267362_.m_267731_() > 0.35f && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.run"));
                }
                if (this.isClimbing() && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.climb"));
                }
                if (this.attackID == 4) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.roar"));
                }
                if (!this.m_6107_()) {
                    if (this.attackID == 1) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 3) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.bite"));
                    }
                    if (this.attackID == 5 && !this.m_20096_()) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.jump"));
                    }
                    if (this.attackID == 5) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 7) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.guard"));
                    }
                    if (this.attackID == 6 && this.attacktick < 18) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
                    }
                    if (this.attackID == 6) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.breath"));
                    }
                }
                if (this.m_6107_() && this.m_6084_()) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.stun"));
                }
                if (event.isMoving() && this.attackID == 0) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.walk"));
                }
            } else if (this.isStone()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.nehemoth.none"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("stompkey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.STOMP.get(), SoundSource.HOSTILE, 1.0f, 0.25f + this.m_217043_().m_188501_() * 0.1f, true);
            }
        })});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 26.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22283_, 2.0);
    }

    public static void setConfigattribute(LivingEntity entity, double hpconfig, double dmgconfig) {
        AttributeInstance attackDamageAttr;
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            double difference = maxHealthAttr.m_22115_() * hpconfig - maxHealthAttr.m_22115_();
            maxHealthAttr.m_22118_(new AttributeModifier(UUID.fromString("6d57ab59-6f61-4bb9-9fee-6a0c75aea861"), "Health config multiplier", difference, AttributeModifier.Operation.ADDITION));
            entity.m_21153_(entity.m_21233_());
        }
        if ((attackDamageAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double difference = attackDamageAttr.m_22115_() * dmgconfig - attackDamageAttr.m_22115_();
            attackDamageAttr.m_22118_(new AttributeModifier(UUID.fromString("6d57ab59-6f61-4bb9-9fee-6a0c75aea861"), "Attack config multiplier", difference, AttributeModifier.Operation.ADDITION));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Stone", this.isStone());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setStone(compound.m_128471_("Stone"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RIGHT, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
        this.f_19804_.m_135372_(STONE, (Object)false);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(IS_RIGHT);
    }

    public void setRight(boolean p_32759_) {
        this.f_19804_.m_135381_(IS_RIGHT, (Object)p_32759_);
    }

    public boolean isStone() {
        return (Boolean)this.f_19804_.m_135370_(STONE);
    }

    public void setStone(boolean p_32759_) {
        this.f_19804_.m_135381_(STONE, (Object)p_32759_);
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING);
    }

    public void setClimbing(boolean p_32759_) {
        this.f_19804_.m_135381_(CLIMBING, (Object)p_32759_);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return EntityRegistry.rollSpawn(FTSConfig.nehemothSpawnRolls, this.m_217043_(), spawnReasonIn);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (NehemothEntity.isBiomeSoulSandValley((LevelAccessor)worldIn, this.m_20183_())) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private static boolean isOverWorld(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203656_(BiomeTags.f_215817_);
    }

    private static boolean isNether(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203656_(BiomeTags.f_207612_);
    }

    private static boolean isBiomeSoulSandValley(LevelAccessor worldIn, BlockPos position) {
        return worldIn.m_204166_(position).m_203565_(Biomes.f_48199_);
    }

    public int m_5792_() {
        return 45;
    }

    public static <T extends Mob> boolean canNehemothSpawn(EntityType<NehemothEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        WorldData data = WorldData.get((ServerLevel)iServerWorld);
        return reason == MobSpawnType.SPAWNER || !iServerWorld.m_45527_(pos) && pos.m_123342_() <= 0 || NehemothEntity.isNether((LevelAccessor)iServerWorld, pos) && NehemothEntity.isBiomeSoulSandValley((LevelAccessor)iServerWorld, pos) || data != null && data.hasBeenUsed() && iServerWorld.m_46791_() != Difficulty.PEACEFUL && iServerWorld.m_8055_(pos.m_7495_()).m_280296_() && ((ServerLevel)iServerWorld).m_46462_() && NehemothEntity.isOverWorld((LevelAccessor)iServerWorld, pos) && ((ServerLevel)iServerWorld).m_46472_().equals(Level.f_46428_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public MobType m_6336_() {
        return FTSMobType.DEMON;
    }

    public boolean m_142066_() {
        return !this.isStone() && super.m_142066_();
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected void m_8099_() {
        ServerLevel serverLevel;
        WorldData tracker;
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.35, true));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackOnceGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DoubleMeleeAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BiteAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RoarGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new SmashGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new BreathGoal(this));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (!(tracker = WorldData.get(serverLevel = (ServerLevel)level)).hasBeenUsed() || this.getVariant() == 1)) {
            this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal(this));
        }
        this.f_21345_.m_25352_(0, (Goal)new GuardGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Allay.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{NehemothEntity.class}));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5, 25, true));
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else if (id == 39) {
            this.stunnedTick = 40;
        } else if (id == 45) {
            this.landingTick = 23;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity target) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = this.f_19796_.m_188503_(2) != 0 ? 1 : 2;
        }
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void spawnExpandingParticles(ParticleOptions particleType, double radius, int particleCount) {
        if (this.m_9236_().f_46443_) {
            double centerX = this.m_20185_();
            double centerY = this.m_20186_();
            double centerZ = this.m_20189_();
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double velocityX = Math.cos(angle) * radius / 10.0 + this.f_19796_.m_188500_() * 0.3;
                double velocityY = this.f_19796_.m_188500_() * 0.05;
                double velocityZ = Math.sin(angle) * radius / 10.0 + this.f_19796_.m_188500_() * 0.3;
                this.m_9236_().m_7106_(particleType, centerX, centerY, centerZ, velocityX, velocityY, velocityZ);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_274367_(1.0f);
        for (Entity passenger : this.m_20197_()) {
            Vec3 targetPos = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
            Vec3 eyePos = passenger.m_146892_();
            Vec3 dir = targetPos.m_82546_(eyePos);
            double dx = dir.f_82479_;
            double dy = dir.f_82480_;
            double dz = dir.f_82481_;
            double distXZ = Math.sqrt(dx * dx + dz * dz);
            float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Mth.m_14136_((double)dy, (double)distXZ) * 57.29577951308232));
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.m_146922_(yaw);
                living.m_146926_(pitch);
                living.f_20885_ = yaw;
                living.f_20883_ = yaw;
                if (!(living instanceof Mob)) continue;
                Mob mob = (Mob)living;
                mob.m_21563_().m_24960_((Entity)this, 30.0f, 30.0f);
                continue;
            }
            passenger.m_146922_(yaw);
            passenger.m_146926_(pitch);
        }
        if (this.growlProgress == 80.0f && this.m_6084_() && !this.isStone() && this.m_5448_() == null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.NEHEMOTH_IDLE.get(), SoundSource.HOSTILE, 0.5f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
        }
        if (!this.m_20197_().isEmpty() && ((Entity)this.m_20197_().get(0)).m_6144_() && this.attackID == 3) {
            ((Entity)this.m_20197_().get(0)).m_20260_(false);
        }
        if (this.attackID == 0) {
            this.setRight(false);
        }
        if (this.m_9236_().m_46462_()) {
            this.setStone(false);
        }
        if (this.m_9236_().f_46443_ && this.m_6084_() && this.m_5448_() != null) {
            Fromtheshadows.PROXY.playWorldSound((Object)this, (byte)0);
        }
        if (this.landingTick == 23) {
            if (this.m_9236_().f_46443_) {
                this.spawnExpandingParticles((ParticleOptions)ParticleRegistry.SHADOW.get(), 9.0, 17);
            }
            if (this.getVariant() == 0) {
                this.spawnExpandingParticles((ParticleOptions)ParticleTypes.f_123744_, 3.0, 40);
            } else {
                this.spawnExpandingParticles((ParticleOptions)ParticleTypes.f_123745_, 3.0, 40);
            }
        }
        if (this.attackID != 0) {
            ++this.attacktick;
        }
        if (this.landingTick > 0) {
            --this.landingTick;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.biteCooldown > 0) {
            --this.biteCooldown;
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.smashCooldown > 0) {
            --this.smashCooldown;
        }
        if (this.smashCooldown == 0 && this.attackID == 5) {
            this.smashCooldown = 200;
        }
        if (this.biteCooldown == 0 && this.attackID == 3) {
            this.biteCooldown = 250;
        }
        if (this.breathCooldown == 0 && this.attackID == 6) {
            this.breathCooldown = 250;
        }
        if (this.roarCooldown == 0 && this.attackID == 4) {
            this.roarCooldown = 4500;
        }
        if (this.growlProgress == 0.0f) {
            this.growlProgress = 150.0f;
        }
        if (this.growlProgress > 0.0f) {
            this.growlProgress -= 1.0f;
        }
        if (this.stunnedTick > 0) {
            --this.stunnedTick;
        }
        if (this.isStone()) {
            this.setAttackID(0);
        }
        if (this.m_6084_() && this.m_5448_() != null && this.attackID != 6) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 1.5f, 90.0f);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        Fromtheshadows.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.landingTick > 0 || this.stunnedTick > 0 || this.isStone();
    }

    public boolean m_6087_() {
        return super.m_6087_();
    }

    public boolean m_142582_(Entity p_149755_) {
        return this.landingTick <= 0 || this.stunnedTick <= 0 && super.m_142582_(p_149755_);
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        if (this.m_6084_()) {
            this.breathCooldown = 0;
            this.biteCooldown = 0;
            this.roarCooldown = 0;
            if (this.m_5448_() == null) {
                // empty if block
            }
        }
        return super.m_214076_(p_216988_, p_216989_);
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    private void smash(int distance) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(3.0))) {
                if (livingentity instanceof NehemothEntity) continue;
                livingentity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)FTSConfig.nehemoth_ranged_damage);
                this.strongKnockback((Entity)livingentity);
            }
        }
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance;
            double pz = this.m_20189_() + vz * (double)distance;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
            BlockState block = this.m_9236_().m_8055_(pos);
            BlockState blockAbove = this.m_9236_().m_8055_(abovePos);
            if (this.m_9236_().m_8055_(pos) == Blocks.f_50016_.m_49966_() || block.m_204336_(TagRegistry.NEHEMOTH_FALLING_BLOCK_IMMUNE)) continue;
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(this.m_9236_(), (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
            this.m_9236_().m_7731_(pos, block.m_60819_().m_76188_(), 3);
            fallingBlockEntity.m_5997_(this.m_217043_().m_188583_() * 0.2, 0.2 + this.m_217043_().m_188583_() * 0.2, this.m_217043_().m_188583_() * 0.2);
            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
        }
    }

    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (p_32665_ instanceof Warden) {
            return true;
        }
        if (p_32665_ instanceof NehemothEntity) {
            return true;
        }
        if (p_32665_ instanceof BulldrogiothEntity) {
            return true;
        }
        return super.m_7307_(p_32665_);
    }

    private void strongKnockback(Entity p_33340_) {
        double d0 = p_33340_.m_20185_() - this.m_20185_();
        double d1 = p_33340_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_33340_.m_5997_(d0 / d2, 0.1, d1 / d2);
    }

    protected void m_6731_(LivingEntity p_33361_) {
        if (this.f_19796_.m_188500_() < 0.5 && this.attackID == 3) {
            this.stunnedTick = 40;
            this.m_9236_().m_7605_((Entity)this, (byte)39);
            p_33361_.m_7334_((Entity)this);
        }
        p_33361_.f_19864_ = true;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, this.m_20191_().m_82377_(dX, dY, dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    public void attackInFan(double fanAngle, double fanDistance) {
        Vec3 position = this.m_20182_();
        Vec3 forward = this.m_20154_().m_82541_();
        Vec3 horizontalForward = new Vec3(forward.f_82479_, 0.0, forward.f_82481_).m_82541_();
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(fanDistance), e -> e != this);
        for (LivingEntity target : nearbyEntities) {
            Vec3 toTarget = target.m_20182_().m_82546_(position).m_82541_();
            Vec3 horizontalToTarget = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_).m_82541_();
            double distanceToTarget = target.m_20182_().m_82554_(position);
            double angleBetween = Math.acos(horizontalForward.m_82526_(horizontalToTarget)) * 57.29577951308232;
            if (!(angleBetween <= fanAngle / 2.0) || !(distanceToTarget <= fanDistance) || target instanceof NehemothEntity) continue;
            boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            if (target.m_21254_()) continue;
            target.f_19802_ = 0;
            if (!flag) continue;
            target.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 60), (Entity)this);
            target.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_GORE_SOUND.get(), 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
        }
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        this.getEntityHitboxData().getAnchorData().getAnchorPos("rider_pos").ifPresentOrElse(pos -> {
            if (passenger instanceof Player) {
                callback.m_20372_(passenger, pos.f_82479_, pos.f_82480_ + passenger.m_6049_(), pos.f_82481_);
            } else {
                callback.m_20372_(passenger, pos.f_82479_, pos.f_82480_ + passenger.m_6049_() - 0.2, pos.f_82481_);
            }
        }, () -> callback.m_20372_(passenger, this.m_20185_(), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_()));
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
    }

    private void roar() {
        if (this.m_6084_()) {
            for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 1.0, 8.0))) {
                if (livingentity instanceof NehemothEntity) continue;
                this.strongKnockback((Entity)livingentity);
            }
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return this.isStone() ? SoundEvents.f_12446_ : (SoundEvent)SoundRegistry.NEHEMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.isStone() ? SoundEvents.f_12442_ : (SoundEvent)SoundRegistry.NEHEMOTH_DEATH.get();
    }

    public float m_6100_() {
        return this.isStone() ? 1.0f : 0.4f;
    }

    protected void m_6153_() {
        if (this.isStone() && this.f_20919_ == 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        } else {
            super.m_6153_();
        }
    }

    public boolean m_6094_() {
        return !this.isStone();
    }

    private void dropCustomLootOnTrigger(Player player) {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(STONE_LOOT);
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269075_(player)).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81459_, (Object)player);
            LootParams context = builder.m_287235_(LootContextParamSets.f_81415_);
            lootTable.m_287195_(context).forEach(itemStack -> this.m_19983_((ItemStack)itemStack));
        }
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        Entity player;
        ItemStack heldItem;
        Entity attacker;
        Entity entity = p_21016_.m_7639_();
        if (!this.m_9236_().f_46443_ && (attacker = p_21016_.m_7639_()) instanceof Player && (heldItem = (player = (Player)attacker).m_21205_()).m_204117_(TagRegistry.CAN_HIT_NEHEMOTH_STATUE) && this.isStone()) {
            this.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 20, 0.3, 0.5, 0.3, 0.05);
            }
            boolean isCritical = this.isCriticalHit((Player)player);
            if (this.triggerLimit == -1) {
                this.triggerLimit = this.m_9236_().f_46441_.m_188503_(5) + 1;
            }
            if (this.triggerCount < this.triggerLimit) {
                float baseChance;
                float f = baseChance = isCritical ? 0.7f : 0.25f;
                if (this.m_9236_().f_46441_.m_188501_() < baseChance) {
                    ++this.triggerCount;
                    this.dropCustomLootOnTrigger((Player)player);
                    this.m_146870_();
                    this.m_6667_(p_21016_);
                }
            }
        }
        if (this.attackID == 7) {
            Vec3 lookDirection;
            Vec3 attackDirection;
            double dotProduct;
            player = p_21016_.m_7639_();
            if (player instanceof LivingEntity && (dotProduct = (attackDirection = (attacker = (LivingEntity)player).m_20182_().m_82546_(this.m_20182_()).m_82541_()).m_82526_(lookDirection = this.m_20154_().m_82541_())) > 0.5) {
                this.m_5496_((SoundEvent)SoundRegistry.BITE_WARN.get(), 2.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
                this.biteCooldown = 0;
                this.breathCooldown = 0;
                return false;
            }
            return super.m_6469_(p_21016_, p_21017_);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268524_)) {
            return super.m_6469_(p_21016_, p_21017_ / 6.0f);
        }
        if (this.isStone()) {
            if (p_21016_.m_269533_(DamageTypeTags.f_268738_)) {
                return super.m_6469_(p_21016_, p_21017_);
            }
            return false;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    private boolean isCriticalHit(Player player) {
        return player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean m_213854_() {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.attackID != 0 || this.isStone() || this.landingTick > 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PushReaction m_7752_() {
        return PushReaction.BLOCK;
    }

    public EntityHitboxData<NehemothEntity> getEntityHitboxData() {
        return this.hitboxData;
    }

    public boolean partHurt(MultiPart<NehemothEntity> multiPart, @NotNull DamageSource source, float amount) {
        if (multiPart.getPartName().matches("head")) {
            boolean attack;
            if (!this.m_9236_().f_46443_) {
                amount = Math.min(Float.MAX_VALUE, amount * 2.0f);
            }
            if (attack = super.m_6469_(source, amount)) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.CRITICAL_HIT.get(), SoundSource.HOSTILE, 3.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
            }
            return attack;
        }
        return this.m_6469_(source, amount / 2.0f);
    }

    class MeleeAttackOnceGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public MeleeAttackOnceGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 2;
        }

        public void m_8056_() {
            NehemothEntity.this.setRight(NehemothEntity.this.f_19796_.m_188503_(2) != 0);
            this.nehemoth.setAttackID(2);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 47;
        }

        public void m_8037_() {
            if (NehemothEntity.this.attacktick == 16 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_8128_();
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 90.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick == 17) {
                float f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (NehemothEntity.this.attacktick == 19) {
                NehemothEntity.this.attackInFan(100.0, 3.5);
                NehemothEntity.this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class DoubleMeleeAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public DoubleMeleeAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 1;
        }

        public void m_8056_() {
            NehemothEntity.this.setRight(NehemothEntity.this.f_19796_.m_188503_(2) != 0);
            this.nehemoth.setAttackID(1);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 72;
        }

        public void m_8037_() {
            float f2;
            float f1;
            if (NehemothEntity.this.attacktick == 16 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_8128_();
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 90.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick == 17) {
                f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (NehemothEntity.this.attacktick == 34 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_8128_();
                this.nehemoth.m_21563_().m_24960_((Entity)this.attackTarget, 90.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick == 35) {
                f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
            }
            if (NehemothEntity.this.attacktick == 19) {
                NehemothEntity.this.attackInFan(100.0, 3.5);
                NehemothEntity.this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            if (NehemothEntity.this.attacktick == 41) {
                NehemothEntity.this.attackInFan(100.0, 3.5);
                NehemothEntity.this.m_5496_(SoundEvents.f_12317_, 3.0f, 0.5f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class BiteAttackGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BiteAttackGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 3.0f && NehemothEntity.this.getVariant() == 0 && this.nehemoth.m_20197_().isEmpty() && NehemothEntity.this.biteCooldown == 0 && this.attackTarget.m_20205_() <= this.nehemoth.m_20205_();
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(3);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
            NehemothEntity.this.m_8127_();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 58 && this.nehemoth.attackID != 0;
        }

        public void m_8037_() {
            boolean flag;
            if (this.nehemoth.attacktick > 20 && this.attackTarget != null && !this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                this.m_8041_();
            }
            if (this.attackTarget != null && NehemothEntity.this.attacktick == 1) {
                NehemothEntity.this.m_5496_((SoundEvent)SoundRegistry.BITE_WARN.get(), 2.0f, 0.6f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
            }
            if (NehemothEntity.this.attacktick == 12) {
                float f1 = (float)Math.cos(Math.toRadians(this.nehemoth.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(this.nehemoth.m_146908_() + 90.0f));
                this.nehemoth.m_5997_((double)f1 * 0.2, 0.0, f2 * 1.0f);
            }
            if (this.nehemoth.attacktick == 16 && this.nehemoth.m_20270_((Entity)this.attackTarget) < 3.5f && this.nehemoth.m_142582_((Entity)this.attackTarget) && this.attackTarget != null && !(flag = this.attackTarget.m_21254_()) && this.attackTarget.m_20205_() < this.nehemoth.m_20205_() && this.nehemoth.m_20197_().isEmpty() && !this.attackTarget.m_6144_()) {
                this.attackTarget.m_20329_((Entity)this.nehemoth);
            }
            if (this.nehemoth.attacktick > 16) {
                double d0 = this.nehemoth.m_20185_() - this.attackTarget.m_20185_();
                double d2 = this.nehemoth.m_20189_() - this.attackTarget.m_20189_();
                double d1 = this.nehemoth.m_20186_() - 1.0 - this.attackTarget.m_20186_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
                this.attackTarget.m_146926_(NehemothEntity.updateRotation(this.attackTarget.m_146909_(), f1, 30.0f));
                this.attackTarget.m_146922_(NehemothEntity.updateRotation(this.attackTarget.m_146908_(), f, 30.0f));
            }
            if (this.nehemoth.attacktick == 34 && this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                this.nehemoth.m_9236_().m_6263_(null, this.nehemoth.m_20185_(), this.nehemoth.m_20186_(), this.nehemoth.m_20189_(), (SoundEvent)SoundRegistry.NEHEMOTH_BITE.get(), this.nehemoth.m_5720_(), 2.0f, 0.8f + (this.nehemoth.f_19796_.m_188501_() - this.nehemoth.f_19796_.m_188501_()) * 0.2f);
            }
            if (this.nehemoth.attacktick == 37 && this.nehemoth.m_20363_((Entity)this.attackTarget)) {
                this.attackTarget.m_6469_(this.nehemoth.m_269291_().m_269333_((LivingEntity)this.nehemoth), (float)this.nehemoth.m_21133_(Attributes.f_22281_));
                if (!this.attackTarget.m_21254_()) {
                    this.attackTarget.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.HEAL_BLOCK.get(), 100), (Entity)this.nehemoth);
                    NehemothEntity.this.m_5634_((float)this.nehemoth.m_21133_(Attributes.f_22281_) / 2.0f);
                }
                if (this.attackTarget.m_21254_() && this.nehemoth.f_19796_.m_188500_() < 0.5) {
                    NehemothEntity.this.m_6731_((LivingEntity)this.nehemoth);
                    NehemothEntity.this.m_20153_();
                    this.m_8041_();
                }
            }
            if (this.nehemoth.attacktick == 42 && NehemothEntity.this.m_20363_((Entity)this.attackTarget)) {
                NehemothEntity.this.m_20153_();
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class RoarGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public RoarGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.roarCooldown == 0;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(4);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 58;
        }

        public void m_8037_() {
            super.m_8037_();
            if (NehemothEntity.this.attacktick < 58 && this.attackTarget.m_6084_() && this.attackTarget != null) {
                NehemothEntity.this.m_21563_().m_24960_((Entity)this.attackTarget, 80.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick > 8 && NehemothEntity.this.attacktick < 52) {
                NehemothEntity.this.roar();
            }
            if (NehemothEntity.this.attacktick == 8) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                float f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.3, 0.0, (double)f2 * 0.3);
                SoundHelper.playSoundBasedOnDistance((Entity)this.nehemoth, (SoundEvent)SoundRegistry.NEHEMOTH_ROAR.get(), 30.0f, 2.0f, 0.7f);
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 50.0f, 0.1f, 30, 30);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class SmashGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public SmashGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            boolean hasCeilingAbove = false;
            BlockPos entityPos = this.nehemoth.m_20183_();
            for (int y = 1; y <= 7; ++y) {
                BlockPos checkPos = entityPos.m_6630_(y);
                if (this.nehemoth.m_9236_().m_8055_(checkPos).m_60795_()) continue;
                hasCeilingAbove = true;
                break;
            }
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(2) == 0 && NehemothEntity.this.smashCooldown == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) > 5.0 && !NehemothEntity.this.f_19862_ && !hasCeilingAbove;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(5);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 300 && this.nehemoth.attackID != 0;
        }

        public void m_8037_() {
            if (this.attackTarget != null && NehemothEntity.this.attacktick < 9 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_24950_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_() + (double)(this.attackTarget.m_20206_() / 2.0f), this.attackTarget.m_20189_(), 90.0f, 90.0f);
            }
            if (NehemothEntity.this.attacktick == 2) {
                float f1 = (float)Math.cos(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(NehemothEntity.this.m_146908_() + 90.0f));
                NehemothEntity.this.m_5997_((double)f1 * 0.4, 0.0, (double)f2 * 0.4);
            }
            if (NehemothEntity.this.attacktick == 9) {
                NehemothEntity.this.m_5496_((SoundEvent)SoundRegistry.NEHEMOTH_CHARGE.get(), 2.0f, 0.7f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
                NehemothEntity.this.m_20334_((this.attackTarget.m_20185_() - NehemothEntity.this.m_20185_()) * 0.21, 0.9, (this.attackTarget.m_20189_() - NehemothEntity.this.m_20189_()) * 0.21);
            }
            if (NehemothEntity.this.attacktick > 10 && NehemothEntity.this.m_20096_()) {
                Player player;
                this.nehemoth.m_9236_().m_7605_((Entity)this.nehemoth, (byte)45);
                this.attackTarget = this.nehemoth.m_5448_();
                if (this.attackTarget instanceof Player && this.attackTarget != null && (player = (Player)this.attackTarget).m_21254_()) {
                    player.m_36384_(true);
                }
                NehemothEntity.this.landingTick = 23;
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 15.0f, 0.2f, 0, 10);
                NehemothEntity.this.smash(4);
                NehemothEntity.this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.2f + NehemothEntity.this.m_217043_().m_188501_() * 0.1f);
                this.m_8041_();
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class BreathGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public BreathGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 1024.0f && NehemothEntity.this.m_20096_() && NehemothEntity.this.f_19796_.m_188503_(8) == 0 && NehemothEntity.this.getVariant() == 1 && NehemothEntity.this.breathCooldown == 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(6);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 43;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            float radius1 = 0.2f;
            if (this.nehemoth.attacktick == 1) {
                this.nehemoth.m_5496_((SoundEvent)SoundRegistry.SOUL_LASER_READY.get(), 2.0f, 0.3f + this.nehemoth.m_217043_().m_188501_() * 0.1f);
            }
            if (this.nehemoth.attacktick == 3) {
                DoomBreathEntity doomBreath = new DoomBreathEntity((EntityType<? extends DoomBreathEntity>)((EntityType)EntityRegistry.DOOM_BREATH.get()), this.nehemoth.m_9236_(), (LivingEntity)this.nehemoth, this.nehemoth.m_20185_() + (double)radius1 * Math.sin((double)(-this.nehemoth.m_146908_()) * Math.PI / 180.0), this.nehemoth.m_20186_() + 1.4, this.nehemoth.m_20189_() + (double)radius1 * Math.cos((double)(-this.nehemoth.m_146908_()) * Math.PI / 180.0), (float)((double)(this.nehemoth.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-this.nehemoth.m_146909_()) * Math.PI / 180.0), 10);
                this.nehemoth.m_9236_().m_7967_((Entity)doomBreath);
            }
            if (this.nehemoth.attacktick == 12) {
                ScreenShakeEntity.ScreenShake(NehemothEntity.this.m_9236_(), NehemothEntity.this.m_20182_(), 30.0f, 0.1f, 30, 30);
                this.nehemoth.m_5496_((SoundEvent)SoundRegistry.BREATH.get(), 4.0f, 1.0f + this.nehemoth.m_217043_().m_188501_() * 0.1f);
            }
            if (this.nehemoth.attacktick >= 15 && this.attackTarget != null) {
                this.nehemoth.m_21563_().m_24950_(this.attackTarget.m_20185_(), this.attackTarget.m_20186_() + (double)(this.attackTarget.m_20206_() / 2.0f), this.attackTarget.m_20189_(), 1.5f, 90.0f);
            }
            if (this.nehemoth.attacktick <= 14 && this.attackTarget != null) {
                NehemothEntity.this.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 90.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }

    class DoNothingGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public DoNothingGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(NehemothEntity.this.m_20185_(), NehemothEntity.this.m_20188_(), NehemothEntity.this.m_20189_());
            return NehemothEntity.this.m_9236_().m_46461_() && NehemothEntity.this.m_9236_().m_45527_((BlockPos)blockpos) && NehemothEntity.this.getVariant() == 0;
        }

        public void m_8037_() {
            NehemothEntity.this.attackID = 0;
            this.attackTarget = null;
            NehemothEntity.this.setStone(true);
        }
    }

    class GuardGoal
    extends Goal {
        private final NehemothEntity nehemoth;
        private LivingEntity attackTarget;

        public GuardGoal(NehemothEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nehemoth = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.nehemoth.m_5448_();
            return this.attackTarget != null && this.nehemoth.attackID == 0 && (double)NehemothEntity.this.m_20270_((Entity)this.attackTarget) <= 5.0 && NehemothEntity.this.f_19796_.m_188503_(2) == 0 && (this.attackTarget.f_20911_ || this.nehemoth.f_20916_ > 0);
        }

        public void m_8056_() {
            this.nehemoth.setAttackID(7);
        }

        public void m_8041_() {
            this.nehemoth.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8045_() {
            return this.nehemoth.attacktick < 20;
        }

        public void m_8037_() {
            NehemothEntity.this.f_19865_ = Vec3.f_82478_;
            if (this.nehemoth.attacktick < 20 && this.attackTarget.m_6084_()) {
                NehemothEntity.this.f_20883_ = NehemothEntity.this.f_20885_;
                NehemothEntity.this.m_21391_((Entity)this.attackTarget, 30.0f, 90.0f);
            }
            NehemothEntity.this.m_21573_().m_26569_();
        }
    }
}

