/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sonmok14.fromtheshadows.client.renderer.FTSRenderType;

public class ShadowParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float initialSize;
    private float swirlAngle;

    public ShadowParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(world, x, y, z, vx, vy, vz);
        this.sprites = sprites;
        this.f_107225_ = 40 + world.f_46441_.m_188503_(20);
        this.f_107663_ = this.initialSize = 0.5f + world.f_46441_.m_188501_() * 0.65f;
        this.f_107230_ = 0.1f;
        this.swirlAngle = world.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        this.m_108335_(sprites);
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107230_ = 0.2f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.f_107230_ < 0.01) {
            this.f_107230_ = 0.01f;
        }
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107663_ = this.initialSize + this.initialSize * progress;
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public void m_5989_() {
        super.m_5989_();
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107230_ = progress < 0.2f ? progress / 0.2f * 0.5f : (1.0f - progress) * 0.5f;
        this.f_107663_ = this.initialSize + this.initialSize * progress;
        this.swirlAngle += 0.1f;
        this.f_107215_ += Math.cos(this.swirlAngle) * 0.01;
        this.f_107217_ += Math.sin(this.swirlAngle) * 0.01;
        this.f_107215_ += (this.f_107223_.m_188500_() - 0.2) * 0.002;
        this.f_107216_ += (this.f_107223_.m_188500_() - 0.2) * 0.002;
        this.f_107217_ += (this.f_107223_.m_188500_() - 0.2) * 0.002;
        this.m_107253_(0.45f, 0.45f, 0.45f);
    }

    public ParticleRenderType m_7556_() {
        return FTSRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet p_108492_) {
            this.sprite = p_108492_;
        }

        public Particle createParticle(SimpleParticleType p_108503_, ClientLevel p_108504_, double p_108505_, double p_108506_, double p_108507_, double p_108508_, double p_108509_, double p_108510_) {
            ShadowParticle shadowParticle = new ShadowParticle(p_108504_, p_108505_, p_108506_, p_108507_, p_108508_, p_108509_, p_108510_, this.sprite);
            shadowParticle.m_108335_(this.sprite);
            return shadowParticle;
        }
    }
}

