/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sonmok14.fromtheshadows.client.renderer.misc.LightningBoltData;
import net.sonmok14.fromtheshadows.client.renderer.misc.LightningRender;
import org.joml.Vector4f;

public class LightningParticle
extends Particle {
    float progress;
    float alpha;
    private LightningRender lightningRender;
    private LightningRender lightningRenderInner;
    private LightningRender lightningRenderBg;
    private LightningBoltData redBoltData;
    private LightningBoltData whiteBoltData;

    public LightningParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z);
        this.progress = (float)this.f_107224_ / (float)this.f_107225_;
        this.alpha = 0.8f - this.progress;
        this.lightningRender = new LightningRender();
        this.lightningRenderInner = new LightningRender();
        this.lightningRenderBg = new LightningRender();
        this.m_107250_(5.0f, 5.0f);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        this.f_107215_ = 0.0 + (double)this.f_107223_.m_188501_() * 0.5;
        this.f_107216_ = 0.0 + (double)this.f_107223_.m_188501_() * 0.5;
        this.f_107217_ = 0.0 + (double)this.f_107223_.m_188501_() * 0.5;
        Vec3 lightningTo = this.findLightningToPos(this.f_107208_, x, y, z, (int)(5.0 + (double)this.f_107223_.m_188501_() * 2.5));
        Vec3 to = lightningTo.m_82492_(x, y, z);
        int sections = 4 * this.f_107225_;
        int boltLifetime = (int)(Math.ceil(to.m_82553_()) + (double)(this.f_107223_.m_188501_() * 12.0f));
        float commonBaseWidth = 0.2f + this.f_107223_.m_188501_() * 0.2f;
        float commonBranchWidth = 0.01f + this.f_107223_.m_188501_() * 0.2f;
        float commonFadeStart = 0.2f;
        float commonFadeEnd = 0.6f;
        float commonOverallAlpha = 0.5f;
        float commonSize = 0.03f + this.f_107223_.m_188501_() * 0.15f;
        float innerSizeRatio = 0.6f;
        float innerSize = commonSize * innerSizeRatio;
        int sections2 = (int)(to.m_82553_() * 3.0);
        long sharedSeed = this.f_107223_.m_188505_();
        LightningBoltData.BoltRenderInfo boltData = new LightningBoltData.BoltRenderInfo(commonBaseWidth, commonBranchWidth, commonFadeStart, commonFadeEnd, new Vector4f(0.35f, 0.25f, 0.95f, 0.75f), commonOverallAlpha);
        LightningBoltData.BoltRenderInfo innerBoltData = new LightningBoltData.BoltRenderInfo(commonBaseWidth, commonBranchWidth, commonFadeStart, commonFadeEnd, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f - this.f_107223_.m_188501_() * 0.15f), commonOverallAlpha);
        float whiteBoltYOffset = -0.1f;
        this.redBoltData = new LightningBoltData(boltData, Vec3.f_82478_, to, sections).size(commonSize).lifespan(boltLifetime + 1).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).seed(sharedSeed);
        this.lightningRender.update((Object)this, this.redBoltData, 1.0f);
        this.whiteBoltData = new LightningBoltData(innerBoltData, Vec3.f_82478_, to, sections).size(innerSize).lifespan(boltLifetime + 1).yOffset(whiteBoltYOffset).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE).seed(sharedSeed);
        this.lightningRenderInner.update((Object)this, this.whiteBoltData, 1.0f);
        LightningBoltData.BoltRenderInfo BgBoltData = new LightningBoltData.BoltRenderInfo(commonBaseWidth, commonBranchWidth, commonFadeStart, commonFadeEnd, new Vector4f(0.15f, 0.25f, 0.95f, 0.15f), commonOverallAlpha);
        LightningBoltData BgBolt = new LightningBoltData(BgBoltData, Vec3.f_82478_, to, sections).size(0.2f + this.f_107223_.m_188501_() * 0.25f).lifespan(boltLifetime).spawn(LightningBoltData.SpawnFunction.CONSECUTIVE);
        this.lightningRenderBg.update((Object)this, BgBolt, 1.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    private Vec3 findLightningToPos(ClientLevel world, double x, double y, double z, int range) {
        Vec3 vec3 = new Vec3(x, y, z);
        for (int i = 0; i < 10; ++i) {
            Vec3 vec31 = vec3.m_82520_((double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f), (double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f), (double)(this.f_107223_.m_188501_() * (float)range - (float)range / 2.0f));
            if (!this.canSeeBlock(vec3, vec31)) continue;
            return vec31;
        }
        return vec3;
    }

    private boolean canSeeBlock(Vec3 from, Vec3 to) {
        BlockHitResult result = this.f_107208_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return Vec3.m_82512_((Vec3i)result.m_82425_()).m_82554_(to) < 3.0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        posestack.m_252880_(x, y, z);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        posestack.m_252880_(0.0f, this.whiteBoltData.getYOffset(), 0.0f);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        this.lightningRenderInner.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LightningParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

