/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger f_10600_ = LogUtils.getLogger();
    protected final List<PackEntry> f_10599_ = Lists.newArrayList();
    private final PackType f_10601_;
    private final String f_10602_;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.f_10601_ = p_10605_;
        this.f_10602_ = p_10606_;
    }

    public void m_215377_(PackResources p_215378_) {
        this.m_215395_(p_215378_.m_5542_(), p_215378_, null);
    }

    public void m_215382_(PackResources p_215383_, Predicate<ResourceLocation> p_215384_) {
        this.m_215395_(p_215383_.m_5542_(), p_215383_, p_215384_);
    }

    public void m_215399_(String p_215400_, Predicate<ResourceLocation> p_215401_) {
        this.m_215395_(p_215400_, null, p_215401_);
    }

    private void m_215395_(String p_215396_, @Nullable PackResources p_215397_, @Nullable Predicate<ResourceLocation> p_215398_) {
        this.f_10599_.add(new PackEntry(p_215396_, p_215397_, p_215398_));
    }

    @Override
    public Set<String> m_7187_() {
        return ImmutableSet.of((Object)this.f_10602_);
    }

    @Override
    public Optional<Resource> m_213713_(ResourceLocation p_215419_) {
        for (int $$1 = this.f_10599_.size() - 1; $$1 >= 0; --$$1) {
            IoSupplier<InputStream> $$4;
            PackEntry $$2 = this.f_10599_.get($$1);
            PackResources $$3 = $$2.f_215433_;
            if ($$3 != null && ($$4 = $$3.m_214146_(this.f_10601_, p_215419_)) != null) {
                IoSupplier<ResourceMetadata> $$5 = this.m_215368_(p_215419_, $$1);
                return Optional.of(FallbackResourceManager.m_246164_($$3, p_215419_, $$4, $$5));
            }
            if (!$$2.m_215440_(p_215419_)) continue;
            f_10600_.warn("Resource {} not found, but was filtered by pack {}", (Object)p_215419_, (Object)$$2.f_215432_);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource m_246164_(PackResources p_249946_, ResourceLocation p_250632_, IoSupplier<InputStream> p_250514_, IoSupplier<ResourceMetadata> p_251676_) {
        return new Resource(p_249946_, FallbackResourceManager.m_246574_(p_250632_, p_249946_, p_250514_), p_251676_);
    }

    private static IoSupplier<InputStream> m_246574_(ResourceLocation p_248639_, PackResources p_251740_, IoSupplier<InputStream> p_249116_) {
        if (f_10600_.isDebugEnabled()) {
            return () -> new LeakedResourceWarningInputStream((InputStream)p_249116_.m_247737_(), p_248639_, p_251740_.m_5542_());
        }
        return p_249116_;
    }

    @Override
    public List<Resource> m_213829_(ResourceLocation p_215367_) {
        ResourceLocation $$1 = FallbackResourceManager.m_10624_(p_215367_);
        ArrayList<Resource> $$2 = new ArrayList<Resource>();
        boolean $$3 = false;
        String $$4 = null;
        for (int $$5 = this.f_10599_.size() - 1; $$5 >= 0; --$$5) {
            IoSupplier<InputStream> $$8;
            PackEntry $$6 = this.f_10599_.get($$5);
            PackResources $$7 = $$6.f_215433_;
            if ($$7 != null && ($$8 = $$7.m_214146_(this.f_10601_, p_215367_)) != null) {
                IoSupplier<ResourceMetadata> $$10;
                if ($$3) {
                    IoSupplier<ResourceMetadata> $$9 = ResourceMetadata.f_244068_;
                } else {
                    $$10 = () -> {
                        IoSupplier<InputStream> $$2 = $$7.m_214146_(this.f_10601_, $$1);
                        return $$2 != null ? FallbackResourceManager.m_246183_($$2) : ResourceMetadata.f_215577_;
                    };
                }
                $$2.add(new Resource($$7, $$8, $$10));
            }
            if ($$6.m_215440_(p_215367_)) {
                $$4 = $$6.f_215432_;
                break;
            }
            if (!$$6.m_215440_($$1)) continue;
            $$3 = true;
        }
        if ($$2.isEmpty() && $$4 != null) {
            f_10600_.warn("Resource {} not found, but was filtered by pack {}", (Object)p_215367_, $$4);
        }
        return Lists.reverse($$2);
    }

    private static boolean m_245103_(ResourceLocation p_249381_) {
        return p_249381_.m_135815_().endsWith(".mcmeta");
    }

    private static ResourceLocation m_246569_(ResourceLocation p_249669_) {
        String $$1 = p_249669_.m_135815_().substring(0, p_249669_.m_135815_().length() - ".mcmeta".length());
        return p_249669_.m_247449_($$1);
    }

    static ResourceLocation m_10624_(ResourceLocation p_10625_) {
        return p_10625_.m_247449_(p_10625_.m_135815_() + ".mcmeta");
    }

    @Override
    public Map<ResourceLocation, Resource> m_214159_(String p_215413_, Predicate<ResourceLocation> p_215414_) {
        record ResourceWithSourceAndIndex(PackResources f_243853_, IoSupplier<InputStream> f_244005_, int f_244110_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "f_243853_", "f_244005_", "f_244110_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "f_243853_", "f_244005_", "f_244110_"}, this);
            }

            @Override
            public final boolean equals(Object p_251931_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResourceWithSourceAndIndex.class, "packResources;resource;packIndex", "f_243853_", "f_244005_", "f_244110_"}, this, p_251931_);
            }
        }
        HashMap<ResourceLocation, ResourceWithSourceAndIndex> $$2 = new HashMap<ResourceLocation, ResourceWithSourceAndIndex>();
        HashMap $$3 = new HashMap();
        int $$4 = this.f_10599_.size();
        for (int $$5 = 0; $$5 < $$4; ++$$5) {
            PackEntry $$6 = this.f_10599_.get($$5);
            $$6.m_215442_($$2.keySet());
            $$6.m_215442_($$3.keySet());
            PackResources $$7 = $$6.f_215433_;
            if ($$7 == null) continue;
            int $$8 = $$5;
            $$7.m_8031_(this.f_10601_, this.f_10602_, p_215413_, (p_248254_, p_248255_) -> {
                if (FallbackResourceManager.m_245103_(p_248254_)) {
                    if (p_215414_.test(FallbackResourceManager.m_246569_(p_248254_))) {
                        $$3.put(p_248254_, new ResourceWithSourceAndIndex($$7, (IoSupplier<InputStream>)p_248255_, $$8));
                    }
                } else if (p_215414_.test((ResourceLocation)p_248254_)) {
                    $$2.put((ResourceLocation)p_248254_, new ResourceWithSourceAndIndex($$7, (IoSupplier<InputStream>)p_248255_, $$8));
                }
            });
        }
        TreeMap $$9 = Maps.newTreeMap();
        $$2.forEach((p_248258_, p_248259_) -> {
            IoSupplier<ResourceMetadata> $$7;
            ResourceLocation $$4 = FallbackResourceManager.m_10624_(p_248258_);
            ResourceWithSourceAndIndex $$5 = (ResourceWithSourceAndIndex)$$3.get($$4);
            if ($$5 != null && $$5.f_244110_ >= p_248259_.f_244110_) {
                IoSupplier<ResourceMetadata> $$6 = FallbackResourceManager.m_245722_($$5.f_244005_);
            } else {
                $$7 = ResourceMetadata.f_244068_;
            }
            $$9.put(p_248258_, FallbackResourceManager.m_246164_(p_248259_.f_243853_, p_248258_, p_248259_.f_244005_, $$7));
        });
        return $$9;
    }

    private IoSupplier<ResourceMetadata> m_215368_(ResourceLocation p_215369_, int p_215370_) {
        return () -> {
            ResourceLocation $$2 = FallbackResourceManager.m_10624_(p_215369_);
            for (int $$3 = this.f_10599_.size() - 1; $$3 >= p_215370_; --$$3) {
                IoSupplier<InputStream> $$6;
                PackEntry $$4 = this.f_10599_.get($$3);
                PackResources $$5 = $$4.f_215433_;
                if ($$5 != null && ($$6 = $$5.m_214146_(this.f_10601_, $$2)) != null) {
                    return FallbackResourceManager.m_246183_($$6);
                }
                if ($$4.m_215440_($$2)) break;
            }
            return ResourceMetadata.f_215577_;
        };
    }

    private static IoSupplier<ResourceMetadata> m_245722_(IoSupplier<InputStream> p_250827_) {
        return () -> FallbackResourceManager.m_246183_(p_250827_);
    }

    private static ResourceMetadata m_246183_(IoSupplier<InputStream> p_250103_) throws IOException {
        try (InputStream $$1 = p_250103_.m_247737_();){
            ResourceMetadata resourceMetadata = ResourceMetadata.m_215580_($$1);
            return resourceMetadata;
        }
    }

    private static void m_215392_(PackEntry p_215393_, Map<ResourceLocation, EntryStack> p_215394_) {
        for (EntryStack $$2 : p_215394_.values()) {
            if (p_215393_.m_215440_($$2.f_244439_)) {
                $$2.f_244329_.clear();
                continue;
            }
            if (!p_215393_.m_215440_($$2.f_215420_())) continue;
            $$2.f_243777_.clear();
        }
    }

    private void m_215387_(PackEntry p_215388_, String p_215389_, Predicate<ResourceLocation> p_215390_, Map<ResourceLocation, EntryStack> p_215391_) {
        PackResources $$4 = p_215388_.f_215433_;
        if ($$4 == null) {
            return;
        }
        $$4.m_8031_(this.f_10601_, this.f_10602_, p_215389_, (p_248266_, p_248267_) -> {
            if (FallbackResourceManager.m_245103_(p_248266_)) {
                ResourceLocation $$5 = FallbackResourceManager.m_246569_(p_248266_);
                if (!p_215390_.test($$5)) {
                    return;
                }
                p_248264_.computeIfAbsent($$5, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).f_243777_.put($$4, (IoSupplier<InputStream>)p_248267_);
            } else {
                if (!p_215390_.test((ResourceLocation)p_248266_)) {
                    return;
                }
                p_248264_.computeIfAbsent(p_248266_, (Function<ResourceLocation, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).f_244329_.add(new ResourceWithSource($$4, (IoSupplier<InputStream>)p_248267_));
            }
        });
    }

    @Override
    public Map<ResourceLocation, List<Resource>> m_214160_(String p_215416_, Predicate<ResourceLocation> p_215417_) {
        HashMap $$2 = Maps.newHashMap();
        for (PackEntry $$3 : this.f_10599_) {
            FallbackResourceManager.m_215392_($$3, $$2);
            this.m_215387_($$3, p_215416_, p_215417_, $$2);
        }
        TreeMap $$4 = Maps.newTreeMap();
        for (EntryStack $$5 : $$2.values()) {
            if ($$5.f_244329_.isEmpty()) continue;
            ArrayList<Resource> $$6 = new ArrayList<Resource>();
            for (ResourceWithSource $$7 : $$5.f_244329_) {
                PackResources $$8 = $$7.f_244214_;
                IoSupplier<InputStream> $$9 = $$5.f_243777_.get($$8);
                IoSupplier<ResourceMetadata> $$10 = $$9 != null ? FallbackResourceManager.m_245722_($$9) : ResourceMetadata.f_244068_;
                $$6.add(FallbackResourceManager.m_246164_($$8, $$5.f_244439_, $$7.f_244331_, $$10));
            }
            $$4.put($$5.f_244439_, $$6);
        }
        return $$4;
    }

    @Override
    public Stream<PackResources> m_7536_() {
        return this.f_10599_.stream().map(p_215386_ -> p_215386_.f_215433_).filter(Objects::nonNull);
    }

    record PackEntry(String f_215432_, @Nullable PackResources f_215433_, @Nullable Predicate<ResourceLocation> f_215434_) {
        public void m_215442_(Collection<ResourceLocation> p_215443_) {
            if (this.f_215434_ != null) {
                p_215443_.removeIf(this.f_215434_);
            }
        }

        public boolean m_215440_(ResourceLocation p_215441_) {
            return this.f_215434_ != null && this.f_215434_.test(p_215441_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this);
        }

        @Override
        public final boolean equals(Object p_215447_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PackEntry.class, "name;resources;filter", "f_215432_", "f_215433_", "f_215434_"}, this, p_215447_);
        }
    }

    record EntryStack(ResourceLocation f_244439_, ResourceLocation f_215420_, List<ResourceWithSource> f_244329_, Map<PackResources, IoSupplier<InputStream>> f_243777_) {
        EntryStack(ResourceLocation p_251350_) {
            this(p_251350_, FallbackResourceManager.m_10624_(p_251350_), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "f_244439_", "f_215420_", "f_244329_", "f_243777_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "f_244439_", "f_215420_", "f_244329_", "f_243777_"}, this);
        }

        @Override
        public final boolean equals(Object p_215429_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EntryStack.class, "fileLocation;metadataLocation;fileSources;metaSources", "f_244439_", "f_215420_", "f_244329_", "f_243777_"}, this, p_215429_);
        }
    }

    record ResourceWithSource(PackResources f_244214_, IoSupplier<InputStream> f_244331_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ResourceWithSource.class, "source;resource", "f_244214_", "f_244331_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ResourceWithSource.class, "source;resource", "f_244214_", "f_244331_"}, this);
        }

        @Override
        public final boolean equals(Object p_252143_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ResourceWithSource.class, "source;resource", "f_244214_", "f_244331_"}, this, p_252143_);
        }
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> f_10630_;
        private boolean f_10631_;

        public LeakedResourceWarningInputStream(InputStream p_10633_, ResourceLocation p_10634_, String p_10635_) {
            super(p_10633_);
            Exception $$3 = new Exception("Stacktrace");
            this.f_10630_ = () -> {
                StringWriter $$3 = new StringWriter();
                $$3.printStackTrace(new PrintWriter($$3));
                return "Leaked resource: '" + p_10634_ + "' loaded from pack: '" + p_10635_ + "'\n" + $$3;
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.f_10631_ = true;
        }

        protected void finalize() throws Throwable {
            if (!this.f_10631_) {
                f_10600_.warn("{}", (Object)this.f_10630_.get());
            }
            super.finalize();
        }
    }
}

