/*
 * Decompiled with CFR 0.152.
 */
package zank.mods.optical_js;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import zank.mods.optical_js.OpticalJS;

public record IndexableEnumComponent<T extends Enum<T>>(Class<T> type, Function<T, JsonPrimitive> toJson, BiFunction<Class<T>, JsonPrimitive, T> fromJson) implements RecipeComponent<T>
{
    private static final Function<Enum<?>, JsonPrimitive> DEFAULT_TO_JSON = e -> new JsonPrimitive(e.name().toLowerCase(Locale.ROOT));
    private static final BiFunction<Class<? extends Enum<?>>, JsonPrimitive, Enum<?>> DEFAULT_FROM_JSON = (type, json) -> {
        if (json.isNumber()) {
            int index = json.getAsInt();
            Enum[] constants = (Enum[])type.getEnumConstants();
            if (index >= 0 && index < constants.length) {
                return constants[index];
            }
        } else if (json.isString()) {
            String name = json.getAsString();
            for (Enum e : (Enum[])type.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(name)) continue;
                return e;
            }
        }
        return null;
    };

    public IndexableEnumComponent(Class<T> enumType) {
        this(enumType, IndexableEnumComponent.defaultToJson(), IndexableEnumComponent.defaultFromJson());
    }

    public static <T extends Enum<T>> Function<T, JsonPrimitive> defaultToJson() {
        return (Function)UtilsJS.cast(DEFAULT_TO_JSON);
    }

    public static <T extends Enum<T>> BiFunction<Class<T>, JsonPrimitive, T> defaultFromJson() {
        return (BiFunction)UtilsJS.cast(DEFAULT_FROM_JSON);
    }

    public Class<?> componentClass() {
        return this.type;
    }

    public JsonElement write(RecipeJS recipe, T value) {
        return (JsonElement)this.toJson.apply(value);
    }

    public T read(RecipeJS recipe, Object from) {
        if (this.type.isInstance(from)) {
            return (T)((Enum)from);
        }
        if (from == null) {
            return null;
        }
        Enum e = (Enum)this.fromJson.apply(this.type, IndexableEnumComponent.obj2Primitive(from));
        if (e == null) {
            throw new RecipeExceptionJS("Enum value '%s' of %s not found".formatted(from, this.type.getName()));
        }
        return (T)e;
    }

    public static JsonPrimitive obj2Primitive(Object from) {
        if (from instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)from;
            return p;
        }
        if (from instanceof Number) {
            Number n = (Number)from;
            return new JsonPrimitive(n);
        }
        return new JsonPrimitive(String.valueOf(from));
    }

    public TypeDescJS constructorDescription(DescriptionContext ctx) {
        Enum[] constants = (Enum[])this.type.getEnumConstants();
        TypeDescJS[] descAll = (TypeDescJS[])Stream.concat(IntStream.range(0, constants.length).boxed(), Arrays.stream(constants).map(Enum::name).map(e -> e.toLowerCase(Locale.ROOT))).map(x$0 -> OpticalJS.GSON.toJson(x$0)).map(PrimitiveDescJS::new).toArray(TypeDescJS[]::new);
        return TypeDescJS.any((TypeDescJS[])descAll);
    }
}

