/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.foundation.advancement;

import dev.bluephs.vintage.Vintage;
import dev.bluephs.vintage.foundation.advancement.SimpleVintageTrigger;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public enum VintageAdvancements {
    USE_BELT_GRINDER("use_belt_grinder"),
    USE_COILING_MACHINE("use_coiling_machine"),
    USE_COMPRESSOR("use_compressor"),
    USE_CENTRIFUGE("use_centrifuge"),
    USE_CURVING_PRESS("use_curving_press"),
    USE_HELVE("use_helve"),
    USE_LATHE("use_lathe"),
    USE_LASER("use_laser"),
    USE_VIBRATION_TABLE("use_vibration_table"),
    INSERT_RECIPE_CARD("insert_recipe_card"),
    BELT_GRINDER_SKIN_CHANGE("belt_grinder_skin_change");

    private String id;
    private SimpleVintageTrigger trigger;

    private VintageAdvancements(String id) {
        this.id = id;
        this.trigger = new SimpleVintageTrigger(id);
    }

    public void award(Level level, Player player) {
        if (level.m_5776_()) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trigger.trigger(serverPlayer);
        } else {
            Vintage.logThis("Could not award Vintage Improvements Advancement " + this.id + " to client-side Player.");
        }
    }

    public static void register() {
        for (VintageAdvancements e : VintageAdvancements.values()) {
            CriteriaTriggers.m_10595_((CriterionTrigger)e.trigger);
        }
    }
}

