/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.lathe;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.content.kinetics.lathe.LatheMenu;
import dev.bluephs.vintage.content.kinetics.lathe.TurningRecipe;
import dev.bluephs.vintage.foundation.gui.VintageGuiTextures;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class LatheScreen
extends AbstractSimiContainerScreen<LatheMenu> {
    protected VintageGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton confirmButton;
    private int startIndex = 0;
    private float scrollOffs = 0.0f;
    private boolean scrolling = false;

    public LatheScreen(LatheMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.background = VintageGuiTextures.RECIPE_CARD;
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(1, 0);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width + 4, y + this.background.height - 44, 64, 56));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + 15, y + 4, 5841956, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)VintageBlocks.LATHE_ROTATING.asStack(1)).at((float)(x + this.background.width), (float)(y + this.background.height - 56), -200.0f)).scale(5.0).render(graphics);
        int k = (int)(41.0f * this.scrollOffs);
        if (this.isScrollBarActive()) {
            VintageGuiTextures.SCROLL_ACTIVE.render(graphics, x + 118, y + 33 + k);
        } else {
            VintageGuiTextures.SCROLL_INACTIVE.render(graphics, x + 118, y + 33 + k);
        }
        this.renderButtons(graphics, mouseX, mouseY, x + 51, y + 31, this.startIndex + 12);
        this.renderRecipes(graphics, x + 51, y + 31, this.startIndex + 12);
    }

    private boolean isScrollBarActive() {
        return ((LatheMenu)this.f_97732_).getRecipes().size() > 12;
    }

    private void renderButtons(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int lastIndex) {
        for (int i = this.startIndex; i < lastIndex && i < ((LatheMenu)this.f_97732_).getRecipes().size(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            if (i == ((LatheMenu)this.f_97732_).getSelectedRecipeIndex()) {
                VintageGuiTextures.RECIPE_BUTTON_SELECTED.render(graphics, k, i1);
                continue;
            }
            if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                VintageGuiTextures.RECIPE_BUTTON_SELECTION.render(graphics, k, i1);
                continue;
            }
            VintageGuiTextures.RECIPE_BUTTON.render(graphics, k, i1);
        }
    }

    private void renderRecipes(GuiGraphics graphics, int x, int y, int lastIndex) {
        List<TurningRecipe> list = ((LatheMenu)this.f_97732_).getRecipes();
        for (int i = this.startIndex; i < lastIndex && i < ((LatheMenu)this.f_97732_).getRecipes().size(); ++i) {
            int j = i - this.startIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int i1 = y + l * 18 + 2;
            graphics.m_280480_(list.get(i).m_8043_((RegistryAccess)RegistryAccess.f_243945_), k, i1);
        }
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        if (((LatheMenu)this.f_97732_).getRecipes().size() > 0) {
            int i = this.f_97735_ + 51;
            int j = this.f_97736_ + 31;
            int k = this.startIndex + 12;
            List<TurningRecipe> recipesList = ((LatheMenu)this.f_97732_).getRecipes();
            for (int l = this.startIndex; l < k && l < ((LatheMenu)this.f_97732_).getRecipes().size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                graphics.m_280153_(this.f_96547_, recipesList.get(l).m_8043_((RegistryAccess)RegistryAccess.f_243945_), x, y);
                return;
            }
        }
        if (!((LatheMenu)this.f_97732_).m_142621_().m_41619_() || this.f_97734_ == null || this.f_97734_.f_40218_ == ((LatheMenu)this.f_97732_).playerInventory) {
            super.m_280072_(graphics, x, y);
            return;
        }
        List<Object> list = new LinkedList<Component>();
        if (this.f_97734_.m_6657_()) {
            list = this.m_280553_(this.f_97734_.m_7993_());
        }
        graphics.m_280666_(this.f_96547_, this.addToTooltip(list), x, y);
    }

    private List<Component> addToTooltip(List<Component> list) {
        list.add((Component)VintageLang.translateDirect("lathe.item_slot", new Object[0]).m_130940_(ChatFormatting.GOLD));
        return list;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollValue) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollValue / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 33;
            int j = i + 54;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, p_99324_, p_99325_, p_99326_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_99320_) {
        this.scrolling = false;
        if (!((LatheMenu)this.f_97732_).getRecipes().isEmpty()) {
            int i = this.f_97735_ + 51;
            int j = this.f_97736_ + 33;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((LatheMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((LatheMenu)this.f_97732_).f_38840_, l);
                this.f_96541_.f_91074_.m_6915_();
                return true;
            }
            i = this.f_97735_ + 118;
            j = this.f_97736_ + 33;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, p_99320_);
    }

    protected int getOffscreenRows() {
        return (((LatheMenu)this.f_97732_).getRecipes().size() + 4 - 1) / 4 - 3;
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

