/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.laser;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.bluephs.vintage.Vintage;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.content.energy.base.ElectricKineticBlockEntity;
import dev.bluephs.vintage.content.kinetics.laser.LaserBeltCallbacks;
import dev.bluephs.vintage.content.kinetics.laser.LaserBlock;
import dev.bluephs.vintage.content.kinetics.laser.LaserCuttingRecipe;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancements;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class LaserBlockEntity
extends ElectricKineticBlockEntity
implements IHaveGoggleInformation {
    private Optional<LaserCuttingRecipe> recipeCache = Optional.empty();
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    protected int poweredTimer = 0;
    int oldEnergyCount = 0;
    VintageAdvancementBehaviour advancementBehaviour;
    public BeltProcessingBehaviour processingBehaviour;

    public LaserBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public int getCapacity() {
        return Math.max((Integer)VintageConfig.server().energy.laserCapacity.get(), Math.max((Integer)VintageConfig.server().energy.laserChargeRate.get(), (Integer)VintageConfig.server().energy.laserRecipeChargeRate.get()));
    }

    @Override
    public int getMaxIn() {
        return (Integer)VintageConfig.server().energy.laserMaxInput.get();
    }

    @Override
    public int getMaxOut() {
        return 0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> LaserBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> LaserBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
        this.advancementBehaviour = new VintageAdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add(this.advancementBehaviour);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != Direction.UP;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public int getConsumption() {
        return (Integer)VintageConfig.server().energy.laserChargeRate.get();
    }

    protected BeltProcessingBehaviour.ProcessingResult onLaser(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        BeltProcessingBehaviour.ProcessingResult res = this.laserCompundAndStack(transported, handler);
        return res;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.oldEnergyCount != this.localEnergy.getEnergyStored()) {
            this.oldEnergyCount = this.localEnergy.getEnergyStored();
            this.sendData();
        }
        this.applyInWorld();
        if (this.poweredTimer > 0) {
            if (!this.isPoweredState()) {
                ((LaserBlock)((Object)VintageBlocks.LASER.get())).setPowered(this.f_58857_, this.m_58899_(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((LaserBlock)((Object)VintageBlocks.LASER.get())).setPowered(this.f_58857_, this.m_58899_(), false);
        }
    }

    protected void applyInWorld() {
        AABB bb = new AABB(this.f_58858_.m_6625_(1));
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (Entity entity : this.f_58857_.m_45933_(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.m_6084_() || !entity.m_20096_()) continue;
            if (!this.tryProcessInWorld(itemEntity)) break;
            this.poweredTimer = 10;
            this.sendData();
            break;
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.m_58900_().m_61143_((Property)LaserBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult laserCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.laserRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    private boolean laserRecipe(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.m_58904_() == null) {
            return false;
        }
        if (Mth.m_14154_((float)this.getSpeed()) == 0.0f) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).m_150930_(stack.m_41720_())) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInv), this.m_58904_());
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            LaserCuttingRecipe recipe = this.recipeCache.get();
            int energyRemoved = Math.min((Integer)VintageConfig.server().energy.laserRecipeChargeRate.get(), Math.min(recipe.getEnergy() - this.chargeAccumulator, recipe.getMaxChargeRate()));
            if ((energyRemoved = (int)((float)energyRemoved * Mth.m_14036_((float)Math.abs(this.getSpeed() / 128.0f), (float)0.1f, (float)1.0f))) == 0) {
                energyRemoved = 1;
            }
            if (Vintage.useEnergy || ((Boolean)VintageConfig.server().energy.forceEnergy.get()).booleanValue()) {
                energyRemoved = this.localEnergy.internalConsumeEnergy(energyRemoved);
            }
            this.chargeAccumulator += energyRemoved;
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack remainingStack = transported.copy();
                int inputCount = ((Ingredient)recipe.m_7527_().get(0)).m_43908_()[0].m_41613_();
                List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)inputCount), (Recipe)recipe, (boolean)true);
                ArrayList outList = new ArrayList();
                outputs.forEach(itemStack -> {
                    TransportedItemStack tmp = transported.copy();
                    tmp.stack = itemStack;
                    outList.add(tmp);
                });
                remainingStack.stack.m_41774_(inputCount);
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remainingStack));
                this.chargeAccumulator = 0;
                this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_LASER);
            }
            return true;
        }
        return false;
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity) {
        ItemStack item = itemEntity.m_32055_();
        if (this.m_58904_() == null) {
            return false;
        }
        if (Mth.m_14154_((float)this.getSpeed()) == 0.0f) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).m_150930_(item.m_41720_())) {
            this.inputInv.setStackInSlot(0, item);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInv), this.m_58904_());
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            LaserCuttingRecipe recipe = this.recipeCache.get();
            int energyRemoved = Math.min((Integer)VintageConfig.server().energy.laserRecipeChargeRate.get(), Math.min(recipe.getEnergy() - this.chargeAccumulator, recipe.getMaxChargeRate()));
            if ((energyRemoved = (int)((float)energyRemoved * Mth.m_14036_((float)Math.abs(this.getSpeed() / 128.0f), (float)0.1f, (float)1.0f))) == 0) {
                energyRemoved = 1;
            }
            if (Vintage.useEnergy || ((Boolean)VintageConfig.server().energy.forceEnergy.get()).booleanValue()) {
                energyRemoved = this.localEnergy.internalConsumeEnergy(energyRemoved);
            }
            this.chargeAccumulator += energyRemoved;
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                ItemStack itemCreated = ItemStack.f_41583_;
                for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)recipe, (boolean)true)) {
                    if (itemCreated.m_41619_()) {
                        itemCreated = result.m_41777_();
                    }
                    ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                    created.m_32060_();
                    created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                    this.f_58857_.m_7967_((Entity)created);
                }
                item.m_41774_(recipe.m_7527_().size());
                this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_LASER);
                this.chargeAccumulator = 0;
                return true;
            }
            return true;
        }
        return false;
    }

    public Optional<LaserCuttingRecipe> find(RecipeWrapper wrapper, Level world) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)wrapper.m_8020_(0), VintageRecipes.LASER_CUTTING.getType(), LaserCuttingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        return world.m_7465_().m_44015_(VintageRecipes.LASER_CUTTING.getType(), (Container)wrapper, world);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (Vintage.useEnergy || ((Boolean)VintageConfig.server().energy.forceEnergy.get()).booleanValue()) {
            VintageLang.translate("gui.goggles.energy", new Object[0]).add(Component.m_237113_((String)(" " + this.localEnergy.getEnergyStored() + "/" + this.localEnergy.getMaxEnergyStored() + "fe"))).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        }
        return true;
    }
}

