/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.compat.kubejs.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.BlockTagIngredient;
import dev.latvian.mods.kubejs.create.CreateInputFluid;
import dev.latvian.mods.kubejs.create.platform.FluidIngredientHelper;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.MapJS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public interface HammeringRecipeSchema {
    public static final RecipeKey<OutputItem[]> RESULTS = ItemComponents.OUTPUT_ARRAY.key("results");
    public static final RecipeKey<InputItem[]> INGREDIENTS = ItemComponents.INPUT_ARRAY.key("ingredients");
    public static final RecipeKey<Integer> HAMMER_BLOWS = NumberComponent.IntRange.INT.key("hammerBlows").optional((Object)1);
    public static final RecipeKey<String> ANVILBLOCK = StringComponent.ANY.key("anvilBlock").optional((Object)"").allowEmpty();
    public static final RecipeSchema HAMMERING_PROCESSING = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, HAMMER_BLOWS, ANVILBLOCK});

    public static class ProcessingRecipeJS
    extends RecipeJS {
        public InputFluid readInputFluid(Object from) {
            if (from instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)from;
                return fluid;
            }
            if (from instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)from;
                return new CreateInputFluid(fluid);
            }
            if (from instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)from;
                return new CreateInputFluid(FluidIngredientHelper.toFluidIngredient((FluidStackJS)fluid));
            }
            if (from instanceof FluidStack) {
                FluidStack fluid = (FluidStack)from;
                return new CreateInputFluid(FluidIngredient.fromFluidStack((FluidStack)fluid));
            }
            JsonObject json = MapJS.json((Object)from);
            if (json != null) {
                return new CreateInputFluid(FluidIngredient.deserialize((JsonElement)json));
            }
            return CreateInputFluid.EMPTY;
        }

        public JsonElement writeInputFluid(InputFluid value) {
            if (value instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)value;
                return fluid.ingredient().serialize();
            }
            if (value instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)value;
                return fluid.serialize();
            }
            if (value instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)value;
                return FluidIngredientHelper.toFluidIngredient((FluidStackJS)fluid).serialize();
            }
            return FluidIngredient.EMPTY.serialize();
        }

        public boolean inputItemHasPriority(Object from) {
            if (from instanceof InputItem || from instanceof Ingredient || from instanceof ItemStack) {
                return true;
            }
            InputItem input = this.readInputItem(from);
            Ingredient ingredient = input.ingredient;
            if (ingredient instanceof BlockTagIngredient) {
                BlockTagIngredient blockTag = (BlockTagIngredient)ingredient;
                return !((TagContext)TagContext.INSTANCE.getValue()).isEmpty(blockTag.getTag());
            }
            return !input.isEmpty();
        }

        public boolean inputFluidHasPriority(Object from) {
            return from instanceof InputFluid || FluidIngredient.isFluidIngredient((JsonElement)MapJS.json((Object)from));
        }

        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS anvilBlock(String anvilBlock) {
            return this.setValue(ANVILBLOCK, anvilBlock);
        }

        public RecipeJS modifyResult(OutputItem resultWithDamageNBT) {
            OutputItem[] currentResults = (OutputItem[])this.getValue(RESULTS);
            if (currentResults == null || currentResults.length == 0) {
                return this.setValue(RESULTS, new OutputItem[]{resultWithDamageNBT});
            }
            OutputItem[] newResults = new OutputItem[currentResults.length];
            boolean modifiedExisting = false;
            for (int i = 0; i < currentResults.length; ++i) {
                OutputItem currentOutput = currentResults[i];
                if (currentOutput.item.m_41720_().equals(resultWithDamageNBT.item.m_41720_())) {
                    ItemStack baseStack = currentOutput.item.m_41777_();
                    CompoundTag inputNbt = resultWithDamageNBT.item.m_41783_();
                    if (inputNbt != null && inputNbt.m_128425_("Damage", 3)) {
                        baseStack.m_41784_().m_128405_("Damage", inputNbt.m_128451_("Damage"));
                    }
                    newResults[i] = OutputItem.of((ItemStack)baseStack, (double)currentOutput.getChance());
                    modifiedExisting = true;
                    continue;
                }
                newResults[i] = currentOutput;
            }
            return this.setValue(RESULTS, newResults);
        }
    }
}

