/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.compat.jei.category;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.compat.jei.category.animations.AnimatedCurvingPress;
import dev.bluephs.vintage.content.kinetics.curving_press.CurvingPressBlockEntity;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class AutoCurvingCategory
extends CreateRecipeCategory<CraftingRecipe> {
    private final AnimatedCurvingPress press = new AnimatedCurvingPress();

    public AutoCurvingCategory(CreateRecipeCategory.Info<CraftingRecipe> info) {
        super(info);
    }

    static int getRecipeMode(CraftingRecipe recipe) {
        if (CurvingPressBlockEntity.canCurve((Recipe)recipe, 1)) {
            return 1;
        }
        if (CurvingPressBlockEntity.canCurve((Recipe)recipe, 2)) {
            return 2;
        }
        if (CurvingPressBlockEntity.canCurve((Recipe)recipe, 3)) {
            return 3;
        }
        if (CurvingPressBlockEntity.canCurve((Recipe)recipe, 4)) {
            return 4;
        }
        return 0;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        int mode = AutoCurvingCategory.getRecipeMode(recipe);
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 28).setBackground(AutoCurvingCategory.getRenderedSlot(), -1, -1).addItemStack(switch (mode) {
            case 2 -> new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
            case 3 -> new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
            case 4 -> new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
            default -> new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
        });
        if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41613_() >= 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(AutoCurvingCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(mode == 3 ? 0 : (mode < 3 ? mode - 1 : 3)));
            ProcessingOutput output = new ProcessingOutput(new ItemStack((ItemLike)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41720_()), 1.0f);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 131, 50).setBackground(AutoCurvingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(AutoCurvingCategory.addStochasticTooltip((ProcessingOutput)output));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(AutoCurvingCategory.getRenderedSlot(), -1, -1).addItemStack(new ItemStack((ItemLike)((Ingredient)recipe.m_7527_().get(mode < 3 ? mode - 1 : (mode == 3 ? 0 : 3))).m_43908_()[0].m_41720_(), 3));
            ProcessingOutput output = new ProcessingOutput(recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), 1.0f);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 131, 50).setBackground(AutoCurvingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(AutoCurvingCategory.addStochasticTooltip((ProcessingOutput)output));
        }
    }

    public void draw(CraftingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 61, 41);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 52, 54);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 23, 32);
        this.press.draw(graphics, this.getBackground().getWidth() / 2 - 17, 22, AutoCurvingCategory.getRecipeMode(recipe));
        if ((Integer)VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get() > 0) {
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"vintage.jei.text.curving_head_damage").m_130946_(": " + String.valueOf(VintageConfig.server().recipes.damageHeadAfterAutoCurvingRecipe.get())), 40, 75, 0xFFFFFF);
        }
    }
}

