/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.zipline.compat.station_decoration;

import dev.doublekekse.zipline.Cable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import top.mcmtr.mod.client.MSDMinecraftClientData;

public record StationDecorationCable(MSDMinecraftClientData data, Position startPos, Position endPos, class_243 start, class_243 end, class_243 direction, double length) implements Cable
{
    public static StationDecorationCable of(MSDMinecraftClientData data, Position startPos, Position endPos) {
        class_243 start = StationDecorationCable.toVec3(startPos);
        class_243 end = StationDecorationCable.toVec3(endPos);
        class_243 direction = end.method_1020(start).method_1029();
        double length = start.method_1022(end);
        return new StationDecorationCable(data, startPos, endPos, start, end, direction, length);
    }

    @Override
    public double getProgress(class_243 playerPos) {
        class_243 playerToStart = playerPos.method_1020(this.start);
        double t = playerToStart.method_1026(this.direction) / this.length;
        t = class_3532.method_15350((double)t, (double)0.0, (double)1.0);
        return t;
    }

    @Override
    public class_243 getPoint(double progress) {
        return this.start.method_1019(this.direction.method_1021(progress * this.length));
    }

    @Override
    public class_243 getClosestPoint(class_243 pos) {
        double t = this.getProgress(pos);
        return this.getPoint(t);
    }

    @Override
    public Collection<Cable> getNext(boolean forward) {
        if (forward) {
            Object2ObjectOpenHashMap nextEnd = (Object2ObjectOpenHashMap)this.data.positionsToCatenary.get((Object)this.endPos);
            return nextEnd.keySet().stream().map(newStartPos -> StationDecorationCable.of(this.data, this.endPos, newStartPos)).collect(Collectors.toSet());
        }
        Object2ObjectOpenHashMap nextStart = (Object2ObjectOpenHashMap)this.data.positionsToCatenary.get((Object)this.startPos);
        return nextStart.keySet().stream().map(newEndPos -> StationDecorationCable.of(this.data, this.startPos, newEndPos)).collect(Collectors.toSet());
    }

    static class_243 toVec3(Position position) {
        return new class_243((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StationDecorationCable that = (StationDecorationCable)o;
        return Objects.equals(this.endPos, that.endPos) && Objects.equals(this.startPos, that.startPos) || Objects.equals(this.endPos, that.startPos) && Objects.equals(this.startPos, that.endPos);
    }

    @Override
    public int hashCode() {
        return this.startPos.hashCode() < this.endPos.hashCode() ? Objects.hash(this.startPos, this.endPos) : Objects.hash(this.endPos, this.startPos);
    }
}

