/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.additional_attributes.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cadentem.additional_attributes.registry.AAttributes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HarvestLootAmplifier
extends LootModifier {
    public static final String ID = "harvest_loot_amplifier";
    public static final Codec<HarvestLootAmplifier> CODEC = RecordCodecBuilder.create(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HarvestLootAmplifier::new));

    public HarvestLootAmplifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81461_) || !context.m_78936_(LootContextParams.f_81455_)) {
            return generatedLoot;
        }
        BlockState state = (BlockState)context.m_165124_(LootContextParams.f_81461_);
        Entity entity = (Entity)context.m_165124_(LootContextParams.f_81455_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (state.m_204336_(BlockTags.f_13073_)) {
                generatedLoot.stream().filter(item -> item.m_204117_(Tags.Items.CROPS)).forEach(item -> item.m_41764_(AAttributes.getIntValue((LivingEntity)serverPlayer, (Attribute)AAttributes.HARVEST_BONUS.get(), item.m_41613_())));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

