/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith;

import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.obsidilith.RiftBurst;
import com.cerbon.bosses_of_mass_destruction.packet.BMDPacketHandler;
import com.cerbon.bosses_of_mass_destruction.packet.custom.SendDeltaMovementS2CPacket;
import com.cerbon.bosses_of_mass_destruction.particle.BMDParticles;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.bosses_of_mass_destruction.util.BMDUtils;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.CapabilityUtils;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BurstAction
implements IActionWithCooldown {
    private final LivingEntity entity;
    private final EventScheduler eventScheduler;
    private final List<Vec3> circlePoints;
    public static final int burstDelay = 30;

    public BurstAction(LivingEntity entity) {
        this.entity = entity;
        this.eventScheduler = CapabilityUtils.getLevelEventScheduler((Level)entity.m_9236_());
        this.circlePoints = MathUtils.buildBlockCircle((double)7.0);
    }

    @Override
    public int perform() {
        this.placeRifts();
        return 80;
    }

    private void placeRifts() {
        Level level = this.entity.m_9236_();
        RiftBurst riftBurst = new RiftBurst(this.entity, (ServerLevel)level, (ParticleOptions)BMDParticles.OBSIDILITH_BURST_INDICATOR.get(), (ParticleOptions)BMDParticles.OBSIDILITH_BURST.get(), 30, this.eventScheduler, this::damageEntity);
        SoundUtils.playSound((ServerLevel)((ServerLevel)level), (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_PREPARE_ATTACK.get()), (SoundSource)SoundSource.HOSTILE, (float)3.0f, (float)0.7f, (double)64.0, null);
        this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> SoundUtils.playSound((ServerLevel)((ServerLevel)level), (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.OBSIDILITH_BURST.get()), (SoundSource)SoundSource.HOSTILE, (float)1.2f, (double)64.0, null), 30, 1, () -> !this.entity.m_6084_()));
        for (Vec3 point : this.circlePoints) {
            riftBurst.tryPlaceRift(this.entity.m_20182_().m_82549_(point));
        }
    }

    private void damageEntity(LivingEntity livingEntity) {
        float damage = (float)this.entity.m_21133_(Attributes.f_22281_);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            BMDPacketHandler.sendToPlayer(new SendDeltaMovementS2CPacket(new Vec3(livingEntity.m_20184_().f_82479_, 1.3, livingEntity.m_20184_().f_82481_)), serverPlayer);
        }
        livingEntity.m_6469_(BMDUtils.shieldPiercing(this.entity.m_9236_(), (Entity)this.entity), damage);
    }
}

