/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm;

import com.mojang.datafixers.util.Either;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.io.IOUtils;
import shcm.shsupercm.forge.citresewn.ActiveCITs;
import shcm.shsupercm.forge.citresewn.CITResewn;
import shcm.shsupercm.forge.citresewn.config.CITResewnConfig;
import shcm.shsupercm.forge.citresewn.mixin.cititem.JsonUnbakedModelAccessor;
import shcm.shsupercm.forge.citresewn.pack.CITPack;
import shcm.shsupercm.forge.citresewn.pack.CITParser;
import shcm.shsupercm.forge.citresewn.pack.ResewnItemModelIdentifier;
import shcm.shsupercm.forge.citresewn.pack.cits.CIT;
import shcm.shsupercm.forge.citresewn.pack.cits.CITItem;

public class CITHooks {
    public static void initCITS(ResourceLocation eventId) {
        if (eventId != ModelBakery.f_119230_) {
            return;
        }
        if (CITResewn.INSTANCE.activeCITs != null) {
            CITResewn.info("Clearing active CITs..");
            CITResewn.INSTANCE.activeCITs.dispose();
            CITResewn.INSTANCE.activeCITs = null;
        }
        if (!CITResewnConfig.INSTANCE().enabled) {
            return;
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        CITResewn.info("Parsing CITs...");
        List<CITPack> parsedPacks = CITParser.parseCITs(resourceManager.m_7536_().collect(Collectors.toCollection(ArrayList::new)));
        List parsed = parsedPacks.stream().flatMap(pack -> pack.cits.stream()).collect(Collectors.toCollection(ArrayList::new));
        if (parsed.size() > 0) {
            CITResewn.info("Activating CITs...");
            CITResewn.INSTANCE.activeCITs = new ActiveCITs(parsedPacks, parsed);
        } else {
            CITResewn.info("No cit packs found.");
        }
    }

    public static void linkBakedCITItemModels(ModelBakery bakery) {
        if (CITResewn.INSTANCE.activeCITs == null) {
            return;
        }
        CITResewn.info("Linking baked models to CITItems...");
        List citItems = CITResewn.INSTANCE.activeCITs.citItems.values().stream().flatMap(Collection::stream).distinct().toList();
        for (CITItem citItem : citItems) {
            for (Map.Entry<List<ItemOverride.Predicate>, BlockModel> citModelEntry : citItem.unbakedAssets.entrySet()) {
                ResewnItemModelIdentifier resewnItemModelIdentifier = new ResewnItemModelIdentifier(citModelEntry.getValue().f_111416_);
                BakedModel newBakedModel = (BakedModel)bakery.m_119251_().get((Object)resewnItemModelIdentifier);
                if (citModelEntry.getKey() == null) {
                    citItem.bakedModel = newBakedModel;
                    continue;
                }
                if (newBakedModel == null) {
                    CITResewn.logWarnLoading("Skipping sub cit: Failed loading model for \"" + citModelEntry.getValue().f_111416_ + "\" in " + citItem.pack.resourcePack.m_5542_() + " -> " + citItem.propertiesIdentifier.m_135815_());
                    continue;
                }
                citItem.bakedSubModels.override(citModelEntry.getKey(), newBakedModel);
            }
            citItem.unbakedAssets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockModel forceLiteralResewnModelIdentifier(ResewnItemModelIdentifier identifier) {
        BlockModel blockModel;
        InputStream is = null;
        try {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            is = ((Resource)resourceManager.m_213713_((ResourceLocation)identifier).get()).m_215507_();
            BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            json.f_111416_ = identifier.toString();
            json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
            json.f_111417_.replaceAll((layer, original) -> {
                Optional left = original.left();
                if (left.isPresent()) {
                    ResourceLocation resolvedIdentifier;
                    String originalPath = ((Material)left.get()).m_119203_().m_135815_();
                    String[] split = originalPath.split("/");
                    if ((originalPath.startsWith("./") || split.length > 2 && split[1].equals("cit")) && (resolvedIdentifier = CIT.resolvePath(identifier, originalPath, ".png", resourceManager)) != null) {
                        return Either.left((Object)new Material(((Material)left.get()).m_119193_(), (ResourceLocation)new ResewnItemModelIdentifier(resolvedIdentifier)));
                    }
                }
                return original;
            });
            ResourceLocation parentId = json.getParentLocation();
            if (parentId != null) {
                String[] parentIdPathSplit = parentId.m_135815_().split("/");
                if ((parentId.m_135815_().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = CIT.resolvePath(identifier, parentId.m_135815_(), ".json", resourceManager)) != null) {
                    ((JsonUnbakedModelAccessor)json).setParentLocation(new ResewnItemModelIdentifier(parentId));
                }
            }
            json.m_111484_().replaceAll(override -> {
                ResourceLocation resolvedOverridePath;
                String[] modelIdPathSplit = override.m_111718_().m_135815_().split("/");
                if ((override.m_111718_().m_135815_().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = CIT.resolvePath(identifier, override.m_111718_().m_135815_(), ".json", resourceManager)) != null) {
                    return new ItemOverride((ResourceLocation)new ResewnItemModelIdentifier(resolvedOverridePath), override.m_173449_().collect(Collectors.toList()));
                }
                return override;
            });
            blockModel = json;
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(is);
            return null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return blockModel;
    }

    public static void addCITItemModels(ModelBakery bakery, ResourceLocation eventModelId, Map<ResourceLocation, UnbakedModel> unbakedCache, Set<ResourceLocation> loadingStack, Map<ResourceLocation, UnbakedModel> topLevelModels) {
        if (eventModelId != ModelBakery.f_119230_) {
            return;
        }
        CITHooks.initCITS(eventModelId);
        if (CITResewn.INSTANCE.activeCITs == null) {
            return;
        }
        CITResewn.info("Loading CITItem models...");
        CITResewn.INSTANCE.activeCITs.citItems.values().stream().flatMap(Collection::stream).distinct().forEach(citItem -> {
            try {
                citItem.loadUnbakedAssets(Minecraft.m_91087_().m_91098_());
                for (BlockModel unbakedModel : citItem.unbakedAssets.values()) {
                    ResewnItemModelIdentifier id = new ResewnItemModelIdentifier(unbakedModel.f_111416_);
                    unbakedCache.put(id, (UnbakedModel)unbakedModel);
                    loadingStack.addAll(unbakedModel.m_7970_());
                    topLevelModels.put(id, (UnbakedModel)unbakedModel);
                }
            }
            catch (Exception e) {
                CITResewn.logErrorLoading(e.getMessage());
            }
        });
        CITItem.GENERATED_SUB_CITS_SEEN.clear();
    }

    public static ResourceLocation getArmorTextures(ItemStack item, EquipmentSlot layer2, String overlay, WeakReference<Map<String, ResourceLocation>> armorTexturesCached) {
        if (armorTexturesCached == null) {
            return null;
        }
        Map armorTextures = (Map)armorTexturesCached.get();
        if (armorTextures == null) {
            return null;
        }
        ArmorItem armorItem = (ArmorItem)item.m_41720_();
        ResourceLocation identifier = (ResourceLocation)armorTextures.get(armorItem.m_40401_().m_6082_() + "_layer_" + (layer2 == EquipmentSlot.LEGS ? "2" : "1") + (String)(overlay == null ? "" : "_" + overlay));
        return identifier;
    }
}

